/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterInfoSaving;
import org.apache.zeppelin.notebook.NotebookAuthorizationInfoSaving;
import org.apache.zeppelin.storage.ConfigStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConfigStorage
extends ConfigStorage {
    private static Logger LOGGER = LoggerFactory.getLogger(LocalConfigStorage.class);
    private File interpreterSettingPath;
    private File authorizationPath;
    private File credentialPath;

    public LocalConfigStorage(ZeppelinConfiguration zConf) {
        super(zConf);
        this.interpreterSettingPath = new File(zConf.getInterpreterSettingPath());
        this.authorizationPath = new File(zConf.getNotebookAuthorizationPath());
        this.credentialPath = new File(zConf.getCredentialsPath());
    }

    @Override
    public void save(InterpreterInfoSaving settingInfos) throws IOException {
        LOGGER.info("Save Interpreter Setting to " + this.interpreterSettingPath.getAbsolutePath());
        this.writeToFile(settingInfos.toJson(), this.interpreterSettingPath);
    }

    @Override
    public InterpreterInfoSaving loadInterpreterSettings() throws IOException {
        if (!this.interpreterSettingPath.exists()) {
            LOGGER.warn("Interpreter Setting file {} is not existed", (Object)this.interpreterSettingPath);
            return null;
        }
        LOGGER.info("Load Interpreter Setting from file: " + this.interpreterSettingPath);
        String json = this.readFromFile(this.interpreterSettingPath);
        return this.buildInterpreterInfoSaving(json);
    }

    @Override
    public void save(NotebookAuthorizationInfoSaving authorizationInfoSaving) throws IOException {
        LOGGER.info("Save notebook authorization to file: " + this.authorizationPath);
        this.writeToFile(authorizationInfoSaving.toJson(), this.authorizationPath);
    }

    @Override
    public NotebookAuthorizationInfoSaving loadNotebookAuthorization() throws IOException {
        if (!this.authorizationPath.exists()) {
            LOGGER.warn("NotebookAuthorization file {} is not existed", (Object)this.authorizationPath);
            return null;
        }
        LOGGER.info("Load notebook authorization from file: " + this.authorizationPath);
        String json = this.readFromFile(this.authorizationPath);
        return NotebookAuthorizationInfoSaving.fromJson(json);
    }

    @Override
    public String loadCredentials() throws IOException {
        if (!this.credentialPath.exists()) {
            LOGGER.warn("Credential file {} is not existed", (Object)this.credentialPath);
            return null;
        }
        LOGGER.info("Load Credential from file: " + this.credentialPath);
        return this.readFromFile(this.credentialPath);
    }

    @Override
    public void saveCredentials(String credentials) throws IOException {
        LOGGER.info("Save Credentials to file: " + this.credentialPath);
        this.writeToFile(credentials, this.credentialPath);
    }

    private String readFromFile(File file) throws IOException {
        return IOUtils.toString((InputStream)new FileInputStream(file));
    }

    private void writeToFile(String content, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.write((String)content, (OutputStream)out);
        out.close();
    }
}

