/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.pf.joi.AbstractObjectSpy;
import org.pf.joi.ArraySpy;
import org.pf.joi.ElementFilter;
import org.pf.joi.ElementSpy;
import org.pf.joi.ElementSpyTreeNode;
import org.pf.joi.InspectionRenderer;
import org.pf.joi.InspectionView;
import org.pf.joi.InspectionWindowController;
import org.pf.joi.Inspector;
import org.pf.joi.ObjectSpyTreeNode;
import org.pf.joi.ObjectValuePanel;
import org.pf.joi.Preferences;
import org.pf.joi.Spy;
import org.pf.joi.SpyTreeNode;
import org.pf.text.StringUtil;

public class BasicInspector
extends Inspector
implements ActionListener,
TreeSelectionListener {
    protected static final int MIN_TREE_WIDTH = 100;
    protected static final int MIN_TREE_HEIGHT = 2000;
    protected static final int MIN_INFO_WIDTH = 250;
    protected static final PrintStream errorDevice = System.out;
    private InspectionWindowController controller = null;
    private InspectionView associatedView = null;
    private ObjectValuePanel contentArea = null;
    private JTextField declaredTypeField = null;
    private JTextField actualTypeField = null;
    private Spy currentElement = null;
    private JTree elementTree = null;
    private CardLayout cardLayout;
    private JPanel valueCardPanel;
    private Vector columnNames = new Vector();
    private static final String TEXT_VALUE_VIEW = "textArea";
    private static final String TABLE_VALUES_VIEW = "valuesTable";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");

    protected InspectionWindowController getController() {
        return this.controller;
    }

    protected void setController(InspectionWindowController inspectionWindowController) {
        this.controller = inspectionWindowController;
    }

    protected InspectionView getAssociatedView() {
        return this.associatedView;
    }

    protected void setAssociatedView(InspectionView inspectionView) {
        this.associatedView = inspectionView;
    }

    protected ObjectValuePanel getContentArea() {
        return this.contentArea;
    }

    protected void setContentArea(ObjectValuePanel objectValuePanel) {
        this.contentArea = objectValuePanel;
    }

    protected JTextField getDeclaredTypeField() {
        return this.declaredTypeField;
    }

    protected void setDeclaredTypeField(JTextField jTextField) {
        this.declaredTypeField = jTextField;
    }

    protected JTextField getActualTypeField() {
        return this.actualTypeField;
    }

    protected void setActualTypeField(JTextField jTextField) {
        this.actualTypeField = jTextField;
    }

    protected Spy getCurrentElement() {
        return this.currentElement;
    }

    protected void setCurrentElement(Spy spy) {
        this.currentElement = spy;
    }

    protected JTree getElementTree() {
        return this.elementTree;
    }

    protected void setElementTree(JTree jTree) {
        this.elementTree = jTree;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = null;
        SpyTreeNode spyTreeNode = null;
        Spy spy = null;
        treePath = treeSelectionEvent.getPath();
        spyTreeNode = (SpyTreeNode)treePath.getLastPathComponent();
        spy = spyTreeNode.getModel();
        this.setCurrentElement(spy);
        boolean bl = false;
        TreeNode treeNode = spyTreeNode.getParent();
        if (treeNode == null && spy instanceof AbstractObjectSpy && ((AbstractObjectSpy)spy).isRootObject()) {
            bl = true;
        }
        this.updateInformation(spy, bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("actionInspectInTab")) {
            this.inspectCurrentElement(2);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JTree jTree = null;
        TreePath treePath = null;
        jTree = (JTree)mouseEvent.getSource();
        treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        jTree.setSelectionPath(treePath);
        SpyTreeNode spyTreeNode = (SpyTreeNode)treePath.getLastPathComponent();
        Spy spy = spyTreeNode.getModel();
        boolean bl = spy.isPrimitive();
        if ((mouseEvent.getModifiers() & 0x10) > 0 && mouseEvent.getClickCount() == 2 && treePath.getParentPath() != null && !bl) {
            this.inspectCurrentElement(2);
        }
    }

    protected void inspectCurrentElement(int n) {
        if (this.getCurrentElement() != null) {
            try {
                if (n == 3) {
                    Inspector.inspect(this.getCurrentElement().getValue());
                } else {
                    Inspector.inspectIn(this.getController(), n, this.getCurrentElement().getName(), this.getCurrentElement().getValue());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(errorDevice);
            }
        }
    }

    protected void inspectObject(String string, Object object) {
        this.inspectObject(string, object, null, null, false);
    }

    protected void inspectObject(String string, Object object, String[] stringArray, String[] stringArray2, boolean bl) {
        super.inspectObject(string, object, stringArray, stringArray2, bl);
        if (this.prefs().isAutoSortOn()) {
            this.getInspectedObject().sortElements();
        }
    }

    protected String getObjectDisplayName() {
        return this.getInspectedObject().getName();
    }

    protected InspectionView getInspectionView() {
        if (this.getAssociatedView() == null) {
            this.setAssociatedView(this.buildInspectionView());
        }
        return this.getAssociatedView();
    }

    protected InspectionView buildInspectionView() {
        Serializable serializable;
        Object object;
        JSplitPane jSplitPane = null;
        JTextField jTextField = null;
        JTextField jTextField2 = null;
        JPanel jPanel = null;
        JPanel jPanel2 = null;
        JPanel jPanel3 = null;
        this.setContentArea(new ObjectValuePanel(this));
        jTextField = new JTextField();
        jTextField.setEditable(false);
        this.setDeclaredTypeField(jTextField);
        jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        this.setActualTypeField(jTextField2);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel = new JPanel(new GridLayout(2, 0));
        jPanel.add(new JLabel(" Declared: "));
        jPanel.add(new JLabel(" Actual: "));
        jPanel2.add((Component)jPanel, "West");
        jPanel = new JPanel(new GridLayout(2, 0));
        jPanel.add(jTextField);
        jPanel.add(jTextField2);
        jPanel2.add((Component)jPanel, "Center");
        this.cardLayout = new CardLayout();
        this.valueCardPanel = new JPanel(this.cardLayout);
        AbstractObjectSpy abstractObjectSpy = this.getInspectedObject();
        List list = abstractObjectSpy.getElements();
        int n = list.size();
        Vector vector = new Vector(n);
        for (int i = 0; i < n; ++i) {
            object = (Spy)list.get(i);
            serializable = new Vector<String>(3);
            try {
                String string = ((Spy)object).getName();
                ((Vector)serializable).add(string);
                String string2 = this.getValueTypeStringOf((Spy)object);
                ((Vector)serializable).add(string2);
                String string3 = this.getValueStringOf((Spy)object);
                ((Vector)serializable).add(string3);
                vector.add(serializable);
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
        this.columnNames.add("Field Name");
        this.columnNames.add("Field Type");
        this.columnNames.add("Field Value");
        ValuesTableModel valuesTableModel = new ValuesTableModel(vector, this.columnNames);
        object = new JTable(valuesTableModel);
        ((JTable)object).setAutoCreateColumnsFromModel(false);
        ((JTable)object).setSelectionMode(0);
        ((JTable)object).setAutoResizeMode(1);
        ((JComponent)object).setAutoscrolls(true);
        serializable = ((JTable)object).getTableHeader();
        ((JTableHeader)serializable).setReorderingAllowed(false);
        ((JTableHeader)serializable).getColumnModel().getColumn(2).setPreferredWidth(180);
        this.valueCardPanel.add((Component)((Object)this.getContentArea()), TEXT_VALUE_VIEW);
        this.valueCardPanel.add((Component)new JScrollPane((Component)object), TABLE_VALUES_VIEW);
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setMinimumSize(new Dimension(250, 200));
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)this.valueCardPanel, "Center");
        this.cardLayout.show(this.valueCardPanel, TABLE_VALUES_VIEW);
        jSplitPane = new JSplitPane(1, true);
        jSplitPane.setDividerLocation(this.prefs().getTreeWidth() + 38);
        jSplitPane.setDividerSize(3);
        jSplitPane.setLeftComponent(this.createTreePanel());
        jSplitPane.setRightComponent(jPanel3);
        InspectionView inspectionView = new InspectionView(this);
        inspectionView.add(jSplitPane);
        return inspectionView;
    }

    protected JMenuItem createMenuItem(String string, String string2) {
        JMenuItem jMenuItem = null;
        jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    protected JMenu createMenu(String string) {
        return new JMenu(string);
    }

    protected JComponent createTreePanel() {
        JScrollPane jScrollPane = null;
        JTree jTree = null;
        ObjectSpyTreeNode objectSpyTreeNode = null;
        InspectionRenderer inspectionRenderer = null;
        int n = 0;
        int n2 = 2000;
        objectSpyTreeNode = this.createTreeNodes();
        jTree = new JTree(objectSpyTreeNode);
        this.setElementTree(jTree);
        inspectionRenderer = new InspectionRenderer();
        jTree.setCellRenderer(inspectionRenderer);
        n = inspectionRenderer.getLeafIcon().getIconHeight() + 1;
        jTree.setRowHeight(n);
        n2 = n * (this.getInspectedObject().getFullElementCount() + 1) + 10;
        jTree.setPreferredSize(new Dimension(this.prefs().getTreeWidth(), n2));
        jTree.addTreeSelectionListener(this);
        jTree.addMouseListener(this);
        jTree.setSelectionRow(0);
        jScrollPane = new JScrollPane(jTree);
        jScrollPane.setMinimumSize(new Dimension(100, n2));
        return jScrollPane;
    }

    protected String getTypeStringOf(Spy spy) {
        if (spy instanceof ArraySpy && ((ArraySpy)spy).isRootObject()) {
            return "";
        }
        String string = "";
        string = spy.getTypeString();
        string = Modifier.toString(spy.getModifiers()) + " " + string;
        return string.trim();
    }

    protected String getValueTypeStringOf(Spy spy) {
        if (spy instanceof ArraySpy && ((ArraySpy)spy).isRootObject()) {
            return "";
        }
        String string = null;
        try {
            string = spy.getValueTypeString();
        }
        catch (Exception exception) {
            exception.printStackTrace(errorDevice);
        }
        return string;
    }

    protected String getValueStringOf(Spy spy) {
        String string = "";
        try {
            string = spy.getValueString();
        }
        catch (Exception exception) {
            exception.printStackTrace(errorDevice);
            string = exception.toString();
        }
        return string;
    }

    protected Component getValueComponentOf(Spy spy) {
        try {
            return spy.getValueComponent();
        }
        catch (Exception exception) {
            exception.printStackTrace(errorDevice);
            return null;
        }
    }

    protected Object getValueOf(Spy spy) {
        Object object;
        try {
            object = spy.getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace(errorDevice);
            object = exception.toString();
        }
        return object;
    }

    protected void updateInformation(Spy spy, boolean bl) {
        this.getDeclaredTypeField().setText(this.getTypeStringOf(spy));
        this.getActualTypeField().setText(this.getValueTypeStringOf(spy));
        if (bl) {
            this.cardLayout.show(this.valueCardPanel, TABLE_VALUES_VIEW);
        } else {
            this.cardLayout.show(this.valueCardPanel, TEXT_VALUE_VIEW);
            Component component = this.getValueComponentOf(spy);
            if (this.isVisualComponent(component)) {
                this.getContentArea().activateComponent(component);
            } else {
                this.getContentArea().activateText(this.getValueStringOf(spy));
            }
        }
    }

    protected boolean isVisualComponent(Object object) {
        return object instanceof Component && !(object instanceof Window);
    }

    protected void setFilter(ElementFilter elementFilter) {
        this.getInspectedObject().setElementFilter(elementFilter);
        this.updateDisplay();
    }

    protected void updateDisplay() {
        this.getElementTree().clearSelection();
        this.getElementTree().setModel(new DefaultTreeModel(this.createTreeNodes()));
    }

    protected void displayValueModificationError(Exception exception) {
        JOptionPane.showMessageDialog(this.getDialogOwner(), exception.toString(), "Value Modification Error", 0);
    }

    protected Integer parseToInteger(String string) throws Exception {
        return new Integer(Integer.parseInt(string.trim()));
    }

    protected Boolean parseToBoolean(String string) throws Exception {
        String string2 = string.trim();
        if ("true".equals(string2)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string2)) {
            return Boolean.FALSE;
        }
        throw new Exception("Invalid value '" + string2 + "' for boolean type.");
    }

    protected Character parseToCharacter(String string) throws Exception {
        String string2 = string.trim();
        if (string2.length() == 1) {
            return new Character(string2.charAt(0));
        }
        throw new Exception("Invalid value '" + string2 + "' for char type.");
    }

    protected Long parseToLong(String string) throws Exception {
        return new Long(Long.parseLong(string.trim()));
    }

    protected Short parseToShort(String string) throws Exception {
        return new Short(Short.parseShort(string.trim()));
    }

    protected Byte parseToByte(String string) throws Exception {
        return new Byte(Byte.parseByte(string.trim()));
    }

    protected Double parseToDouble(String string) throws Exception {
        return new Double(Double.parseDouble(string.trim()));
    }

    protected Float parseToFloat(String string) throws Exception {
        return new Float(Float.parseFloat(string.trim()));
    }

    protected ObjectSpyTreeNode createTreeNodes() {
        ObjectSpyTreeNode objectSpyTreeNode = null;
        ElementSpyTreeNode elementSpyTreeNode = null;
        Iterator iterator = null;
        objectSpyTreeNode = new ObjectSpyTreeNode(this.getInspectedObject());
        iterator = this.getInspectedObject().getElements().iterator();
        while (iterator.hasNext()) {
            elementSpyTreeNode = new ElementSpyTreeNode((ElementSpy)iterator.next());
            objectSpyTreeNode.add(elementSpyTreeNode);
        }
        return objectSpyTreeNode;
    }

    protected void sortElements() {
        if (this.getInspectedObject().sortElements()) {
            this.updateDisplay();
        }
    }

    protected ElementFilter elementFilter() {
        return this.getInspectedObject().getElementFilter();
    }

    protected Container getDialogOwner() {
        return this.getController().getMainFrame().getContentPane();
    }

    protected String getInspectorId() {
        return "BasicInspector";
    }

    protected Preferences prefs() {
        return Preferences.instance();
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    public class ValuesTableModel
    extends DefaultTableModel {
        public ValuesTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

