/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

public class ElementFilter {
    public static final int DEFAULT = -1;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int TRANSIENT = 128;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    private int modifiers = 0;
    private boolean defaultFlag = false;

    protected int getModifiers() {
        return this.modifiers;
    }

    protected void setModifiers(int n) {
        this.modifiers = n;
    }

    protected boolean getDefaultFlag() {
        return this.defaultFlag;
    }

    protected void setDefaultFlag(boolean bl) {
        this.defaultFlag = bl;
    }

    public ElementFilter(int n) {
        this.setModifiers(n);
    }

    public ElementFilter(int n, boolean bl) {
        this(n);
        this.setDefaultFlag(bl);
    }

    public boolean matchesAny(int n) {
        if (this.isDefaultVisibility(n) && this.isDefaultSet()) {
            return true;
        }
        return (n & this.getModifiers()) > 0;
    }

    public void toggleSwitch(int n) {
        int n2 = 0;
        if (n == -1) {
            this.setDefaultFlag(!this.getDefaultFlag());
        } else {
            n2 = this.getModifiers();
            n2 = (n2 & n) > 0 ? (n2 &= ~n) : (n2 |= n);
            this.setModifiers(n2);
        }
    }

    public boolean isTransientSet() {
        return this.isFlagSet(128);
    }

    public boolean isStaticSet() {
        return this.isFlagSet(8);
    }

    public boolean isFinalSet() {
        return this.isFlagSet(16);
    }

    public boolean isDefaultSet() {
        return this.getDefaultFlag();
    }

    public boolean isPublicSet() {
        return this.isFlagSet(1);
    }

    public boolean isProtectedSet() {
        return this.isFlagSet(4);
    }

    public boolean isPrivateSet() {
        return this.isFlagSet(2);
    }

    public ElementFilter copy() {
        return new ElementFilter(this.getModifiers(), this.getDefaultFlag());
    }

    protected boolean isFlagSet(int n) {
        return (this.getModifiers() & n) > 0;
    }

    protected boolean isDefaultVisibility(int n) {
        return (n & 7) == 0;
    }
}

