/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import org.pf.joi.ElementFilter;
import org.pf.joi.ImageProvider;

public class ElementFilterMenu {
    private ElementFilter elementFilter = new ElementFilter(24);
    private JCheckBoxMenuItem transientMenuItem = null;
    private JCheckBoxMenuItem staticMenuItem = null;
    private JCheckBoxMenuItem finalMenuItem = null;
    private JCheckBoxMenuItem privateMenuItem = null;
    private JCheckBoxMenuItem protectedMenuItem = null;
    private JCheckBoxMenuItem packageMenuItem = null;
    private JCheckBoxMenuItem publicMenuItem = null;

    protected ElementFilter getElementFilter() {
        return this.elementFilter;
    }

    protected void setElementFilter(ElementFilter elementFilter) {
        this.elementFilter = elementFilter;
    }

    protected JCheckBoxMenuItem getTransientMenuItem() {
        return this.transientMenuItem;
    }

    protected void setTransientMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.transientMenuItem = jCheckBoxMenuItem;
    }

    protected JCheckBoxMenuItem getStaticMenuItem() {
        return this.staticMenuItem;
    }

    protected void setStaticMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.staticMenuItem = jCheckBoxMenuItem;
    }

    protected JCheckBoxMenuItem getFinalMenuItem() {
        return this.finalMenuItem;
    }

    protected void setFinalMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.finalMenuItem = jCheckBoxMenuItem;
    }

    protected JCheckBoxMenuItem getPrivateMenuItem() {
        return this.privateMenuItem;
    }

    protected void setPrivateMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.privateMenuItem = jCheckBoxMenuItem;
    }

    protected JCheckBoxMenuItem getProtectedMenuItem() {
        return this.protectedMenuItem;
    }

    protected void setProtectedMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.protectedMenuItem = jCheckBoxMenuItem;
    }

    protected JCheckBoxMenuItem getPackageMenuItem() {
        return this.packageMenuItem;
    }

    protected void setPackageMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.packageMenuItem = jCheckBoxMenuItem;
    }

    protected JCheckBoxMenuItem getPublicMenuItem() {
        return this.publicMenuItem;
    }

    protected void setPublicMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.publicMenuItem = jCheckBoxMenuItem;
    }

    public ElementFilterMenu() {
        this.init();
    }

    public void replaceFilter(ElementFilter elementFilter) {
        this.setElementFilter(elementFilter);
        this.updateItems();
    }

    protected void init() {
        JCheckBoxMenuItem jCheckBoxMenuItem = this.createCheckMenuItem("Static", "ToggleStatic", null);
        this.setStaticMenuItem(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.createCheckMenuItem("Final", "ToggleFinal", null);
        this.setFinalMenuItem(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.createCheckMenuItem("Transient", "ToggleTransient", null);
        this.setTransientMenuItem(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.createCheckMenuItem("Private", "TogglePrivate", ImageProvider.instance().getPrivateIcon());
        this.setPrivateMenuItem(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.createCheckMenuItem("Protected", "ToggleProtected", ImageProvider.instance().getProtectedIcon());
        this.setProtectedMenuItem(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.createCheckMenuItem("Public", "TogglePublic", ImageProvider.instance().getPublicIcon());
        this.setPublicMenuItem(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.createCheckMenuItem("Default (Package)", "TogglePackage", ImageProvider.instance().getPackageIcon());
        this.setPackageMenuItem(jCheckBoxMenuItem);
        this.updateItems();
    }

    protected void updateItems() {
        this.getStaticMenuItem().setState(!this.getElementFilter().isStaticSet());
        this.getStaticMenuItem().repaint();
        this.getFinalMenuItem().setState(!this.getElementFilter().isFinalSet());
        this.getFinalMenuItem().repaint();
        this.getTransientMenuItem().setState(!this.getElementFilter().isTransientSet());
        this.getPrivateMenuItem().setState(!this.getElementFilter().isPrivateSet());
        this.getPrivateMenuItem().repaint();
        this.getProtectedMenuItem().setState(!this.getElementFilter().isProtectedSet());
        this.getPublicMenuItem().setState(!this.getElementFilter().isPublicSet());
        this.getPackageMenuItem().setState(!this.getElementFilter().isDefaultSet());
        this.getPackageMenuItem().repaint();
    }

    protected JCheckBoxMenuItem createCheckMenuItem(String string, String string2, Icon icon) {
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        jCheckBoxMenuItem = icon == null ? new JCheckBoxMenuItem(string) : new JCheckBoxMenuItem(string, icon);
        jCheckBoxMenuItem.setActionCommand(string2);
        return jCheckBoxMenuItem;
    }
}

