/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pf.joi.InspectionView;
import org.pf.joi.InspectionWindowController;
import org.pf.joi.Preferences;
import org.pf.swing.SwingUtil;
import org.pf.swing.TakeAllLayoutManager;

public class InspectionFrame
extends JFrame
implements ChangeListener,
MouseListener {
    public static final String RESOURCE_DIR = "/image/browser";
    private static final String LOGO_ICON = "/image/browser/jspacesIcon.gif";
    private InspectionWindowController controller = null;
    private JPanel contentPanel = null;
    private int elementCount = 0;
    private String _title;

    protected InspectionWindowController getController() {
        return this.controller;
    }

    protected void setController(InspectionWindowController inspectionWindowController) {
        this.controller = inspectionWindowController;
    }

    protected JPanel getContentPanel() {
        return this.contentPanel;
    }

    protected void setContentPanel(JPanel jPanel) {
        this.contentPanel = jPanel;
    }

    protected int getElementCount() {
        return this.elementCount;
    }

    protected void setElementCount(int n) {
        this.elementCount = n;
    }

    public InspectionFrame(InspectionWindowController inspectionWindowController, String string) {
        this._title = string;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.setIconImage(toolkit.getImage(this.getClass().getResource(LOGO_ICON)));
        this.setController(inspectionWindowController);
        this.initialize();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            if ((mouseEvent.getModifiers() & 4) > 0 && jTabbedPane.getSelectedIndex() != 0) {
                this.createTabPopupMenu().show(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void addInspection(InspectionView inspectionView) {
        if (this.getElementCount() == 0) {
            this.getContentPanel().add(inspectionView);
        } else {
            JTabbedPane jTabbedPane;
            if (this.getElementCount() == 1) {
                InspectionView inspectionView2 = (InspectionView)this.getContentPanel().getComponent(0);
                this.getContentPanel().removeAll();
                jTabbedPane = this.createTabbedPane(inspectionView2);
                this.getContentPanel().add(jTabbedPane);
            } else {
                jTabbedPane = this.getTabbedPane();
            }
            this.addToTabbedPane(jTabbedPane, inspectionView);
            jTabbedPane.setSelectedComponent(inspectionView);
        }
        ++this.elementCount;
    }

    public void replaceInspection(InspectionView inspectionView) {
        if (this.getElementCount() > 0) {
            if (this.getElementCount() == 1) {
                this.getContentPanel().removeAll();
                this.getContentPanel().add(inspectionView);
                this.getContentPanel().revalidate();
            } else {
                JTabbedPane jTabbedPane = this.getTabbedPane();
                int n = jTabbedPane.getSelectedIndex();
                if (n >= 0) {
                    jTabbedPane.setComponentAt(n, inspectionView);
                    jTabbedPane.setTitleAt(n, inspectionView.getDisplayName());
                }
            }
            this.getContentPanel().repaint();
            this.viewChanged(inspectionView);
        }
    }

    public void removeInspection(InspectionView inspectionView) {
        if (this.getElementCount() > 1) {
            JTabbedPane jTabbedPane = this.getTabbedPane();
            int n = jTabbedPane.indexOfComponent(inspectionView);
            if (n >= 0) {
                jTabbedPane.remove(n);
                --this.elementCount;
            }
            if (this.getElementCount() == 1) {
                InspectionView inspectionView2 = (InspectionView)jTabbedPane.getComponent(0);
                this.releaseTabbedPane(jTabbedPane);
                this.getContentPanel().removeAll();
                this.getContentPanel().add(inspectionView2);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        InspectionView inspectionView = (InspectionView)jTabbedPane.getSelectedComponent();
        this.viewChanged(inspectionView);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void initialize() {
        SwingUtil.current().centerFrame((JFrame)this, this.prefs().getWindowWidth(), this.prefs().getWindowHeight());
        this.setTitle(this.composeTitle());
        this.addWindowListener(this.getController());
        JPanel jPanel = new JPanel((LayoutManager)new TakeAllLayoutManager(this.prefs().getMainMargin()));
        this.setContentPanel(jPanel);
        this.getContentPane().add(jPanel);
    }

    protected JTabbedPane createTabbedPane(InspectionView inspectionView) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addChangeListener(this);
        jTabbedPane.addMouseListener(this);
        this.addToTabbedPane(jTabbedPane, inspectionView);
        return jTabbedPane;
    }

    protected void releaseTabbedPane(JTabbedPane jTabbedPane) {
        jTabbedPane.removeChangeListener(this);
    }

    protected void addToTabbedPane(JTabbedPane jTabbedPane, InspectionView inspectionView) {
        jTabbedPane.addTab(inspectionView.getDisplayName(), inspectionView);
    }

    protected JTabbedPane getTabbedPane() {
        return (JTabbedPane)this.getContentPanel().getComponent(0);
    }

    protected void viewChanged(InspectionView inspectionView) {
        this.getController().viewSelected(inspectionView);
        this.setTitle(this.composeTitle());
    }

    protected InspectionView getSelectedView() {
        InspectionView inspectionView = null;
        if (this.getContentPanel().getComponent(0) instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.getContentPanel().getComponent(0);
            inspectionView = (InspectionView)jTabbedPane.getSelectedComponent();
        }
        return inspectionView;
    }

    protected InspectionView[] getAllViews() {
        InspectionView[] inspectionViewArray = null;
        if (this.getContentPanel().getComponent(0) instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.getContentPanel().getComponent(0);
            int n = jTabbedPane.getTabCount();
            inspectionViewArray = new InspectionView[n];
            for (int i = 0; i < n; ++i) {
                inspectionViewArray[i] = (InspectionView)jTabbedPane.getComponentAt(i);
            }
        }
        return inspectionViewArray;
    }

    protected String composeTitle() {
        String string = this._title == null ? "Object Inspector" : this._title;
        return string;
    }

    protected JPopupMenu createTabPopupMenu() {
        JMenuItem jMenuItem = null;
        JPopupMenu jPopupMenu = null;
        jPopupMenu = new JPopupMenu();
        jMenuItem = this.createMenuItem("Close tab", "actionCloseTab");
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.createMenuItem("Close all tabs", "actionCloseAllTabs");
        return jPopupMenu;
    }

    protected JMenuItem createMenuItem(String string, String string2) {
        JMenuItem jMenuItem = null;
        jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this.getController());
        return jMenuItem;
    }

    protected Preferences prefs() {
        return Preferences.instance();
    }
}

