/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.pf.file.FileUtil;
import org.pf.joi.AbstractObjectSpy;
import org.pf.joi.BasicInspector;
import org.pf.joi.ElementFilter;
import org.pf.joi.ElementFilterMenu;
import org.pf.joi.ExportProvider;
import org.pf.joi.InspectionFrame;
import org.pf.joi.InspectionView;
import org.pf.joi.Inspector;

public class InspectionWindowController
implements ActionListener,
WindowListener {
    public static final int INSPECT_IN_CURRENT_PLACE = 1;
    public static final int INSPECT_IN_NEW_TAB = 2;
    public static final int INSPECT_IN_NEW_WINDOW = 3;
    protected static final String TXT_BASIC_INSPECT_IN_NEW_TAB = "Basic Inspect in new tab";
    protected static final String actCloseWindow = "actionCloseWindow";
    protected static final String actCloseTab = "actionCloseTab";
    protected static final String actCloseAllTabs = "actionCloseAllTabs";
    protected static final String actInspectTab = "actionInspectInTab";
    protected static final String actToggleStatic = "ToggleStatic";
    protected static final String actToggleFinal = "ToggleFinal";
    protected static final String actToggleTransient = "ToggleTransient";
    protected static final String actTogglePackage = "TogglePackage";
    protected static final String actTogglePrivate = "TogglePrivate";
    protected static final String actToggleProtected = "ToggleProtected";
    protected static final String actTogglePublic = "TogglePublic";
    protected static final int PLUGIN_INSPECTOR = 1;
    protected static final int PLUGIN_RENDERER = 2;
    protected static final int PLUGIN_EXPORTER = 3;
    private InspectionFrame mainFrame = null;
    private BasicInspector currentInspector = null;
    private ElementFilterMenu filterMenu = null;
    private String _frameTitle;

    protected InspectionFrame getMainFrame() {
        return this.mainFrame;
    }

    protected void setMainFrame(InspectionFrame inspectionFrame) {
        this.mainFrame = inspectionFrame;
    }

    protected BasicInspector getCurrentInspector() {
        return this.currentInspector;
    }

    protected void setCurrentInspector(BasicInspector basicInspector) {
        this.currentInspector = basicInspector;
    }

    protected ElementFilterMenu getFilterMenu() {
        return this.filterMenu;
    }

    protected void setFilterMenu(ElementFilterMenu elementFilterMenu) {
        this.filterMenu = elementFilterMenu;
    }

    public InspectionWindowController(String string) {
        this._frameTitle = string;
        this.setFilterMenu(new ElementFilterMenu());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(actCloseWindow)) {
            this.terminate();
        } else if (actionEvent.getActionCommand().equals(actInspectTab)) {
            this.currentInspector().inspectCurrentElement(2);
        } else if (actionEvent.getActionCommand().equals(actToggleStatic)) {
            this.toggleFilter(8);
        } else if (actionEvent.getActionCommand().equals(actToggleFinal)) {
            this.toggleFilter(16);
        } else if (actionEvent.getActionCommand().equals(actToggleTransient)) {
            this.toggleFilter(128);
        } else if (actionEvent.getActionCommand().equals(actTogglePrivate)) {
            this.toggleFilter(2);
        } else if (actionEvent.getActionCommand().equals(actToggleProtected)) {
            this.toggleFilter(4);
        } else if (actionEvent.getActionCommand().equals(actTogglePublic)) {
            this.toggleFilter(1);
        } else if (actionEvent.getActionCommand().equals(actTogglePackage)) {
            this.toggleFilter(-1);
        } else if (actionEvent.getActionCommand().equals(actCloseTab)) {
            this.closeInspectionTab(actionEvent);
        } else if (actionEvent.getActionCommand().equals(actCloseAllTabs)) {
            this.closeAllInspectionTab(actionEvent);
        } else if (actionEvent.getActionCommand().startsWith("Export|")) {
            this.exportObject(actionEvent.getActionCommand().substring("Export|".length()));
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.terminate();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    protected BasicInspector currentInspector() {
        return this.getCurrentInspector();
    }

    protected void replaceCurrentInspector(BasicInspector basicInspector) {
        this.setCurrentInspector(basicInspector);
        this.getFilterMenu().replaceFilter(this.getCurrentInspector().elementFilter());
    }

    protected void viewSelected(InspectionView inspectionView) {
        this.replaceCurrentInspector(inspectionView.getController());
    }

    protected void terminate() {
        Inspector.unregisterController(this);
        this.close();
    }

    protected void continueProcess() {
        Inspector.deactivateHalt();
    }

    protected void start(BasicInspector basicInspector) {
        this.addInspector(basicInspector);
        this.replaceCurrentInspector(basicInspector);
        this.buildUI();
        this.getMainFrame().addInspection(basicInspector.getInspectionView());
        this.openUI();
    }

    protected void close() {
        this.getMainFrame().setVisible(false);
    }

    protected void toggleFilter(int n) {
        this.getElementFilter().toggleSwitch(n);
        this.currentInspector().updateDisplay();
    }

    protected void exportObject(String string) {
        ExportProvider exportProvider = null;
        exportProvider = Inspector.findExporterNamed(string);
        if (exportProvider != null) {
            try {
                exportProvider.export(this.getInspectedObject(), this.getMainFrame());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void closeInspectionTab(ActionEvent actionEvent) {
        InspectionView inspectionView = this.getMainFrame().getSelectedView();
        if (inspectionView != null) {
            this.removeInspector(inspectionView.getController());
            this.getMainFrame().removeInspection(inspectionView);
        }
    }

    protected void closeAllInspectionTab(ActionEvent actionEvent) {
        InspectionView[] inspectionViewArray = this.getMainFrame().getAllViews();
        if (inspectionViewArray != null) {
            for (int i = 0; i < inspectionViewArray.length; ++i) {
                InspectionView inspectionView = inspectionViewArray[i];
                this.removeInspector(inspectionView.getController());
                this.getMainFrame().removeInspection(inspectionView);
            }
        }
    }

    protected void addInspector(BasicInspector basicInspector) {
        basicInspector.setController(this);
    }

    protected void removeInspector(BasicInspector basicInspector) {
        basicInspector.setController(null);
    }

    protected String getInspectorId() {
        return this.currentInspector().getInspectorId();
    }

    protected AbstractObjectSpy getInspectedObject() {
        return this.currentInspector().getInspectedObject();
    }

    protected String getInspectedObjectTypeString() {
        return this.currentInspector().getInspectedObject().getTypeString();
    }

    protected ElementFilter getElementFilter() {
        return this.getFilterMenu().getElementFilter();
    }

    protected void openUI() {
        this.getMainFrame().validate();
        this.getMainFrame().setVisible(true);
    }

    protected void openNewInspector(BasicInspector basicInspector, int n) {
        this.addInspector(basicInspector);
        switch (n) {
            case 2: {
                this.getMainFrame().addInspection(basicInspector.getInspectionView());
                break;
            }
            case 1: {
                this.getMainFrame().replaceInspection(basicInspector.getInspectionView());
                break;
            }
            default: {
                this.removeInspector(basicInspector);
                return;
            }
        }
        basicInspector.setFilter(this.getElementFilter().copy());
        this.replaceCurrentInspector(basicInspector);
    }

    protected void buildUI() {
        InspectionFrame inspectionFrame = new InspectionFrame(this, this._frameTitle);
        this.setMainFrame(inspectionFrame);
        inspectionFrame.setJMenuBar(this.createMenuBar());
    }

    protected JMenu createMenu(String string) {
        return new JMenu(string);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = null;
        jMenuBar = new JMenuBar();
        jMenuBar.add(this.createSubmenuWindow());
        jMenuBar.add(this.createSubmenuShow());
        return jMenuBar;
    }

    protected JMenu createSubmenuWindow() {
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        ExportProvider exportProvider = null;
        jMenu = this.createMenu("Window");
        String[] stringArray = Inspector.exportProviderRegistry().keys();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                exportProvider = Inspector.findExporterNamed(stringArray[i]);
                if (exportProvider == null || (string = exportProvider.exportLabel()) == null) continue;
                jMenuItem = this.createMenuItem(string, "Export|" + stringArray[i]);
                jMenu.add(jMenuItem);
            }
            jMenu.addSeparator();
        }
        jMenuItem = this.createMenuItem("Close Window", actCloseWindow);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JMenu createSubmenuShow() {
        JMenu jMenu = null;
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        jMenu = this.createMenu("Show");
        jCheckBoxMenuItem = this.getFilterMenu().getStaticMenuItem();
        jCheckBoxMenuItem.addActionListener(this);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.getFilterMenu().getFinalMenuItem();
        jCheckBoxMenuItem.addActionListener(this);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.getFilterMenu().getTransientMenuItem();
        jCheckBoxMenuItem.addActionListener(this);
        jMenu.add(jCheckBoxMenuItem);
        jMenu.addSeparator();
        jCheckBoxMenuItem = this.getFilterMenu().getPrivateMenuItem();
        jCheckBoxMenuItem.addActionListener(this);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.getFilterMenu().getProtectedMenuItem();
        jCheckBoxMenuItem.addActionListener(this);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.getFilterMenu().getPublicMenuItem();
        jCheckBoxMenuItem.addActionListener(this);
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = this.getFilterMenu().getPackageMenuItem();
        jCheckBoxMenuItem.addActionListener(this);
        jMenu.add(jCheckBoxMenuItem);
        return jMenu;
    }

    protected JMenuItem createMenuItem(String string, String string2) {
        JMenuItem jMenuItem = null;
        jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    protected FileUtil fileUtil() {
        return FileUtil.current();
    }
}

