/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.List;
import org.pf.joi.AbstractObjectSpy;
import org.pf.joi.ArraySpy;
import org.pf.joi.BasicInspector;
import org.pf.joi.ClassAssociations;
import org.pf.joi.ExportProvider;
import org.pf.joi.InspectionWindowController;
import org.pf.joi.ObjectSpy;
import org.pf.plugin.ClassRegistry;
import org.pf.plugin.PluginCollector;
import org.pf.reflect.ClassInfo;
import org.pf.text.StringUtil;

public abstract class Inspector
extends MouseAdapter {
    protected static final String PROG_NAME = "Java Object Inspector";
    protected static final String ActionSeparator = "|";
    protected static final String ExportPrefix = "Export|";
    protected static final String ImportPrefix = "Import|";
    public static final String INSPECTOR_MAPPING_FILENAME = "META-INF/joi.inspector";
    public static final String EXPORTER_MAPPING_FILENAME = "META-INF/joi.exporter";
    private static List controllerRegistry = new ArrayList();
    private static ClassAssociations inspectorBinding = null;
    private static ClassAssociations exportProviderRegistry = null;
    private static boolean haltCurrentProccess = false;
    private AbstractObjectSpy inspectedObject = null;
    static /* synthetic */ Class class$org$pf$joi$BasicInspector;
    static /* synthetic */ Class class$org$pf$joi$ExportProvider;

    protected static List getControllerRegistry() {
        return controllerRegistry;
    }

    protected static void setControllerRegistry(List list) {
        controllerRegistry = list;
    }

    protected static ClassAssociations getInspectorBinding() {
        return inspectorBinding;
    }

    protected static void setInspectorBinding(ClassAssociations classAssociations) {
        inspectorBinding = classAssociations;
    }

    protected static ClassAssociations getExportProviderRegistry() {
        return exportProviderRegistry;
    }

    protected static void setExportProviderRegistry(ClassAssociations classAssociations) {
        exportProviderRegistry = classAssociations;
    }

    protected static boolean getHaltCurrentProccess() {
        return haltCurrentProccess;
    }

    protected static void setHaltCurrentProccess(boolean bl) {
        haltCurrentProccess = bl;
    }

    protected AbstractObjectSpy getInspectedObject() {
        return this.inspectedObject;
    }

    protected void setInspectedObject(AbstractObjectSpy abstractObjectSpy) {
        this.inspectedObject = abstractObjectSpy;
    }

    public static Inspector basicInspect(Object object) {
        return Inspector.basicInspect(null, object);
    }

    public static Inspector basicInspect(String string, Object object) {
        return Inspector.launchInspectorOn(new BasicInspector(), string, object);
    }

    public static Inspector inspect(Object object) {
        return Inspector.inspect(null, object, null, null);
    }

    public static Inspector inspect(Object object, String[] stringArray, String string) {
        return Inspector.inspect(null, object, stringArray, string);
    }

    public static Inspector inspect(String string, Object object) {
        return Inspector.inspect(string, object, null, null);
    }

    public static Inspector inspect(String string, Object object, String[] stringArray, String string2) {
        return Inspector.launchInspectorOn(Inspector.getInspectorFor(object), string, object, stringArray, null, string2);
    }

    public static Inspector inspect(String string, Object object, String[] stringArray, String[] stringArray2, String string2) {
        return Inspector.launchInspectorOn(Inspector.getInspectorFor(object), string, object, stringArray, stringArray2, string2);
    }

    public static void basicInspectWait(Object object) {
        Inspector.basicInspectWait(null, object);
    }

    public static void basicInspectWait(String string, Object object) {
        Inspector.basicInspect(string, object);
        Inspector.halt();
    }

    public static void inspectWait(Object object) {
        Inspector.inspectWait(null, object);
    }

    public static void inspectWait(String string, Object object) {
        Inspector.inspect(string, object);
        Inspector.halt();
    }

    public static void bindInspector(String string, String string2) {
        Inspector.inspectorBinding();
        Inspector.basicBindInspector(string, string2);
    }

    public static AbstractObjectSpy getBasicObjectSpy(Object object) {
        return Inspector.getBasicObjectSpy(null, object);
    }

    public static AbstractObjectSpy getBasicObjectSpy(String string, Object object) {
        BasicInspector basicInspector = null;
        basicInspector = new BasicInspector();
        return basicInspector.objectSpyFor(string, object);
    }

    public static AbstractObjectSpy getObjectSpy(Object object) {
        return Inspector.getObjectSpy(null, object);
    }

    public static AbstractObjectSpy getObjectSpy(String string, Object object) {
        BasicInspector basicInspector = null;
        basicInspector = Inspector.getInspectorFor(object);
        return basicInspector.objectSpyFor(string, object);
    }

    public static void deactivateHalt() {
        Inspector.setHaltCurrentProccess(false);
    }

    public static void halt() {
        Inspector.setHaltCurrentProccess(true);
        Inspector.waitWhileHaltActive();
    }

    protected static BasicInspector inspectIn(InspectionWindowController inspectionWindowController, int n, String string, Object object) {
        BasicInspector basicInspector = Inspector.getInspectorFor(object);
        Inspector.openInspectorIn(inspectionWindowController, n, basicInspector, string, object);
        return basicInspector;
    }

    protected static BasicInspector basicInspectIn(InspectionWindowController inspectionWindowController, int n, String string, Object object) {
        BasicInspector basicInspector = new BasicInspector();
        Inspector.openInspectorIn(inspectionWindowController, n, basicInspector, string, object);
        return basicInspector;
    }

    protected static BasicInspector openInspectorIn(InspectionWindowController inspectionWindowController, int n, BasicInspector basicInspector, String string, Object object) {
        basicInspector.inspectObject(string, object);
        inspectionWindowController.openNewInspector(basicInspector, n);
        return basicInspector;
    }

    protected static Inspector launchInspectorOn(BasicInspector basicInspector, String string, Object object) {
        return Inspector.launchInspectorOn(basicInspector, string, object, null, null, null);
    }

    protected static Inspector launchInspectorOn(BasicInspector basicInspector, String string, Object object, String[] stringArray, String[] stringArray2, String string2) {
        basicInspector.inspectObject(string, object, stringArray, stringArray2, true);
        InspectionWindowController inspectionWindowController = new InspectionWindowController(string2);
        Inspector.registerController(inspectionWindowController);
        inspectionWindowController.start(basicInspector);
        return basicInspector;
    }

    protected static BasicInspector getInspectorFor(Object object) {
        BasicInspector basicInspector = null;
        ClassInfo classInfo = null;
        if (object != null && (classInfo = Inspector.findInspectorClassInfoFor(object.getClass())) != null) {
            basicInspector = (BasicInspector)classInfo.createInstance();
        }
        if (basicInspector == null) {
            basicInspector = new BasicInspector();
        }
        return basicInspector;
    }

    protected static ClassInfo findInspectorClassInfoFor(Class clazz) {
        return Inspector.inspectorBinding().findForClass(clazz);
    }

    protected static ClassAssociations inspectorBinding() {
        if (Inspector.getInspectorBinding() == null) {
            Inspector.initializeInspectorBinding();
        }
        return Inspector.getInspectorBinding();
    }

    protected static void initializeInspectorBinding() {
        Inspector.setInspectorBinding(new ClassAssociations(class$org$pf$joi$BasicInspector == null ? (class$org$pf$joi$BasicInspector = Inspector.class$("org.pf.joi.BasicInspector")) : class$org$pf$joi$BasicInspector));
        PluginCollector pluginCollector = new PluginCollector((ClassRegistry)Inspector.getInspectorBinding());
        pluginCollector.loadPlugins(INSPECTOR_MAPPING_FILENAME);
    }

    protected static void basicBindInspector(String string, String string2) {
        Inspector.getInspectorBinding().register(string, string2);
    }

    protected static void registerController(InspectionWindowController inspectionWindowController) {
        Inspector.getControllerRegistry().add(inspectionWindowController);
    }

    protected static void unregisterController(InspectionWindowController inspectionWindowController) {
        Inspector.getControllerRegistry().remove(inspectionWindowController);
    }

    protected static boolean anyInspectorActive() {
        return Inspector.getControllerRegistry().size() > 0;
    }

    protected static boolean isHaltActive() {
        return Inspector.getHaltCurrentProccess() && Inspector.anyInspectorActive();
    }

    protected static void waitWhileHaltActive() {
        while (Inspector.isHaltActive()) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
        }
    }

    protected static ClassAssociations exportProviderRegistry() {
        if (Inspector.getExportProviderRegistry() == null) {
            Inspector.initializeExportProviderRegistry();
        }
        return Inspector.getExportProviderRegistry();
    }

    protected static void initializeExportProviderRegistry() {
        Inspector.setExportProviderRegistry(new ClassAssociations(class$org$pf$joi$ExportProvider == null ? (class$org$pf$joi$ExportProvider = Inspector.class$("org.pf.joi.ExportProvider")) : class$org$pf$joi$ExportProvider));
        PluginCollector pluginCollector = new PluginCollector((ClassRegistry)Inspector.getExportProviderRegistry());
        pluginCollector.loadPlugins(EXPORTER_MAPPING_FILENAME);
    }

    protected static ExportProvider findExporterNamed(String string) {
        ExportProvider exportProvider = null;
        String string2 = string;
        if (string2.startsWith(ExportPrefix)) {
            string2 = StringUtil.current().suffix(string2, ExportPrefix);
        }
        exportProvider = (ExportProvider)Inspector.exportProviderRegistry().newInstance(string2);
        return exportProvider;
    }

    protected Inspector() {
    }

    protected void inspectObject(String string, Object object, String[] stringArray, String[] stringArray2, boolean bl) {
        AbstractObjectSpy abstractObjectSpy = null;
        abstractObjectSpy = this.objectSpyFor(string, object, stringArray, stringArray2, bl);
        this.setInspectedObject(abstractObjectSpy);
    }

    protected AbstractObjectSpy objectSpyFor(Object object, String[] stringArray, String[] stringArray2, boolean bl) {
        AbstractObjectSpy abstractObjectSpy = null;
        abstractObjectSpy = object != null && object.getClass().isArray() ? new ArraySpy(object, stringArray, stringArray2, bl) : new ObjectSpy(object, bl);
        return abstractObjectSpy;
    }

    protected AbstractObjectSpy objectSpyFor(String string, Object object) {
        return this.objectSpyFor(string, object, null, null, false);
    }

    protected AbstractObjectSpy objectSpyFor(String string, Object object, String[] stringArray, String[] stringArray2, boolean bl) {
        AbstractObjectSpy abstractObjectSpy = null;
        abstractObjectSpy = this.objectSpyFor(object, stringArray, stringArray2, bl);
        if (string != null) {
            abstractObjectSpy.setName(string);
        }
        return abstractObjectSpy;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

