/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.util.Properties;
import org.pf.file.PropertyFileLoader;
import org.pf.joi.ElementFilter;
import org.pf.util.Bool;

public class Preferences {
    protected static final String CONFIG_FILENAME = "joi.properties";
    protected static final String DEFAULT_CONFIG_FILENAME = "joi_default.properties";
    protected static final int DEFAULT_MAIN_MARGIN = 2;
    protected static final int DEFAULT_WINDOW_WIDTH = 700;
    protected static final int DEFAULT_WINDOW_HEIGHT = 500;
    protected static final int DEFAULT_TREE_WIDTH = 200;
    protected static final int DEFAULT_DOUBLE_CLICK_MODE = 3;
    protected static final int DEFAULT_MIDDLE_BUTTON_MODE = 2;
    protected static final boolean DEFAULT_AUTO_SORT = false;
    protected static final boolean DEFAULT_ALLOW_MODIFY = true;
    protected static final String OPT_DOUBLE_CLICK_ACTION = "action.doubleclick";
    protected static final String OPT_MIDDLE_BUTTON = "action.middle.button";
    protected static final String OPT_WINDOW_WIDTH = "window.width";
    protected static final String OPT_WINDOW_HEIGHT = "window.height";
    protected static final String OPT_TREE_WIDTH = "tree.width";
    protected static final String OPT_AUTO_SORT = "auto.sort";
    protected static final String OPT_ALLOW_MODIFY = "allow.modification";
    protected static final String OPT_QUOTE_STRINGS = "quote.strings";
    protected static final String OPT_STATIC_DEFAULT = "modifier.static.default";
    protected static final String OPT_FINAL_DEFAULT = "modifier.final.default";
    protected static final String OPT_TRANSIENT_DEFAULT = "modifier.transient.default";
    protected static final String OPT_PUBLIC_DEFAULT = "modifier.public.default";
    protected static final String OPT_PRIVATE_DEFAULT = "modifier.private.default";
    protected static final String OPT_PROTECTED_DEFAULT = "modifier.protected.default";
    protected static final String OPT_PACKAGE_DEFAULT = "modifier.package.default";
    protected static final String DOUBLE_CLICK_OPEN_WINDOW = "openNewWindow";
    protected static final String DOUBLE_CLICK_OPEN_TAB = "openNewTab";
    protected static final String DOUBLE_CLICK_REPLACE = "openReplaceCurrent";
    protected static final String[] MODIFIER_OPTIONS = new String[]{"modifier.static.default", "modifier.final.default", "modifier.transient.default", "modifier.private.default", "modifier.protected.default", "modifier.public.default", "modifier.package.default"};
    private static Preferences soleInstance = new Preferences();
    private int doubleClickMode = 3;
    private int middleButtonMode = 2;
    private int windowWidth = 700;
    private int windowHeight = 500;
    private int treeWidth = 200;
    private boolean autoSort = false;
    private boolean isEditingSupported = true;
    private boolean quoteStrings = true;
    private ElementFilter initialElementFilter = null;

    protected void setDoubleClickMode(int n) {
        this.doubleClickMode = n;
    }

    protected void setMiddleButtonMode(int n) {
        this.middleButtonMode = n;
    }

    protected void setWindowWidth(int n) {
        this.windowWidth = n;
    }

    protected void setWindowHeight(int n) {
        this.windowHeight = n;
    }

    protected void setTreeWidth(int n) {
        this.treeWidth = n;
    }

    protected boolean getAutoSort() {
        return this.autoSort;
    }

    protected void setAutoSort(boolean bl) {
        this.autoSort = bl;
    }

    protected void setIsEditingSupported(boolean bl) {
        this.isEditingSupported = bl;
    }

    protected void setQuoteStrings(boolean bl) {
        this.quoteStrings = bl;
    }

    protected void setInitialElementFilter(ElementFilter elementFilter) {
        this.initialElementFilter = elementFilter;
    }

    public static Preferences instance() {
        return soleInstance;
    }

    private Preferences() {
        this.initialize();
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public int getMainMargin() {
        return 2;
    }

    public int getTreeWidth() {
        return this.treeWidth;
    }

    public int getDoubleClickMode() {
        return this.doubleClickMode;
    }

    public int getMiddleButtonMode() {
        return this.middleButtonMode;
    }

    public boolean isAutoSortOn() {
        return this.getAutoSort();
    }

    public boolean isEditingSupported() {
        return this.isEditingSupported;
    }

    public boolean getQuoteStrings() {
        return this.quoteStrings;
    }

    public ElementFilter getInitialElementFilter() {
        return this.initialElementFilter.copy();
    }

    protected void initialize() {
        Properties properties = PropertyFileLoader.loadProperties((String)DEFAULT_CONFIG_FILENAME);
        Properties properties2 = PropertyFileLoader.loadProperties((String)CONFIG_FILENAME, (Properties)properties);
        if (properties2 == null) {
            properties2 = properties;
        }
        if (properties2 != null) {
            this.initialize(properties2);
        }
    }

    protected void initialize(Properties properties) {
        this.initDoubleClickAction(properties.getProperty(OPT_DOUBLE_CLICK_ACTION));
        this.initMiddleButtonAction(properties.getProperty(OPT_MIDDLE_BUTTON));
        this.initWindowWidth(properties.getProperty(OPT_WINDOW_WIDTH));
        this.initWindowHeight(properties.getProperty(OPT_WINDOW_HEIGHT));
        this.initTreeWidth(properties.getProperty(OPT_TREE_WIDTH));
        this.initAutoSort(properties.getProperty(OPT_AUTO_SORT));
        this.initAllowModify(properties.getProperty(OPT_ALLOW_MODIFY));
        this.initQuoteStrings(properties.getProperty(OPT_QUOTE_STRINGS));
        this.initInitialElementFilter(properties);
    }

    protected void initDoubleClickAction(String string) {
        int n = this.detectOpenAction(string);
        if (n >= 0) {
            this.setDoubleClickMode(n);
        }
    }

    protected void initMiddleButtonAction(String string) {
        int n = this.detectOpenAction(string);
        if (n >= 0) {
            this.setMiddleButtonMode(n);
        }
    }

    protected void initWindowWidth(String string) {
        int n = this.positiveInt(string);
        if (n >= 300) {
            this.setWindowWidth(n);
        }
    }

    protected void initWindowHeight(String string) {
        int n = this.positiveInt(string);
        if (n >= 200) {
            this.setWindowHeight(n);
        }
    }

    protected void initTreeWidth(String string) {
        int n = this.positiveInt(string);
        if (n >= 100) {
            this.setTreeWidth(n);
        }
    }

    protected void initAutoSort(String string) {
        if (string != null) {
            this.setAutoSort(Bool.isTrue((Object)string));
        }
    }

    protected void initAllowModify(String string) {
        if (string != null) {
            this.setIsEditingSupported(Bool.isTrue((Object)string));
        }
    }

    protected void initQuoteStrings(String string) {
        if (string != null) {
            this.setQuoteStrings(Bool.isTrue((Object)string));
        }
    }

    protected int positiveInt(String string) {
        int n = -1;
        if (string != null) {
            try {
                n = Integer.parseInt(string.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    protected int detectOpenAction(String string) {
        if (string != null) {
            if (DOUBLE_CLICK_OPEN_TAB.equalsIgnoreCase(string)) {
                return 2;
            }
            if (DOUBLE_CLICK_OPEN_WINDOW.equalsIgnoreCase(string)) {
                return 3;
            }
            if (DOUBLE_CLICK_REPLACE.equalsIgnoreCase(string)) {
                return 1;
            }
        }
        return -1;
    }

    protected void initInitialElementFilter(Properties properties) {
        int n = 0;
        ElementFilter elementFilter = new ElementFilter(0, false);
        this.setInitialElementFilter(elementFilter);
        for (int i = 0; i < MODIFIER_OPTIONS.length; ++i) {
            String string = properties.getProperty(MODIFIER_OPTIONS[i], "true");
            if (!Bool.isFalse((Object)string)) continue;
            if (OPT_STATIC_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                n = 8;
            } else if (OPT_FINAL_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                n = 16;
            } else if (OPT_TRANSIENT_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                n = 128;
            } else if (OPT_PUBLIC_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                n = 1;
            } else if (OPT_PRIVATE_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                n = 2;
            } else if (OPT_PROTECTED_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                n = 4;
            } else if (OPT_PACKAGE_DEFAULT.equals(MODIFIER_OPTIONS[i])) {
                n = -1;
            }
            elementFilter.toggleSwitch(n);
        }
    }
}

