/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.Component;
import org.pf.joi.ClassAssociations;
import org.pf.joi.Inspectable;
import org.pf.joi.ObjectRenderer;
import org.pf.joi.ObjectRenderer2;
import org.pf.plugin.ClassRegistry;
import org.pf.plugin.PluginCollector;
import org.pf.reflect.ClassInfo;
import org.pf.reflect.Dynamic;

public abstract class Spy {
    public static final String RENDERER_MAPPING_FILENAME = "META-INF/joi.renderer";
    protected static final String PRIMITIVE_INT = "int";
    protected static final String PRIMITIVE_LONG = "long";
    protected static final String PRIMITIVE_BOOLEAN = "boolean";
    protected static final String PRIMITIVE_DOUBLE = "double";
    protected static final String PRIMITIVE_FLOAT = "float";
    protected static final String PRIMITIVE_SHORT = "short";
    protected static final String PRIMITIVE_BYTE = "byte";
    protected static final String PRIMITIVE_CHAR = "char";
    private static ClassAssociations rendererRegistry = null;
    static /* synthetic */ Class class$org$pf$joi$ObjectRenderer;

    protected static ClassAssociations getRendererRegistry() {
        return rendererRegistry;
    }

    protected static void setRendererRegistry(ClassAssociations classAssociations) {
        rendererRegistry = classAssociations;
    }

    private static void initializeRendererRegistry() {
        Spy.setRendererRegistry(new ClassAssociations(class$org$pf$joi$ObjectRenderer == null ? (class$org$pf$joi$ObjectRenderer = Spy.class$("org.pf.joi.ObjectRenderer")) : class$org$pf$joi$ObjectRenderer));
        PluginCollector pluginCollector = new PluginCollector((ClassRegistry)Spy.getRendererRegistry());
        pluginCollector.loadPlugins(RENDERER_MAPPING_FILENAME);
    }

    private static ClassAssociations rendererRegistry() {
        if (Spy.getRendererRegistry() == null) {
            Spy.initializeRendererRegistry();
        }
        return Spy.getRendererRegistry();
    }

    public abstract String getName();

    public abstract Class getType();

    public abstract Object getValue() throws Exception;

    public abstract int getModifiers();

    public String getValueString() throws Exception {
        Object object = null;
        object = this.getValue();
        return this.objectAsString(object);
    }

    public Component getValueComponent() throws Exception {
        Object object = this.getValue();
        return this.objectAsComponent(object);
    }

    public String getTypeString() {
        return this.getTypeStringOf(this.getType());
    }

    public String getValueTypeString() throws Exception {
        Object object = null;
        String string = null;
        object = this.getValue();
        string = object == null ? "---" : (this.getType().isPrimitive() ? this.getType().getName() : this.getTypeStringOf(object.getClass()));
        return string;
    }

    public boolean valueIsNull() throws Exception {
        return this.getValue() == null;
    }

    public boolean isElementSpy() {
        return false;
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isEditable() {
        return false;
    }

    public void setValue(Object object) throws Exception {
    }

    public boolean is_int() {
        return PRIMITIVE_INT.equals(this.getType().getName());
    }

    public boolean is_long() {
        return PRIMITIVE_LONG.equals(this.getType().getName());
    }

    public boolean is_short() {
        return PRIMITIVE_SHORT.equals(this.getType().getName());
    }

    public boolean is_byte() {
        return PRIMITIVE_BYTE.equals(this.getType().getName());
    }

    public boolean is_char() {
        return PRIMITIVE_CHAR.equals(this.getType().getName());
    }

    public boolean is_boolean() {
        return PRIMITIVE_BOOLEAN.equals(this.getType().getName());
    }

    public boolean is_double() {
        return PRIMITIVE_DOUBLE.equals(this.getType().getName());
    }

    public boolean is_float() {
        return PRIMITIVE_FLOAT.equals(this.getType().getName());
    }

    protected String getTypeStringOf(Class clazz) {
        String string = null;
        if (clazz == null) {
            string = "---";
        } else if (clazz.isArray()) {
            clazz = clazz.getComponentType();
            string = clazz.getName() + "[]";
        } else {
            string = clazz.getName();
        }
        return string;
    }

    protected ObjectRenderer rendererFor(Class clazz) {
        ClassInfo classInfo = Spy.rendererRegistry().findForClass(clazz);
        if (classInfo == null) {
            return null;
        }
        return (ObjectRenderer)classInfo.createInstance();
    }

    protected String objectAsString(Object object) {
        String string = null;
        ObjectRenderer objectRenderer = null;
        if (object == null) {
            string = "null";
        } else if (object instanceof Inspectable) {
            string = ((Inspectable)object).inspectString();
        } else {
            objectRenderer = this.rendererFor(object.getClass());
            if (objectRenderer != null) {
                string = objectRenderer.inspectString(object);
            } else {
                string = this.invokeInspectString(object);
                if (string == null) {
                    string = object.toString();
                }
            }
        }
        return string;
    }

    protected Component objectAsComponent(Object object) {
        Component component = null;
        if (object == null) {
            return null;
        }
        ObjectRenderer objectRenderer = this.rendererFor(object.getClass());
        if (objectRenderer instanceof ObjectRenderer2) {
            ObjectRenderer2 objectRenderer2 = (ObjectRenderer2)objectRenderer;
            component = objectRenderer2.inspectComponent(object);
        }
        return component;
    }

    protected String invokeInspectString(Object object) {
        Object object2 = null;
        try {
            object2 = Dynamic.perform((Object)object, (String)"inspectString");
            if (!(object2 instanceof String)) {
                object2 = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String)object2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

