/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.textsearch;

import com.gigaspaces.SpaceRuntimeException;
import com.gigaspaces.query.extension.QueryExtensionEntryIterator;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;

public class LuceneQueryExtensionEntryIterator
extends QueryExtensionEntryIterator {
    private final ScoreDoc[] scores;
    private final IndexSearcher indexSearcher;
    private final DirectoryReader directoryReader;
    private int position;

    public LuceneQueryExtensionEntryIterator(ScoreDoc[] scores, IndexSearcher indexSearcher, DirectoryReader directoryReader) {
        this.scores = scores;
        this.indexSearcher = indexSearcher;
        this.directoryReader = directoryReader;
    }

    public void close() throws IOException {
        this.directoryReader.close();
        super.close();
    }

    public boolean hasNext() {
        return this.position < this.scores.length;
    }

    public String nextUid() {
        try {
            Document d = this.indexSearcher.doc(this.scores[this.position++].doc);
            return d.get("XAP_ID");
        }
        catch (IOException e) {
            throw new SpaceRuntimeException("Failed to get next item", (Throwable)e);
        }
    }
}

