/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.textsearch;

import com.gigaspaces.query.extension.QueryExtensionRuntimeInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.openspaces.textsearch.LuceneTextSearchQueryExtensionProvider;

public class LuceneTextSearchConfiguration {
    public static final String INDEX_LOCATION_FOLDER_NAME = "full_text_search";
    public static final String FILE_SEPARATOR = File.separator;
    public static final String STORAGE_LOCATION = "lucene.storage.location";
    public static final String STORAGE_DIRECTORY_TYPE = "lucene.storage.directory-type";
    public static final String STORAGE_DIRECTORYTYPE_DEFAULT = SupportedDirectory.MMapDirectory.name();
    public static final String MAX_UNCOMMITED_CHANGES = "lucene.max-uncommitted-changes";
    public static final String DEFAULT_MAX_UNCOMMITED_CHANGES = "1000";
    public static final String MAX_RESULTS = "lucene.max-results";
    private static final String DEFAULT_MAX_RESULTS = String.valueOf(Integer.MAX_VALUE);
    public static final Class<StandardAnalyzer> DEFAULT_ANALYZER_CLASS = StandardAnalyzer.class;
    private final DirectoryFactory _directoryFactory;
    private final int _maxUncommittedChanges;
    private final String _location;
    private final int _maxResults;
    private final Analyzer _defaultAnalyzer;

    public LuceneTextSearchConfiguration(LuceneTextSearchQueryExtensionProvider provider, QueryExtensionRuntimeInfo info) {
        this._directoryFactory = this.createDirectoryFactory(provider);
        this._location = this.initLocation(provider, info);
        this._maxUncommittedChanges = this.initMaxUncommittedChanges(provider);
        this._maxResults = this.initMaxResults(provider);
        this._defaultAnalyzer = this.initDefaultAnalyzer();
    }

    private int initMaxUncommittedChanges(LuceneTextSearchQueryExtensionProvider provider) {
        return Integer.parseInt(provider.getCustomProperty(MAX_UNCOMMITED_CHANGES, DEFAULT_MAX_UNCOMMITED_CHANGES));
    }

    private int initMaxResults(LuceneTextSearchQueryExtensionProvider provider) {
        return Integer.parseInt(provider.getCustomProperty(MAX_RESULTS, DEFAULT_MAX_RESULTS));
    }

    private Analyzer initDefaultAnalyzer() {
        return LuceneTextSearchConfiguration.createAnalyzer(DEFAULT_ANALYZER_CLASS);
    }

    private String initLocation(LuceneTextSearchQueryExtensionProvider provider, QueryExtensionRuntimeInfo info) {
        String location = provider.getCustomProperty(STORAGE_LOCATION, null);
        if (location == null) {
            location = info.getSpaceInstanceWorkDirectory();
            if (location == null) {
                location = System.getProperty("user.dir") + FILE_SEPARATOR + "xap";
            }
            location = location + FILE_SEPARATOR + INDEX_LOCATION_FOLDER_NAME;
        }
        String spaceInstanceName = info.getSpaceInstanceName().replace(".", "-");
        return location + FILE_SEPARATOR + spaceInstanceName;
    }

    protected DirectoryFactory createDirectoryFactory(LuceneTextSearchQueryExtensionProvider provider) {
        String directoryType = provider.getCustomProperty(STORAGE_DIRECTORY_TYPE, STORAGE_DIRECTORYTYPE_DEFAULT);
        SupportedDirectory directory = SupportedDirectory.byName(directoryType);
        switch (directory) {
            case MMapDirectory: {
                return new DirectoryFactory(){

                    @Override
                    public Directory getDirectory(String relativePath) throws IOException {
                        return new MMapDirectory(Paths.get(LuceneTextSearchConfiguration.this._location + FILE_SEPARATOR + relativePath, new String[0]));
                    }
                };
            }
            case RAMDirectory: {
                return new DirectoryFactory(){

                    @Override
                    public Directory getDirectory(String path) throws IOException {
                        return new RAMDirectory();
                    }
                };
            }
        }
        throw new RuntimeException("Unhandled directory type " + (Object)((Object)directory));
    }

    public Directory getDirectory(String relativePath) throws IOException {
        return this._directoryFactory.getDirectory(relativePath);
    }

    public int getMaxUncommittedChanges() {
        return this._maxUncommittedChanges;
    }

    public String getLocation() {
        return this._location;
    }

    public Analyzer getDefaultAnalyzer() {
        return this._defaultAnalyzer;
    }

    public int getMaxResults() {
        return this._maxResults;
    }

    public static Analyzer createAnalyzer(Class analyzerClass) {
        try {
            return (Analyzer)analyzerClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to instantiate analyzer " + analyzerClass, e);
        }
    }

    public abstract class DirectoryFactory {
        public abstract Directory getDirectory(String var1) throws IOException;
    }

    private static enum SupportedDirectory {
        MMapDirectory,
        RAMDirectory;


        public static SupportedDirectory byName(String key) {
            for (SupportedDirectory directory : SupportedDirectory.values()) {
                if (!directory.name().equalsIgnoreCase(key)) continue;
                return directory;
            }
            throw new IllegalArgumentException("Unsupported directory: " + key + " - supported values: " + Arrays.asList(SupportedDirectory.values()));
        }
    }
}

