/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.textsearch;

import com.gigaspaces.SpaceRuntimeException;
import com.gigaspaces.internal.io.FileUtils;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.query.extension.QueryExtensionEntryIterator;
import com.gigaspaces.query.extension.QueryExtensionManager;
import com.gigaspaces.query.extension.QueryExtensionRuntimeInfo;
import com.gigaspaces.query.extension.metadata.TypeQueryExtensions;
import com.gigaspaces.server.SpaceServerEntry;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.openspaces.textsearch.LuceneQueryExtensionEntryIterator;
import org.openspaces.textsearch.LuceneTextSearchConfiguration;
import org.openspaces.textsearch.LuceneTextSearchQueryExtensionProvider;
import org.openspaces.textsearch.LuceneTextSearchTypeIndex;
import org.openspaces.textsearch.SpaceTextAnalyzer;
import org.openspaces.textsearch.SpaceTextIndex;

public class LuceneTextSearchQueryExtensionManager
extends QueryExtensionManager {
    private static final Logger _logger = Logger.getLogger(LuceneTextSearchQueryExtensionManager.class.getName());
    public static final String SEARCH_OPERATION_NAME = "match";
    protected static final String XAP_ID = "XAP_ID";
    private static final FieldType XAP_ID_TYPE = LuceneTextSearchQueryExtensionManager.toFieldType(Field.Store.YES, IndexOptions.NONE, true);
    protected static final String XAP_ID_VERSION = "XAP_ID_VERSION";
    private static final FieldType XAP_ID_VERSION_TYPE = LuceneTextSearchQueryExtensionManager.toFieldType(Field.Store.YES, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, false);
    protected final String _namespace;
    protected final Map<String, LuceneTextSearchTypeIndex> _luceneHolderMap = new ConcurrentHashMap<String, LuceneTextSearchTypeIndex>();
    protected final LuceneTextSearchConfiguration _luceneConfiguration;

    protected LuceneTextSearchQueryExtensionManager(LuceneTextSearchQueryExtensionProvider provider, QueryExtensionRuntimeInfo info, LuceneTextSearchConfiguration configuration) {
        super(info);
        this._namespace = provider.getNamespace();
        this._luceneConfiguration = configuration;
        File location = new File(this._luceneConfiguration.getLocation());
        FileUtils.deleteFileOrDirectoryIfExists((File)location);
    }

    public void close() throws IOException {
        for (LuceneTextSearchTypeIndex luceneHolder : this._luceneHolderMap.values()) {
            luceneHolder.close();
        }
        this._luceneHolderMap.clear();
        FileUtils.deleteFileOrDirectoryIfExists((File)new File(this._luceneConfiguration.getLocation()));
        super.close();
    }

    public void registerType(SpaceTypeDescriptor typeDescriptor) {
        super.registerType(typeDescriptor);
        String typeName = typeDescriptor.getTypeName();
        if (!this._luceneHolderMap.containsKey(typeName)) {
            try {
                this._luceneHolderMap.put(typeName, new LuceneTextSearchTypeIndex(this._luceneConfiguration, this._namespace, typeDescriptor));
            }
            catch (IOException e) {
                throw new SpaceRuntimeException("Failed to register type " + typeName, (Throwable)e);
            }
        } else {
            _logger.log(Level.WARNING, "Type [" + typeName + "] is already registered");
        }
    }

    protected LuceneTextSearchTypeIndex createTypeIndex(LuceneTextSearchConfiguration luceneConfig, String namespace, SpaceTypeDescriptor typeDescriptor) throws IOException {
        return new LuceneTextSearchTypeIndex(luceneConfig, namespace, typeDescriptor);
    }

    public boolean accept(String typeName, String path, String operation, Object gridValue, Object luceneQuery) {
        Objects.requireNonNull(gridValue, "Provided value from grid is null");
        Objects.requireNonNull(luceneQuery, "Provided lucene query is null");
        this.validateOperationName(operation);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "filter [operation=" + operation + ", leftOperand(value from grid)=" + gridValue + ", rightOperand(lucene query)=" + luceneQuery + "]");
        }
        try {
            Analyzer analyzer = this.getAnalyzer(typeName, path);
            MemoryIndex index = new MemoryIndex();
            index.addField("content", String.valueOf(gridValue), analyzer);
            Query query = new QueryParser("content", analyzer).parse(String.valueOf(luceneQuery));
            float score = index.search(query);
            return score > 0.0f;
        }
        catch (ParseException e) {
            throw new SpaceRuntimeException("Could not parse full text query [ " + luceneQuery + " ]", (Throwable)e);
        }
    }

    public boolean insertEntry(SpaceServerEntry entry, boolean hasPrevious) {
        String typeName = entry.getSpaceTypeDescriptor().getTypeName();
        LuceneTextSearchTypeIndex luceneHolder = this._luceneHolderMap.get(typeName);
        try {
            Document doc = this.createDocumentIfNeeded(luceneHolder, entry);
            if (doc != null) {
                luceneHolder.getIndexWriter().addDocument((Iterable)doc);
            }
            if (hasPrevious) {
                TermQuery query = new TermQuery(new Term(XAP_ID_VERSION, this.concat(entry.getUid(), entry.getVersion() - 1)));
                luceneHolder.getIndexWriter().deleteDocuments(new Query[]{query});
            }
            if (doc != null || hasPrevious) {
                luceneHolder.commit(false);
            }
            return doc != null;
        }
        catch (Exception e) {
            String operation = hasPrevious ? "update" : "insert";
            throw new SpaceRuntimeException("Failed to " + operation + " entry of type " + typeName + " with id [" + entry.getUid() + "]", (Throwable)e);
        }
    }

    protected String concat(String uid, int version) {
        return uid + "_" + version;
    }

    protected Document createDocumentIfNeeded(LuceneTextSearchTypeIndex luceneHolder, SpaceServerEntry entry) {
        TypeQueryExtensions queryExtensions = entry.getSpaceTypeDescriptor().getQueryExtensions();
        Document doc = null;
        for (String path : luceneHolder.getQueryExtensionInfo().getPaths()) {
            Object fieldValue;
            if (!queryExtensions.isIndexed(this._namespace, path) || (fieldValue = entry.getPathValue(path)) == null) continue;
            Field[] fields = this.convertField(path, fieldValue);
            if (doc == null && fields.length != 0) {
                doc = new Document();
            }
            for (Field field : fields) {
                doc.add((IndexableField)field);
            }
        }
        if (doc != null) {
            doc.add((IndexableField)new Field(XAP_ID, entry.getUid(), (IndexableFieldType)XAP_ID_TYPE));
            doc.add((IndexableField)new Field(XAP_ID_VERSION, this.concat(entry.getUid(), entry.getVersion()), (IndexableFieldType)XAP_ID_VERSION_TYPE));
        }
        return doc;
    }

    protected Field[] convertField(String path, Object fieldValue) {
        if (!(fieldValue instanceof String)) {
            throw new IllegalArgumentException("Field '" + path + "' with value '" + fieldValue + "' is not String. Try to use 'path' of the @" + SpaceTextAnalyzer.class.getSimpleName() + " or @" + SpaceTextIndex.class.getSimpleName());
        }
        TextField field = new TextField(path, (String)fieldValue, Field.Store.NO);
        return new Field[]{field};
    }

    private Analyzer getAnalyzer(String typeName, String path) {
        LuceneTextSearchTypeIndex typeIndex = this._luceneHolderMap.get(typeName);
        return typeIndex != null ? typeIndex.getAnalyzerForPath(path) : this._luceneConfiguration.getDefaultAnalyzer();
    }

    public QueryExtensionEntryIterator queryByIndex(String typeName, String path, String operationName, Object operand) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "query [typeName=" + typeName + ", path=" + path + ", operation=" + operationName + ", operand=" + operand + "]");
        }
        Query query = this.createQuery(typeName, path, operationName, operand);
        LuceneTextSearchTypeIndex luceneHolder = this._luceneHolderMap.get(typeName);
        try {
            luceneHolder.commit(true);
            DirectoryReader dr = DirectoryReader.open((Directory)luceneHolder.getDirectory());
            IndexSearcher is = new IndexSearcher((IndexReader)dr);
            ScoreDoc[] scores = is.search((Query)query, (int)this._luceneConfiguration.getMaxResults()).scoreDocs;
            return new LuceneQueryExtensionEntryIterator(scores, is, dr);
        }
        catch (IOException e) {
            throw new SpaceRuntimeException("Failed to scan index", (Throwable)e);
        }
    }

    protected Query createQuery(String typeName, String path, String operationName, Object operand) {
        Objects.requireNonNull(operand, "Provided operand is null");
        this.validateOperationName(operationName);
        try {
            LuceneTextSearchTypeIndex typeIndex = this._luceneHolderMap.get(typeName);
            Analyzer analyzer = typeIndex.getAnalyzerForPath(path);
            return new QueryParser(path, analyzer).parse(path + ":" + operand);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Couldn't create full text search query for path=" + path + " operationName=" + operationName + " operand=" + operand, e);
        }
    }

    private void validateOperationName(String operationName) {
        if (!SEARCH_OPERATION_NAME.equals(operationName)) {
            throw new IllegalArgumentException("Provided operationName=" + operationName + " is incorrect. Correct one is '" + SEARCH_OPERATION_NAME + "'");
        }
    }

    public void removeEntry(SpaceTypeDescriptor typeDescriptor, String uid, int version) {
        String typeName = typeDescriptor.getTypeName();
        LuceneTextSearchTypeIndex luceneHolder = this._luceneHolderMap.get(typeName);
        try {
            luceneHolder.getIndexWriter().deleteDocuments(new Query[]{new TermQuery(new Term(XAP_ID_VERSION, this.concat(uid, version)))});
            luceneHolder.commit(false);
        }
        catch (IOException e) {
            throw new SpaceRuntimeException("Failed to remove entry of type " + typeName, (Throwable)e);
        }
    }

    private static FieldType toFieldType(Field.Store store, IndexOptions index, boolean analyzed) {
        FieldType ft = new FieldType();
        ft.setStored(store == Field.Store.YES);
        ft.setIndexOptions(index);
        ft.setTokenized(analyzed);
        ft.freeze();
        return ft;
    }
}

