/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.textsearch;

import com.gigaspaces.query.extension.QueryExtensionManager;
import com.gigaspaces.query.extension.QueryExtensionProvider;
import com.gigaspaces.query.extension.QueryExtensionRuntimeInfo;
import com.gigaspaces.query.extension.metadata.DefaultQueryExtensionPathInfo;
import com.gigaspaces.query.extension.metadata.QueryExtensionPathInfo;
import com.gigaspaces.query.extension.metadata.QueryExtensionPropertyInfo;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.openspaces.textsearch.LuceneTextSearchConfiguration;
import org.openspaces.textsearch.LuceneTextSearchQueryExtensionManager;
import org.openspaces.textsearch.SpaceTextAnalyzer;
import org.openspaces.textsearch.SpaceTextAnalyzers;
import org.openspaces.textsearch.SpaceTextIndex;
import org.openspaces.textsearch.SpaceTextIndexes;
import org.openspaces.textsearch.TextAnalyzerQueryExtensionPathInfo;

public class LuceneTextSearchQueryExtensionProvider
extends QueryExtensionProvider {
    public static final String NAMESPACE = "text";
    private final Properties _customProperties;

    public LuceneTextSearchQueryExtensionProvider() {
        this(new Properties());
    }

    public LuceneTextSearchQueryExtensionProvider(Properties customProperties) {
        this._customProperties = customProperties;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public QueryExtensionManager createManager(QueryExtensionRuntimeInfo info) {
        LuceneTextSearchConfiguration configuration = new LuceneTextSearchConfiguration(this, info);
        return new LuceneTextSearchQueryExtensionManager(this, info, configuration);
    }

    public QueryExtensionPropertyInfo getPropertyExtensionInfo(String property, Annotation annotation) {
        QueryExtensionPropertyInfo result;
        block3: {
            block5: {
                block4: {
                    block2: {
                        result = new QueryExtensionPropertyInfo();
                        if (!(annotation instanceof SpaceTextIndex)) break block2;
                        SpaceTextIndex index = (SpaceTextIndex)annotation;
                        String path = LuceneTextSearchQueryExtensionProvider.makePath(property, index.path());
                        result.addPathInfo(path, (QueryExtensionPathInfo)new DefaultQueryExtensionPathInfo());
                        break block3;
                    }
                    if (!(annotation instanceof SpaceTextIndexes)) break block4;
                    SpaceTextIndexes indexes = (SpaceTextIndexes)annotation;
                    for (SpaceTextIndex index : indexes.value()) {
                        String path = LuceneTextSearchQueryExtensionProvider.makePath(property, index.path());
                        result.addPathInfo(path, (QueryExtensionPathInfo)new DefaultQueryExtensionPathInfo());
                    }
                    break block3;
                }
                if (!(annotation instanceof SpaceTextAnalyzer)) break block5;
                SpaceTextAnalyzer analyzer = (SpaceTextAnalyzer)annotation;
                String path = LuceneTextSearchQueryExtensionProvider.makePath(property, analyzer.path());
                result.addPathInfo(path, (QueryExtensionPathInfo)new TextAnalyzerQueryExtensionPathInfo(analyzer.analyzer()));
                break block3;
            }
            if (!(annotation instanceof SpaceTextAnalyzers)) break block3;
            SpaceTextAnalyzers analyzers = (SpaceTextAnalyzers)annotation;
            for (SpaceTextAnalyzer analyzer : analyzers.value()) {
                String path = LuceneTextSearchQueryExtensionProvider.makePath(property, analyzer.path());
                result.addPathInfo(path, (QueryExtensionPathInfo)new TextAnalyzerQueryExtensionPathInfo(analyzer.analyzer()));
            }
        }
        return result;
    }

    public static QueryExtensionPathInfo analyzer(Class<? extends Analyzer> analyzerClass) {
        return new TextAnalyzerQueryExtensionPathInfo(analyzerClass, LuceneTextSearchQueryExtensionProvider.class);
    }

    public static QueryExtensionPathInfo index() {
        return new DefaultQueryExtensionPathInfo(LuceneTextSearchQueryExtensionProvider.class);
    }

    public LuceneTextSearchQueryExtensionProvider setCustomProperty(String key, String value) {
        this._customProperties.setProperty(key, value);
        return this;
    }

    public String getCustomProperty(String key, String defaultValue) {
        return this._customProperties.getProperty(key, defaultValue);
    }

    private static String makePath(String property, String relativePath) {
        return relativePath.length() == 0 ? property : property + "." + relativePath;
    }
}

