/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.textsearch;

import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.query.extension.metadata.QueryExtensionPathInfo;
import com.gigaspaces.query.extension.metadata.TypeQueryExtension;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.openspaces.textsearch.LuceneTextSearchConfiguration;
import org.openspaces.textsearch.TextAnalyzerQueryExtensionPathInfo;

public class LuceneTextSearchTypeIndex
implements Closeable {
    private final Directory directory;
    private final IndexWriter indexWriter;
    private final TypeQueryExtension queryExtensionInfo;
    private final int maxUncommittedChanges;
    private final AtomicInteger uncommittedChanges = new AtomicInteger(0);
    protected final LuceneTextSearchConfiguration luceneConfig;
    private Map<String, Analyzer> _fieldAnalyzers;

    public LuceneTextSearchTypeIndex(LuceneTextSearchConfiguration luceneConfig, String namespace, SpaceTypeDescriptor typeDescriptor) throws IOException {
        this.luceneConfig = luceneConfig;
        this.directory = luceneConfig.getDirectory(typeDescriptor.getTypeName() + File.separator + "entries");
        this.indexWriter = new IndexWriter(this.directory, new IndexWriterConfig(this.createAnalyzer(luceneConfig, typeDescriptor)).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        this.queryExtensionInfo = typeDescriptor.getQueryExtensions().getByNamespace(namespace);
        this.maxUncommittedChanges = luceneConfig.getMaxUncommittedChanges();
    }

    @Override
    public void close() throws IOException {
        this.indexWriter.close();
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public TypeQueryExtension getQueryExtensionInfo() {
        return this.queryExtensionInfo;
    }

    public void commit(boolean force) throws IOException {
        if (force || this.uncommittedChanges.incrementAndGet() == this.maxUncommittedChanges) {
            this.uncommittedChanges.set(0);
            this.indexWriter.commit();
        }
    }

    public Analyzer getAnalyzerForPath(String path) {
        Analyzer fieldAnalyzer = this._fieldAnalyzers.get(path);
        if (fieldAnalyzer != null) {
            return fieldAnalyzer;
        }
        return this.luceneConfig.getDefaultAnalyzer();
    }

    private Analyzer createAnalyzer(LuceneTextSearchConfiguration luceneConfig, SpaceTypeDescriptor typeDescriptor) {
        this._fieldAnalyzers = this.createFieldAnalyzers(typeDescriptor);
        return new PerFieldAnalyzerWrapper(luceneConfig.getDefaultAnalyzer(), this._fieldAnalyzers);
    }

    private Map<String, Analyzer> createFieldAnalyzers(SpaceTypeDescriptor typeDescriptor) {
        HashMap<String, Analyzer> analyzerMap = new HashMap<String, Analyzer>();
        TypeQueryExtension type = typeDescriptor.getQueryExtensions().getByNamespace("text");
        for (String path : type.getPaths()) {
            for (QueryExtensionPathInfo pathInfo : type.get(path)) {
                if (!(pathInfo instanceof TextAnalyzerQueryExtensionPathInfo)) continue;
                TextAnalyzerQueryExtensionPathInfo analyzerPathInfo = (TextAnalyzerQueryExtensionPathInfo)pathInfo;
                this.addAnalyzer(analyzerMap, path, analyzerPathInfo.getAnalyzerClass());
            }
        }
        return analyzerMap;
    }

    private void addAnalyzer(Map<String, Analyzer> analyzerMap, String path, Class clazz) {
        Analyzer analyzer = LuceneTextSearchConfiguration.createAnalyzer(clazz);
        analyzerMap.put(path, analyzer);
    }
}

