/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway;

import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewaysPolicy;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.server.SpaceCustomComponent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GatewayConfig
extends SpaceCustomComponent
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final String CUSTOM_COMPONENT_KEY = "replication.gateways";
    public static final String SERVICE_DETAIL_ATTRIBUTE_NAME = "local-site-name";
    private GatewaysPolicy gatewaysPolicy;

    public static GatewayConfig fromClusterInfo(SpaceClusterInfo clusterInfo) {
        return (GatewayConfig)clusterInfo.getCustomComponent(CUSTOM_COMPONENT_KEY);
    }

    public static boolean hasGatewayConfig(SpaceClusterInfo clusterInfo) {
        return GatewayConfig.fromClusterInfo(clusterInfo) != null;
    }

    public String getSpaceComponentKey() {
        return CUSTOM_COMPONENT_KEY;
    }

    public String getServiceDetailAttributeName() {
        return SERVICE_DETAIL_ATTRIBUTE_NAME;
    }

    public Object getServiceDetailAttributeValue() {
        return this.gatewaysPolicy.getLocalSiteName();
    }

    public GatewaysPolicy getGatewaysPolicy() {
        return this.gatewaysPolicy;
    }

    public GatewayConfig setGatewaysPolicy(GatewaysPolicy gatewaysPolicy) {
        this.gatewaysPolicy = gatewaysPolicy;
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject((ObjectOutput)out, (Object)this.gatewaysPolicy);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.gatewaysPolicy = (GatewaysPolicy)IOUtils.readObject((ObjectInput)in);
    }
}

