/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway;

import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayConstants;
import com.gigaspaces.internal.io.IOUtils;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GatewayPolicy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String _gatewayName;
    private long _maxRedoLogCapacity = 100000000L;
    private RedoLogCapacityExceededPolicy _onRedoLogCapacityExceeded = GatewayConstants.REDO_LOG_CAPACITY_EXCEEDED_DEFAULT;
    private int _bulkSize = 100;
    private long _idleTimeThreshold = 1000L;
    private int _pendingOperationThreshold = 100;
    private boolean _replicateChangeAsUpdate = false;
    private static final int FLAG_GATEWAY_NAME = 1;
    private static final int FLAG_MAX_REDO_LOG_CPACITY = 2;
    private static final int FLAG_REDO_LOG_CAPACITY_EXCEEDED = 4;
    private static final int FLAG_BULK_SIZE = 8;
    private static final int FLAG_IDLE_TIME_THRESHOLD = 16;
    private static final int FLAG_PENDING_OPERATION_THRESHOLD = 32;
    private static final int FLAG_REPLICATE_CHANGE_AS_UPDATE = 64;

    public String getGatewayName() {
        return this._gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this._gatewayName = gatewayName;
    }

    public String getGatewayChannelName() {
        return "gateway:" + this.getGatewayName();
    }

    public long getMaxRedoLogCapacity() {
        return this._maxRedoLogCapacity;
    }

    public void setMaxRedoLogCapacity(long maxRedoLogCapacity) {
        this._maxRedoLogCapacity = maxRedoLogCapacity;
    }

    public RedoLogCapacityExceededPolicy getOnRedoLogCapacityExceeded() {
        return this._onRedoLogCapacityExceeded;
    }

    public void setOnRedoLogCapacityExceeded(RedoLogCapacityExceededPolicy onRedoLogCapacityExceeded) {
        this._onRedoLogCapacityExceeded = onRedoLogCapacityExceeded;
    }

    public int getBulkSize() {
        return this._bulkSize;
    }

    public void setBulkSize(int bulkSize) {
        this._bulkSize = bulkSize;
    }

    public long getIdleTimeThreshold() {
        return this._idleTimeThreshold;
    }

    public void setIdleTimeThreshold(long idleTimeThreshold) {
        this._idleTimeThreshold = idleTimeThreshold;
    }

    public int getPendingOperationThreshold() {
        return this._pendingOperationThreshold;
    }

    public void setPendingOperationThreshold(int pendingOperationThreshold) {
        this._pendingOperationThreshold = pendingOperationThreshold;
    }

    public void setReplicateChangeAsUpdate(boolean replicateChangeAsUpdate) {
        this._replicateChangeAsUpdate = replicateChangeAsUpdate;
    }

    public boolean isReplicateChangeAsUpdate() {
        return this._replicateChangeAsUpdate;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int flags = 0;
        if (this._gatewayName != null) {
            flags |= 1;
        }
        if (this._maxRedoLogCapacity != 100000000L) {
            flags |= 2;
        }
        if (this._onRedoLogCapacityExceeded != GatewayConstants.REDO_LOG_CAPACITY_EXCEEDED_DEFAULT) {
            flags |= 4;
        }
        if (this._bulkSize != 100) {
            flags |= 8;
        }
        if (this._idleTimeThreshold != 1000L) {
            flags |= 0x10;
        }
        if (this._pendingOperationThreshold != 100) {
            flags |= 0x20;
        }
        if (this._replicateChangeAsUpdate) {
            flags |= 0x40;
        }
        out.writeInt(flags);
        if (this._gatewayName != null) {
            IOUtils.writeRepetitiveString((ObjectOutput)out, (String)this._gatewayName);
        }
        if (this._maxRedoLogCapacity != 100000000L) {
            out.writeLong(this._maxRedoLogCapacity);
        }
        if (this._onRedoLogCapacityExceeded != GatewayConstants.REDO_LOG_CAPACITY_EXCEEDED_DEFAULT) {
            IOUtils.writeObject((ObjectOutput)out, (Object)this._onRedoLogCapacityExceeded);
        }
        if (this._bulkSize != 100) {
            out.writeInt(this._bulkSize);
        }
        if (this._idleTimeThreshold != 1000L) {
            out.writeLong(this._idleTimeThreshold);
        }
        if (this._pendingOperationThreshold != 100) {
            out.writeInt(this._pendingOperationThreshold);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        if ((flags & 1) != 0) {
            this._gatewayName = IOUtils.readRepetitiveString((ObjectInput)in);
        }
        if ((flags & 2) != 0) {
            this._maxRedoLogCapacity = in.readLong();
        }
        if ((flags & 4) != 0) {
            this._onRedoLogCapacityExceeded = (RedoLogCapacityExceededPolicy)IOUtils.readObject((ObjectInput)in);
        }
        if ((flags & 8) != 0) {
            this._bulkSize = in.readInt();
        }
        if ((flags & 0x10) != 0) {
            this._idleTimeThreshold = in.readLong();
        }
        if ((flags & 0x20) != 0) {
            this._pendingOperationThreshold = in.readInt();
        }
        if ((flags & 0x40) != 0) {
            this._replicateChangeAsUpdate = true;
        }
    }
}

