/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway;

import com.gigaspaces.internal.cluster.node.impl.config.IReplicationComponentPolicy;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayPolicy;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GatewaysPolicy
implements Externalizable,
IReplicationComponentPolicy {
    private static final long serialVersionUID = 1L;
    private GatewayPolicy[] _gatewayPolicies;
    private String _localSiteName;
    private GatewayPolicy _defaultGatewayPolicy;
    private static final int FLAG_GATEWAY_POLICIES = 1;
    private static final int FLAG_LOCAL_SITE_NAME = 2;
    private static final int FLAG_DEFAULT_GATEWAY_POLICY = 4;

    public GatewayPolicy[] getGatewayPolicies() {
        return this._gatewayPolicies;
    }

    public void setGatewayPolicies(GatewayPolicy[] gatewayPolicies) {
        this._gatewayPolicies = gatewayPolicies;
    }

    public GatewayPolicy getDefaultGatewayPolicy() {
        return this._defaultGatewayPolicy;
    }

    public void setDefaultGatewayPolicy(GatewayPolicy defaultGatewayPolicy) {
        this._defaultGatewayPolicy = defaultGatewayPolicy;
    }

    public String getLocalSiteName() {
        return this._localSiteName;
    }

    public void setLocalSiteName(String localSiteName) {
        this._localSiteName = localSiteName;
    }

    public long getMaxRedoLogCapacity() {
        long result = 0L;
        for (GatewayPolicy gatewayPolicy : this._gatewayPolicies) {
            if (gatewayPolicy.getMaxRedoLogCapacity() != -1L) {
                if (result == 0L) {
                    result = gatewayPolicy.getMaxRedoLogCapacity();
                    continue;
                }
                result = Math.max(result, gatewayPolicy.getMaxRedoLogCapacity());
                continue;
            }
            result = -1L;
            break;
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int flags = 0;
        if (this._gatewayPolicies != null) {
            flags |= 1;
        }
        if (this._localSiteName != null) {
            flags |= 2;
        }
        if (this._defaultGatewayPolicy != null) {
            flags |= 4;
        }
        out.writeInt(flags);
        if (this._gatewayPolicies != null) {
            out.writeObject(this._gatewayPolicies);
        }
        if (this._localSiteName != null) {
            IOUtils.writeString((ObjectOutput)out, (String)this._localSiteName);
        }
        if (this._defaultGatewayPolicy != null) {
            IOUtils.writeObject((ObjectOutput)out, (Object)this._defaultGatewayPolicy);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        if ((flags & 1) != 0) {
            this._gatewayPolicies = (GatewayPolicy[])in.readObject();
        }
        if ((flags & 2) != 0) {
            this._localSiteName = IOUtils.readString((ObjectInput)in);
        }
        if ((flags & 4) != 0) {
            this._defaultGatewayPolicy = (GatewayPolicy)IOUtils.readObject((ObjectInput)in);
        }
    }
}

