/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway;

import com.gigaspaces.cluster.replication.ReplicationFilterManager;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.node.impl.GroupMapping;
import com.gigaspaces.internal.cluster.node.impl.IReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogMemberLimitationConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.async.IReplicationAsyncBacklogBuilder;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReplicationReliableAsyncBacklogBuilder;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicAsyncSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicReliableAsyncSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.IMirrorChannelReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.IReliableAsyncReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.IReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.ISpaceReplicationSettings;
import com.gigaspaces.internal.cluster.node.impl.config.MirrorReplicationSettingsAdapter;
import com.gigaspaces.internal.cluster.node.impl.config.ReliableAsyncReplicationSettingsAdapter;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfig;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfigBuilder;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeMode;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationSettingsAdapter;
import com.gigaspaces.internal.cluster.node.impl.config.SourceChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayPolicy;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewaysPolicy;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilterBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationStaticTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncReplicationSourceGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.async.AsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.consistencylevel.GroupConsistencyLevelPolicy;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.GatewayChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.IDynamicSourceGroupMemberLifeCycleBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.MirrorChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncKeeperReplicationTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncReplicationSourceGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.reliableasync.IReplicationReliableAsyncKeeperProcessLogBuilder;
import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.license.LicenseType;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.core.sadapter.IStorageAdapter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ReplicationNodeWithGatewayConfigBuilder
extends ReplicationNodeConfigBuilder {
    public ReplicationNodeConfig createConfig(SpaceClusterInfo clusterInfo, ClusterPolicy clusterPolicy, IReplicationNodeBuilder nodeBuilder, ReplicationFilterManager filterManager, int partitionId, IStorageAdapter storageAdapter, SpaceConfigReader configReader, IReplicationChannelDataFilterBuilder filterBuilder, IDynamicSourceGroupMemberLifeCycleBuilder lifeCycleBuilder) {
        GatewaysPolicy gatewaysPolicy;
        GatewayConfig gatewaysConfig = GatewayConfig.fromClusterInfo(clusterInfo);
        GatewaysPolicy gatewaysPolicy2 = gatewaysPolicy = gatewaysConfig != null ? gatewaysConfig.getGatewaysPolicy() : null;
        if (gatewaysPolicy != null) {
            LicenseManager.getInstance().validate("WAN gateway", LicenseType.ENTERPRISE);
            boolean isReliableAsync = clusterPolicy.getReplicationPolicy().isReliableAsyncRepl();
            boolean syncReplication = clusterPolicy.getReplicationPolicy().m_IsSyncReplicationEnabled;
            boolean primaryBackupGroup = clusterPolicy.isPrimaryElectionAvailable();
            if (isReliableAsync && syncReplication && primaryBackupGroup) {
                ReliableAsyncReplicationSettingsAdapter mirrorReliableAsyncSettings = new ReliableAsyncReplicationSettingsAdapter(clusterPolicy.getReplicationPolicy(), filterManager, this.reliableAsyncKeeperCannotRefillContent(clusterPolicy, storageAdapter, configReader));
                return this.createReliableAsyncSourceWithGatewaysAndMirrorConfig((IReliableAsyncReplicationSettings)mirrorReliableAsyncSettings, gatewaysPolicy, nodeBuilder, partitionId, filterBuilder, lifeCycleBuilder, this.requiresEvictionReplicationProtection(clusterPolicy, storageAdapter, configReader));
            }
            if (isReliableAsync && syncReplication) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.warning("Creating a reliable async topology without a backup is not considered reliable async");
                }
                ReplicationSettingsAdapter replicationPolicy = new ReplicationSettingsAdapter(clusterPolicy.getReplicationPolicy(), filterManager);
                MirrorReplicationSettingsAdapter mirrorPolicy = clusterPolicy.getReplicationPolicy().isMirrorServiceEnabled() ? new MirrorReplicationSettingsAdapter(clusterPolicy.getReplicationPolicy().getMirrorServiceConfig()) : null;
                return this.createSourceWithGatewaysAndMirrorConfig((ISpaceReplicationSettings)replicationPolicy, (IMirrorChannelReplicationSettings)mirrorPolicy, gatewaysPolicy, nodeBuilder, partitionId, this.requiresEvictionReplicationProtection(clusterPolicy, storageAdapter, configReader));
            }
            throw new UnsupportedOperationException("Gateway is supported only with primary-backup synchronous replication topology.");
        }
        return super.createConfig(clusterInfo, clusterPolicy, nodeBuilder, filterManager, partitionId, storageAdapter, configReader, filterBuilder, lifeCycleBuilder);
    }

    public ReplicationNodeConfig createReliableAsyncSourceWithGatewaysAndMirrorConfig(IReliableAsyncReplicationSettings reliableAsyncSettings, GatewaysPolicy gatewaysPolicy, IReplicationNodeBuilder nodeBuilder, int partitionId, IReplicationChannelDataFilterBuilder filterBuilder, IDynamicSourceGroupMemberLifeCycleBuilder lifeCycleBuilder, boolean requiresEvictionReplicationProtection) {
        ISpaceReplicationSettings replicationPolicy = reliableAsyncSettings.getSpaceReplicationSettings();
        IMirrorChannelReplicationSettings mirrorPolicy = reliableAsyncSettings.getMirrorReplicationSettings();
        boolean hasMirror = mirrorPolicy != null;
        this.validateConfig(replicationPolicy);
        String groupName = ReplicationNodeWithGatewayConfigBuilder.createReplicationGroupNameWithLocalSite(partitionId, reliableAsyncSettings.getSpaceReplicationSettings().getSpaceMemberName(), true, hasMirror, gatewaysPolicy.getLocalSiteName());
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        replicationNodeConfig.mapSourceGroups("all", GroupMapping.getAllMapping());
        BacklogConfig backlogConfig = this.createBacklogConfig(replicationPolicy, mirrorPolicy, gatewaysPolicy, true, true);
        List syncGroupMemberNames = this.createGroupMemberNames(replicationPolicy);
        if (hasMirror) {
            syncGroupMemberNames.remove(mirrorPolicy.getMirrorMemberName());
        }
        this.configureBacklogLimitations(replicationPolicy, backlogConfig, syncGroupMemberNames);
        LinkedList<String> reliableAsyncMemberNames = new LinkedList<String>();
        Map membersGrouping = null;
        if (hasMirror) {
            reliableAsyncMemberNames.add(mirrorPolicy.getMirrorMemberName());
            this.configureMirrorBacklogLimitations((IReplicationSettings)mirrorPolicy, backlogConfig, reliableAsyncMemberNames);
            if (requiresEvictionReplicationProtection) {
                membersGrouping = this.createMembersGroupingForMirror(mirrorPolicy.getMirrorMemberName());
            }
        }
        this.addGatewayMembers(reliableAsyncMemberNames, gatewaysPolicy);
        this.configureGatewaysBacklogLimitations(gatewaysPolicy, backlogConfig);
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>();
        if (hasMirror) {
            filters.put(mirrorPolicy.getMirrorMemberName(), (IReplicationChannelDataFilter)new MirrorChannelDataFilter(mirrorPolicy));
        }
        this.addKeepersFilters(reliableAsyncSettings, groupName, syncGroupMemberNames, filters, requiresEvictionReplicationProtection);
        this.addGatewayFilters(filters, gatewaysPolicy);
        int backlogCompletionBatchSize = hasMirror ? mirrorPolicy.getBatchSize() : replicationPolicy.getBatchSize();
        GroupConsistencyLevelPolicy groupConsistencyLevelPolicy = this.getGroupConsistencyLevel(replicationPolicy, syncGroupMemberNames);
        ReliableAsyncSourceGroupConfig sourceGroupConfig = new ReliableAsyncSourceGroupConfig(groupName, backlogConfig, groupConsistencyLevelPolicy, filters, null, membersGrouping, syncGroupMemberNames.toArray(new String[syncGroupMemberNames.size()]), reliableAsyncMemberNames.toArray(new String[reliableAsyncMemberNames.size()]), backlogCompletionBatchSize, reliableAsyncSettings.getReliableAsyncCompletionNotifierInterval(), reliableAsyncSettings.getReliableAsyncCompletionNotifierPacketsThreshold(), reliableAsyncSettings.getSpaceReplicationSettings().isNetworkCompressionEnabled());
        DynamicReliableAsyncSourceGroupConfigHolder configHolder = new DynamicReliableAsyncSourceGroupConfigHolder(sourceGroupConfig);
        this.addKeepersListeners(filters, configHolder);
        ReliableAsyncReplicationSourceGroupBuilder sourceReliableAsync = new ReliableAsyncReplicationSourceGroupBuilder((DynamicSourceGroupConfigHolder)configHolder);
        sourceReliableAsync.setAsyncHandlerProvider(nodeBuilder.getAsyncHandlerProvider());
        for (GatewayPolicy gatewayPolicy : gatewaysPolicy.getGatewayPolicies()) {
            if (gatewayPolicy.getGatewayName().equals(gatewaysPolicy.getLocalSiteName())) continue;
            sourceGroupConfig.setChannelConfig(gatewayPolicy.getGatewayChannelName(), (SourceChannelConfig)new AsyncChannelConfig(gatewayPolicy.getBulkSize(), gatewayPolicy.getIdleTimeThreshold(), gatewayPolicy.getPendingOperationThreshold(), ReplicationStatistics.ReplicationMode.GATEWAY));
        }
        if (hasMirror) {
            sourceGroupConfig.setChannelConfig(mirrorPolicy.getMirrorMemberName(), (SourceChannelConfig)new AsyncChannelConfig(mirrorPolicy.getBatchSize(), mirrorPolicy.getIdleDelay(), mirrorPolicy.getOperationsReplicationThreshold(), ReplicationStatistics.ReplicationMode.MIRROR));
        }
        sourceReliableAsync.setSyncChannelAsyncStateBatchSize(replicationPolicy.getBatchSize());
        sourceReliableAsync.setSyncChannelIdleDelayMilis(replicationPolicy.getIdleDelay());
        sourceReliableAsync.setThrottleController(this.createSyncGroupThrottleController((IReplicationSettings)replicationPolicy));
        sourceReliableAsync.setBacklogBuilder((IReplicationReliableAsyncBacklogBuilder)nodeBuilder.getReplicationBacklogBuilder());
        replicationNodeConfig.addSourceGroupBuilder((IReplicationSourceGroupBuilder)sourceReliableAsync, ReplicationNodeMode.ALWAYS);
        ReliableAsyncKeeperReplicationTargetGroupBuilder targetSyncBackup = new ReliableAsyncKeeperReplicationTargetGroupBuilder();
        TargetGroupConfig targetGroupConfig = new TargetGroupConfig(groupName, this.createProcessLogConfig(replicationPolicy, true, true), ReplicationStatistics.ReplicationMode.BACKUP_SPACE, syncGroupMemberNames.toArray(new String[syncGroupMemberNames.size()]));
        targetSyncBackup.setGroupConfig(targetGroupConfig);
        targetSyncBackup.setProcessLogBuilder((IReplicationReliableAsyncKeeperProcessLogBuilder)nodeBuilder.getReplicationProcessLogBuilder());
        targetSyncBackup.setLifeCycleBuilder(lifeCycleBuilder);
        targetSyncBackup.setFilterBuilder(filterBuilder);
        replicationNodeConfig.addTargetGroupBuilder((IReplicationStaticTargetGroupBuilder)targetSyncBackup, ReplicationNodeMode.PASSIVE);
        this.setReplicationFilters((IReplicationSettings)replicationPolicy, replicationNodeConfig);
        return replicationNodeConfig;
    }

    public ReplicationNodeConfig createSourceWithGatewaysAndMirrorConfig(ISpaceReplicationSettings replicationPolicy, IMirrorChannelReplicationSettings mirrorPolicy, GatewaysPolicy gatewaysPolicy, IReplicationNodeBuilder nodeBuilder, int partitionId, boolean requiresEvictionReplicationProtection) {
        boolean hasMirror = mirrorPolicy != null;
        this.validateConfig(replicationPolicy);
        String groupName = ReplicationNodeWithGatewayConfigBuilder.createReplicationGroupNameWithLocalSite(partitionId, replicationPolicy.getSpaceMemberName(), false, hasMirror, gatewaysPolicy.getLocalSiteName());
        ReplicationNodeConfig replicationNodeConfig = new ReplicationNodeConfig();
        replicationNodeConfig.mapSourceGroups("all", GroupMapping.getAllMapping());
        BacklogConfig backlogConfig = this.createBacklogConfig(replicationPolicy, mirrorPolicy, gatewaysPolicy, false, false);
        LinkedList<String> mirrorMembersNames = new LinkedList<String>();
        Map membersGrouping = null;
        if (hasMirror) {
            mirrorMembersNames.add(mirrorPolicy.getMirrorMemberName());
            this.configureMirrorBacklogLimitations((IReplicationSettings)mirrorPolicy, backlogConfig, mirrorMembersNames);
            if (requiresEvictionReplicationProtection) {
                membersGrouping = this.createMembersGroupingForMirror(mirrorPolicy.getMirrorMemberName());
            }
        }
        LinkedList<String> gatewayMemberNames = new LinkedList<String>();
        this.addGatewayMembers(gatewayMemberNames, gatewaysPolicy);
        this.configureGatewaysBacklogLimitations(gatewaysPolicy, backlogConfig);
        HashMap<String, IReplicationChannelDataFilter> filters = new HashMap<String, IReplicationChannelDataFilter>();
        if (hasMirror) {
            filters.put(mirrorPolicy.getMirrorMemberName(), (IReplicationChannelDataFilter)new MirrorChannelDataFilter(mirrorPolicy));
        }
        this.addGatewayFilters(filters, gatewaysPolicy);
        LinkedList<String> groupMemberNames = new LinkedList<String>(gatewayMemberNames);
        groupMemberNames.addAll(mirrorMembersNames);
        AsyncSourceGroupConfig sourceGroupConfig = new AsyncSourceGroupConfig(groupName, backlogConfig, null, filters, null, membersGrouping, replicationPolicy.isNetworkCompressionEnabled(), groupMemberNames.toArray(new String[groupMemberNames.size()]));
        DynamicAsyncSourceGroupConfigHolder configHolder = new DynamicAsyncSourceGroupConfigHolder(sourceGroupConfig);
        AsyncReplicationSourceGroupBuilder sourceBuilder = new AsyncReplicationSourceGroupBuilder(configHolder);
        sourceBuilder.setAsyncHandlerProvider(nodeBuilder.getAsyncHandlerProvider());
        for (GatewayPolicy gatewayPolicy : gatewaysPolicy.getGatewayPolicies()) {
            if (gatewayPolicy.getGatewayName().equals(gatewaysPolicy.getLocalSiteName())) continue;
            sourceGroupConfig.setChannelConfig(gatewayPolicy.getGatewayChannelName(), (SourceChannelConfig)new AsyncChannelConfig(gatewayPolicy.getBulkSize(), gatewayPolicy.getIdleTimeThreshold(), gatewayPolicy.getPendingOperationThreshold(), ReplicationStatistics.ReplicationMode.GATEWAY));
        }
        if (hasMirror) {
            sourceGroupConfig.setChannelConfig(mirrorPolicy.getMirrorMemberName(), (SourceChannelConfig)new AsyncChannelConfig(mirrorPolicy.getBatchSize(), mirrorPolicy.getIdleDelay(), mirrorPolicy.getOperationsReplicationThreshold(), ReplicationStatistics.ReplicationMode.MIRROR));
        }
        sourceBuilder.setBatchSize(replicationPolicy.getBatchSize());
        sourceBuilder.setIntervalMilis(replicationPolicy.getIdleDelay());
        sourceBuilder.setIntervalOperations(replicationPolicy.getOperationsReplicationThreshold());
        sourceBuilder.setBacklogBuilder((IReplicationAsyncBacklogBuilder)nodeBuilder.getReplicationBacklogBuilder());
        replicationNodeConfig.addSourceGroupBuilder((IReplicationSourceGroupBuilder)sourceBuilder, ReplicationNodeMode.ACTIVE);
        this.setReplicationFilters((IReplicationSettings)replicationPolicy, replicationNodeConfig);
        return replicationNodeConfig;
    }

    public String createReplicationGroupName(int partitionId, String spaceMemberName, SpaceClusterInfo clusterInfo, boolean primaryBackupGroup) {
        GatewaysPolicy gatewaysPolicy;
        GatewayConfig gatewayConfig = GatewayConfig.fromClusterInfo(clusterInfo);
        GatewaysPolicy gatewaysPolicy2 = gatewaysPolicy = gatewayConfig != null ? gatewayConfig.getGatewaysPolicy() : null;
        if (gatewaysPolicy != null) {
            return ReplicationNodeWithGatewayConfigBuilder.createReplicationGroupNameWithLocalSite(partitionId, spaceMemberName, primaryBackupGroup, clusterInfo.isMirrorServiceEnabled(), gatewaysPolicy.getLocalSiteName());
        }
        return super.createReplicationGroupName(partitionId, spaceMemberName, clusterInfo, primaryBackupGroup);
    }

    public static String createReplicationGroupNameWithLocalSite(int partitionId, String spaceMemberName, boolean primaryBackupGroup, boolean hasMirror, String localSiteName) {
        String[] split = spaceMemberName.split(":");
        String shortSpaceMemberName = split[split.length - 1];
        String groupName = localSiteName + ":" + shortSpaceMemberName + ":";
        groupName = hasMirror ? (primaryBackupGroup ? groupName + "primary-backup-reliable-async-mirror-" + partitionId : groupName + "async-mirror-" + partitionId) : (primaryBackupGroup ? groupName + "primary-backup-reliable-async-" + partitionId : groupName + "async" + partitionId);
        return groupName;
    }

    private void addGatewayMembers(List<String> reliableAsyncMemberNames, GatewaysPolicy gatewaysPolicy) {
        for (GatewayPolicy gateway : gatewaysPolicy.getGatewayPolicies()) {
            if (gateway.getGatewayName().equals(gatewaysPolicy.getLocalSiteName())) continue;
            reliableAsyncMemberNames.add(gateway.getGatewayChannelName());
        }
    }

    private void addGatewayFilters(Map<String, IReplicationChannelDataFilter> filters, GatewaysPolicy gatewaysPolicy) {
        for (GatewayPolicy gateway : gatewaysPolicy.getGatewayPolicies()) {
            if (gateway.getGatewayName().equals(gatewaysPolicy.getLocalSiteName())) continue;
            filters.put(gateway.getGatewayChannelName(), (IReplicationChannelDataFilter)new GatewayChannelDataFilter(gateway.isReplicateChangeAsUpdate()));
        }
    }

    private void configureGatewaysBacklogLimitations(GatewaysPolicy gatewaysPolicy, BacklogConfig backlogConfig) {
        for (GatewayPolicy gatewayPolicy : gatewaysPolicy.getGatewayPolicies()) {
            if (gatewayPolicy.getGatewayName().equals(gatewaysPolicy.getLocalSiteName())) continue;
            BacklogMemberLimitationConfig memberLimitationConfig = new BacklogMemberLimitationConfig();
            if (gatewayPolicy.getMaxRedoLogCapacity() == -1L) {
                memberLimitationConfig.setUnlimited();
            } else {
                BacklogConfig.LimitReachedPolicy limitReachedPolicy = gatewayPolicy.getOnRedoLogCapacityExceeded() == RedoLogCapacityExceededPolicy.BLOCK_OPERATIONS ? BacklogConfig.LimitReachedPolicy.BLOCK_NEW : BacklogConfig.LimitReachedPolicy.DROP_OLDEST;
                memberLimitationConfig.setLimit(gatewayPolicy.getMaxRedoLogCapacity(), limitReachedPolicy);
            }
            backlogConfig.setMemberBacklogLimitation(gatewayPolicy.getGatewayChannelName(), memberLimitationConfig);
        }
    }

    public String supportsMultiSourceReplication(SpaceClusterInfo clusterInfo) {
        boolean primaryBackupGroup = clusterInfo.isPrimaryElectionAvailable();
        boolean hasMirror = clusterInfo.isMirrorServiceEnabled();
        boolean hasReplicationGateways = GatewayConfig.hasGatewayConfig(clusterInfo);
        boolean hasExistingReplicationMembers = clusterInfo.hasReplicationTargets();
        if (!hasMirror && !hasReplicationGateways && !primaryBackupGroup && hasExistingReplicationMembers) {
            boolean syncReplication = clusterInfo.isSyncReplicationEnabled();
            return (syncReplication ? "Sync" : "Async") + " replication is not supported in Multiple sources replication processing";
        }
        return null;
    }
}

