/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.delegator;

import com.gigaspaces.internal.cluster.node.impl.IServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayReplicationUtils;
import com.gigaspaces.internal.cluster.node.impl.gateway.delegator.ReplicationConnectionDelegatorStatistics;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupFinderService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupRegistrationService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.LusExportedReplicationComponent;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.LusReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.LusScheduledPoolConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.RoutingUrlConverter;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.ConnectChannelHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.packets.ConnectChannelPacket;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IAsyncContextProvider;
import com.gigaspaces.internal.cluster.node.impl.router.IConnectionStateListener;
import com.gigaspaces.internal.cluster.node.impl.router.IIncomingReplicationHandler;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.IRouterStub;
import com.gigaspaces.internal.cluster.node.impl.router.LRMIAsyncContextProvider;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicationConnectionDelegator
extends LusExportedReplicationComponent
implements IIncomingReplicationHandler,
IConnectionStateListener {
    private final Logger _specificLogger;
    private final Map<String, ReverseConnection> _reverseConnectionProxies = new HashMap<String, ReverseConnection>();
    private final String _routingLookupName;
    private IReplicationMonitoredConnection _delegationTargetConnection;
    private volatile IReplicationRouter _router;
    private final IReplicationLookupFinderService _finderService;
    private final IReplicationLookupParameters _lookupParametersTemplate;
    private final String _targetLookupName;

    public ReplicationConnectionDelegator(String mySiteName, String targetLookupName, String routingLookupName, IReplicationLookupFinderService finderService, IReplicationLookupRegistrationService registrationService, IReplicationLookupParameters lookupParametersTemplate, IReplicationLookupParameters registrationParameters, IServiceExporter serviceExporter) {
        super("replication:delegate:" + mySiteName + "|" + targetLookupName, mySiteName, serviceExporter, registrationService, registrationParameters);
        this._targetLookupName = targetLookupName;
        this._routingLookupName = routingLookupName;
        this._finderService = finderService;
        this._lookupParametersTemplate = lookupParametersTemplate;
        this._specificLogger = Logger.getLogger("com.gigaspaces.replication.gateway.delegator." + GatewayReplicationUtils.toShortGatewayLookupName(this.getMyLookupName()));
        if (this._specificLogger.isLoggable(Level.FINE)) {
            this._specificLogger.fine("init registration of delegator using look parameters [" + this.getMyRegistrationParameters() + "]");
        }
        this.initRegistration();
    }

    public String getTargetLookupName() {
        return this._targetLookupName;
    }

    private IReplicationRouter createReplicationRouter() {
        LusScheduledPoolConnectionMonitor connectionMonitor = new LusScheduledPoolConnectionMonitor(this.getMyLookupName(), 1, 5L, 5L, TimeUnit.SECONDS, this._finderService);
        return new LusReplicationRouter.Builder(this.getMyLookupName(), (IConnectionMonitor<Iterable<IReplicationLookupParameters>, String>)connectionMonitor, this.getServiceExporter(), this.getMyUuid(), (IAsyncContextProvider)new LRMIAsyncContextProvider(), this._finderService, this._lookupParametersTemplate, new RoutingUrlConverter(this.getMySiteName()), false).create(this);
    }

    @Override
    protected <T> T onDispatch(AbstractReplicationPacket<T> packet) throws RemoteException {
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("delegating packet [" + packet + "]");
        }
        AbstractReplicationPacket filteredPacket = this.filterPacket(packet);
        Object result = this.getDelegationTargetConnection().dispatch(filteredPacket);
        return (T)this.filterResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IReplicationMonitoredConnection getDelegationTargetConnection() {
        if (this._delegationTargetConnection != null) {
            return this._delegationTargetConnection;
        }
        ReplicationConnectionDelegator replicationConnectionDelegator = this;
        synchronized (replicationConnectionDelegator) {
            return this._delegationTargetConnection;
        }
    }

    private <T> T filterResult(T result) {
        if (result instanceof ConnectChannelHandshakeResponse) {
            ConnectChannelHandshakeResponse handshakeResponse = (ConnectChannelHandshakeResponse)result;
            ReplicationEndpointDetails targetEndpointDetails = handshakeResponse.getTargetEndpointDetails();
            PlatformLogicalVersion targetLogicalVersion = targetEndpointDetails.getPlatformLogicalVersion();
            if (PlatformLogicalVersion.getLogicalVersion().lessThan(targetLogicalVersion)) {
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("lowering target logical version from " + targetLogicalVersion + " to " + PlatformLogicalVersion.getLogicalVersion() + " since delegator has the lower version");
                }
                targetEndpointDetails = targetEndpointDetails.cloneWithCurrentVersion();
                return (T)new ConnectChannelHandshakeResponse(targetEndpointDetails, handshakeResponse.getProcessLogHandshakeResponse());
            }
        }
        return result;
    }

    private <T> AbstractReplicationPacket filterPacket(AbstractReplicationPacket<T> packet) {
        ReplicationEndpointDetails sourceEndpointDetails;
        if (packet instanceof ConnectChannelPacket) {
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("replacing backward router stub within ConnectChannelPacket");
            }
            ConnectChannelPacket connectionChannelPacket = packet;
            RouterStubHolder routerStubHolder = connectionChannelPacket.getRouterStubHolder();
            ReplicationEndpointDetails packetSourceEndpointDetails = packet.getSourceEndpointDetails();
            packet = new ConnectChannelPacket(connectionChannelPacket.getGroupName(), this.getReverseRouterStub(routerStubHolder, connectionChannelPacket.getGroupName()), connectionChannelPacket.getChannelHandshakeRequest());
            packet.setSourceEndpointDetails(packetSourceEndpointDetails);
        }
        if ((sourceEndpointDetails = packet.getSourceEndpointDetails()) != null) {
            packet.setSourceEndpointDetails(this.replaceEndpointWithMinimumVersionIfNeeded(sourceEndpointDetails));
        }
        return packet;
    }

    @Override
    protected synchronized void afterRegistrationInitiated() {
        if (this._specificLogger.isLoggable(Level.INFO)) {
            this._specificLogger.info("delegator initiated, creating a connection to the delegated target [" + this._routingLookupName + "]");
        }
        this._router = this.createReplicationRouter();
        this._delegationTargetConnection = this._router.getMemberConnection(this._routingLookupName);
        this._delegationTargetConnection.setConnectionStateListener((IConnectionStateListener)this);
        if (this._delegationTargetConnection.getState() == ConnectionState.CONNECTED) {
            this.onConnected(true);
        } else {
            this.onDisconnected();
        }
    }

    @Override
    public void onRegistered() {
        if (this._specificLogger.isLoggable(Level.INFO)) {
            this._specificLogger.info("registered at gateway lookup service");
        }
    }

    public synchronized void onConnected(boolean newTarget) {
        this.logConnectionStateChange(ConnectionState.CONNECTED.toString());
    }

    public synchronized void onDisconnected() {
        this.logConnectionStateChange(ConnectionState.DISCONNECTED.toString());
    }

    private void logConnectionStateChange(String state) {
        String msg = "Connection delegator: moved to state: " + state + StringUtils.NEW_LINE + "[  delegator name: " + this.getMyLookupName() + "  ] " + StringUtils.NEW_LINE + "[  delegated target: " + this._routingLookupName + " ]";
        if (this._specificLogger.isLoggable(Level.INFO)) {
            this._specificLogger.info(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RouterStubHolder getReverseRouterStub(RouterStubHolder routerStubHolder, String replicationGroupName) {
        IReplicationConnectionProxy reverseConnectionStub;
        ReverseConnection existingReverseConnection;
        ReplicationEndpointDetails replicationEndpointDetails = routerStubHolder.getMyEndpointDetails();
        Map<String, ReverseConnection> map = this._reverseConnectionProxies;
        synchronized (map) {
            String connectionId = replicationGroupName + "-" + replicationEndpointDetails.getLookupName();
            existingReverseConnection = this._reverseConnectionProxies.get(connectionId);
            ReverseConnection reverseConnectionService = new ReverseConnection((IReplicationConnectionProxy)routerStubHolder.getStub(), connectionId);
            try {
                reverseConnectionStub = (IReplicationConnectionProxy)this.getServiceExporter().export((Remote)((Object)reverseConnectionService));
            }
            catch (ExportException e) {
                throw new ReplicationInternalSpaceException("Error when exporting stub", (Throwable)e);
            }
            this._reverseConnectionProxies.put(connectionId, reverseConnectionService);
        }
        replicationEndpointDetails = this.replaceEndpointWithMinimumVersionIfNeeded(replicationEndpointDetails);
        RouterStubHolder replacedRouterStubHolder = new RouterStubHolder((IRouterStub)reverseConnectionStub, replicationEndpointDetails);
        if (existingReverseConnection != null) {
            try {
                existingReverseConnection.cleanUp();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return replacedRouterStubHolder;
    }

    private ReplicationEndpointDetails replaceEndpointWithMinimumVersionIfNeeded(ReplicationEndpointDetails replicationEndpointDetails) {
        if (replicationEndpointDetails.getPlatformLogicalVersion() != null && PlatformLogicalVersion.getLogicalVersion().lessThan(replicationEndpointDetails.getPlatformLogicalVersion())) {
            if (this._specificLogger.isLoggable(Level.FINEST)) {
                this._specificLogger.finest("lowering source logical version from " + replicationEndpointDetails.getPlatformLogicalVersion() + " to " + PlatformLogicalVersion.getLogicalVersion() + " since delegator has the lower version");
            }
            replicationEndpointDetails = replicationEndpointDetails.cloneWithCurrentVersion();
        }
        return replicationEndpointDetails;
    }

    @Override
    protected void onClose() {
        if (this._specificLogger.isLoggable(Level.FINE)) {
            this._specificLogger.fine("closing delegator...");
        }
        for (ReverseConnection reverseConnection : this._reverseConnectionProxies.values()) {
            try {
                reverseConnection.cleanUp();
            }
            catch (RemoteException remoteException) {}
        }
        if (this._delegationTargetConnection != null) {
            this._delegationTargetConnection.close();
        }
        if (this._router != null) {
            this._router.close();
        }
        super.onClose();
        if (this._specificLogger.isLoggable(Level.INFO)) {
            this._specificLogger.info("delegator closed");
        }
    }

    public <T> T onReplication(AbstractReplicationPacket<T> packet) throws RemoteException {
        throw new IllegalStateException();
    }

    public ReplicationConnectionDelegatorStatistics getStatistics() {
        IReplicationMonitoredConnection delegationTargetConnection = this.getDelegationTargetConnection();
        ConnectionState connectionState = delegationTargetConnection != null ? delegationTargetConnection.getState() : ConnectionState.DISCONNECTED;
        return new ReplicationConnectionDelegatorStatistics(connectionState);
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder();
        sb.append("------------------" + StringUtils.NEW_LINE);
        sb.append(" Delegator: " + this.getMyLookupName() + StringUtils.NEW_LINE);
        sb.append("------------------" + StringUtils.NEW_LINE);
        sb.append("- localSiteName            = " + this.getMySiteName() + StringUtils.NEW_LINE);
        sb.append("- delegatorLookupName      = " + this.getMyLookupName() + StringUtils.NEW_LINE);
        sb.append("- targetLookupName         = " + this.getTargetLookupName() + StringUtils.NEW_LINE);
        sb.append("- delegatorUuid            = " + this.getMyUuid() + StringUtils.NEW_LINE);
        sb.append("- lookupParametersTemplate = " + this._lookupParametersTemplate + StringUtils.NEW_LINE);
        sb.append("- statistics               = " + this.getStatistics() + StringUtils.NEW_LINE);
        if (this._router != null) {
            sb.append(this._router.dumpState());
        }
        return sb.toString();
    }

    public class ReverseConnection
    implements IReplicationConnectionProxy {
        private final IReplicationConnectionProxy _reverseProxy;
        private final String _identifier;

        public ReverseConnection(IReplicationConnectionProxy reverseProxy, String identifier) {
            this._reverseProxy = reverseProxy;
            this._identifier = identifier;
        }

        public void cleanUp() throws RemoteException {
            ReplicationConnectionDelegator.this.getServiceExporter().unexport((Remote)((Object)this));
            this._reverseProxy.close();
        }

        public <T> T dispatch(AbstractReplicationPacket<T> packet) throws RemoteException {
            return (T)this._reverseProxy.dispatch(packet);
        }

        public <T> T dispatchAsync(AbstractReplicationPacket<T> packet) throws RemoteException {
            return this.dispatch(packet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws RemoteException {
            Map map = ReplicationConnectionDelegator.this._reverseConnectionProxies;
            synchronized (map) {
                ReplicationConnectionDelegator.this._reverseConnectionProxies.remove(this._identifier);
            }
            this.cleanUp();
        }
    }
}

