/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.delegator;

import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayReplicationUtils;
import com.gigaspaces.internal.cluster.node.impl.gateway.ReplicationDelegationConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.delegator.ReplicationConnectionDelegator;
import com.gigaspaces.internal.cluster.node.impl.gateway.delegator.ReplicationConnectionDelegatorConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.delegator.ReplicationConnectionDelegatorStatistics;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.ReplicationGatewayComponent;
import com.gigaspaces.internal.utils.StringUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicationConnectionDelegatorContainer
extends ReplicationGatewayComponent {
    private final Logger _specificLogger;
    private final ReplicationConnectionDelegatorConfig _config;
    private final List<ReplicationConnectionDelegator> _delegators;

    public ReplicationConnectionDelegatorContainer(ReplicationConnectionDelegatorConfig config) {
        super(config);
        this._config = config;
        this._specificLogger = Logger.getLogger("com.gigaspaces.replication.gateway.delegator." + GatewayReplicationUtils.toShortGatewayLookupName(this._config.getMySiteName()));
        if (this._specificLogger.isLoggable(Level.CONFIG)) {
            this._specificLogger.config("delegator container config [" + this._config + "]");
        }
        this._delegators = new LinkedList<ReplicationConnectionDelegator>();
        for (ReplicationDelegationConfig delegatorConfig : this._config.getDelegatorsConfig()) {
            if (delegatorConfig.getTargetName().equals(this._config.getMySiteName())) continue;
            this._delegators.add(new ReplicationConnectionDelegator(this._config.getMySiteName(), delegatorConfig.getTargetLookupName(), delegatorConfig.getRoutingUrl(), this._finderService, this._registrationService, this._lookupParametersTemplate, this._lookupParametersTemplate, this._serviceExporter));
        }
    }

    public Map<String, ReplicationConnectionDelegatorStatistics> getStatistics() {
        HashMap<String, ReplicationConnectionDelegatorStatistics> statistics = new HashMap<String, ReplicationConnectionDelegatorStatistics>();
        for (ReplicationConnectionDelegator delegator : this._delegators) {
            statistics.put(delegator.getTargetLookupName(), delegator.getStatistics());
        }
        return statistics;
    }

    public void close() {
        for (ReplicationConnectionDelegator delegator : this._delegators) {
            delegator.close();
        }
        this._finderService.close();
        this._registrationService.close();
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder(this._config.toString());
        if (this._delegators != null) {
            for (ReplicationConnectionDelegator delegator : this._delegators) {
                sb.append(StringUtils.NEW_LINE);
                sb.append(delegator.dumpState());
            }
        }
        return sb.toString();
    }
}

