/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.lus;

import com.gigaspaces.internal.cluster.node.impl.IServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupRegistrationListener;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupRegistrationService;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.service.ServiceRegistrationException;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.rmi.RemoteException;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public abstract class LusExportedReplicationComponent
implements IReplicationLookupRegistrationListener {
    private final String _myLookupName;
    private final Uuid _myUuid;
    private final String _mySiteName;
    private final IServiceExporter _serviceExporter;
    private final IReplicationLookupRegistrationService _lookupService;
    private final IReplicationLookupParameters _myLookupParameters;
    private boolean _available = false;

    public LusExportedReplicationComponent(String myLookupName, String mySiteName, IServiceExporter serviceExporter, IReplicationLookupRegistrationService lookupService, IReplicationLookupParameters lookupParametersTemplate) {
        this._myLookupName = myLookupName;
        this._mySiteName = mySiteName;
        this._serviceExporter = serviceExporter;
        this._lookupService = lookupService;
        this._myLookupParameters = lookupParametersTemplate.clone();
        this._myLookupParameters.setLookupName(myLookupName);
        this._myUuid = UuidFactory.generate();
    }

    public void initRegistration() {
        try {
            this._lookupService.registerConnectionProxy(this._myLookupParameters, new IReplicationConnectionProxy(){

                public <T> T dispatchAsync(AbstractReplicationPacket<T> packet) throws RemoteException {
                    return LusExportedReplicationComponent.this.dispatchAsync(packet);
                }

                public <T> T dispatch(AbstractReplicationPacket<T> packet) throws RemoteException {
                    return LusExportedReplicationComponent.this.dispatch(packet);
                }

                public void close() throws RemoteException {
                }
            }, this, this._myUuid);
            this.afterRegistrationInitiated();
            this._available = true;
        }
        catch (ServiceRegistrationException e) {
            throw new ReplicationInternalSpaceException("Error when registering stub", (Throwable)e);
        }
    }

    public IServiceExporter getServiceExporter() {
        return this._serviceExporter;
    }

    public IReplicationLookupParameters getMyRegistrationParameters() {
        return this._myLookupParameters;
    }

    public String getMyLookupName() {
        return this._myLookupName;
    }

    public String getMySiteName() {
        return this._mySiteName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAvailable() {
        if (this._available) {
            return true;
        }
        LusExportedReplicationComponent lusExportedReplicationComponent = this;
        synchronized (lusExportedReplicationComponent) {
            return this._available;
        }
    }

    public Uuid getMyUuid() {
        return this._myUuid;
    }

    public synchronized void close() {
        try {
            this._lookupService.unregisterConnectionProxy(this._myLookupParameters);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.onClose();
    }

    protected void onClose() {
    }

    public <T> T dispatch(AbstractReplicationPacket<T> packet) throws RemoteException {
        if (!this.isAvailable()) {
            throw new RemoteException("Service is unavailable");
        }
        return this.onDispatch(packet);
    }

    public <T> T dispatchAsync(AbstractReplicationPacket<T> packet) throws RemoteException {
        return this.dispatch(packet);
    }

    protected abstract <T> T onDispatch(AbstractReplicationPacket<T> var1) throws RemoteException;

    protected abstract void afterRegistrationInitiated();
}

