/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.lus;

import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationConnectionProxyService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupFinderService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupResult;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.LookupFinder;
import com.j_spaces.core.client.LookupRequest;
import java.rmi.RemoteException;
import java.util.Properties;
import net.jini.core.discovery.LookupLocator;
import net.jini.id.Uuid;

public class ReplicationLookupFinderService
implements IReplicationLookupFinderService {
    private final long _timeout;

    public ReplicationLookupFinderService(long timeout) {
        this._timeout = timeout;
    }

    @Override
    public IReplicationLookupResult findConnectionProxy(IReplicationLookupParameters lookupParameters) throws RemoteException {
        String groups;
        ReplicationLookupParameters parameters = (ReplicationLookupParameters)lookupParameters;
        Properties props = new Properties();
        String string = groups = parameters.getLookupGroups() == null ? null : StringUtils.join((String[])parameters.getLookupGroups(), (String)",", (int)0, (int)parameters.getLookupGroups().length);
        if (parameters.getLookupLocators() != null && parameters.getLookupLocators().length > 0) {
            StringBuilder locators = new StringBuilder();
            for (LookupLocator locator : parameters.getLookupLocators()) {
                locators.append(locator.getHost());
                locators.append(":");
                locators.append(locator.getPort());
                locators.append(",");
            }
            locators.deleteCharAt(locators.length() - 1);
            props.put("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host", locators.toString());
        }
        try {
            LookupRequest request = new LookupRequest(IReplicationConnectionProxyService.class).setServiceName(parameters.getLookupName()).setGroups(groups).setCustomProperties(props).setTimeout(this._timeout);
            final IReplicationConnectionProxyService proxyService = (IReplicationConnectionProxyService)LookupFinder.find((LookupRequest)request);
            return new IReplicationLookupResult(){

                @Override
                public IReplicationConnectionProxy getServiceProxy() {
                    return proxyService;
                }

                @Override
                public Uuid getServiceId() throws RemoteException {
                    return proxyService.getServiceId();
                }
            };
        }
        catch (FinderException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
    }
}

