/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.lus;

import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.start.SystemInfo;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.jini.core.discovery.LookupLocator;

public class ReplicationLookupParameters
implements IReplicationLookupParameters {
    private String _lookupName;
    private String[] _lookupGroups;
    private LookupLocator[] _lookupLocators;

    @Override
    public void setLookupName(String lookupName) {
        this._lookupName = lookupName;
    }

    @Override
    public String getLookupName() {
        return this._lookupName;
    }

    @Override
    public IReplicationLookupParameters clone() {
        ReplicationLookupParameters parameters = new ReplicationLookupParameters();
        parameters.setLookupGroups(this._lookupGroups);
        parameters.setLookupLocators(this._lookupLocators);
        parameters.setLookupName(this._lookupName);
        return parameters;
    }

    @Override
    public ReplicationLookupParameters merge(IReplicationLookupParameters other) {
        List otherLookupGroups;
        ReplicationLookupParameters typedOther = (ReplicationLookupParameters)other;
        ReplicationLookupParameters merged = new ReplicationLookupParameters();
        merged.setLookupName(this.getLookupName());
        LinkedList mergedGroups = CollectionUtils.toList((Object[])this._lookupGroups);
        if (mergedGroups == null) {
            mergedGroups = new LinkedList();
        }
        if ((otherLookupGroups = CollectionUtils.toList((Object[])typedOther.getLookupGroups())) != null) {
            mergedGroups.addAll(otherLookupGroups);
        }
        merged.setLookupGroups(mergedGroups.toArray(new String[0]));
        LinkedList mergedLocators = CollectionUtils.toList((Object[])this._lookupLocators);
        if (mergedLocators == null) {
            mergedLocators = new LinkedList();
        }
        List otherLookupLocators = CollectionUtils.toList((Object[])typedOther.getLookupLocators());
        if (otherLookupGroups != null) {
            mergedLocators.addAll(otherLookupLocators);
        }
        merged.setLookupLocators(mergedLocators.toArray(new LookupLocator[0]));
        return merged;
    }

    public void setLookupGroups(String[] lookupGroups) {
        this._lookupGroups = lookupGroups;
    }

    public String[] getLookupGroups() {
        return this._lookupGroups;
    }

    public void setLookupLocators(LookupLocator[] lookupLocators) {
        this._lookupLocators = lookupLocators;
    }

    public LookupLocator[] getLookupLocators() {
        return this._lookupLocators;
    }

    public static ReplicationLookupParameters getEnvironmentLookupParameters() {
        ReplicationLookupParameters parameters = new ReplicationLookupParameters();
        parameters.setLookupGroups(SystemInfo.singleton().lookup().groupsArray());
        parameters.setLookupLocators(SystemInfo.singleton().lookup().locatorsArray());
        return parameters;
    }

    public String toString() {
        return "ReplicationLookupParameters [getLookupName()=" + this.getLookupName() + ", getLookupGroups()=" + Arrays.toString(this.getLookupGroups()) + ", getLookupLocators()=" + Arrays.toString(this.getLookupLocators()) + "]";
    }
}

