/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.lus;

import com.gigaspaces.internal.cluster.node.impl.IServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.LRMIServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupRegistrationListener;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupRegistrationService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationProxyGigaSpacesService;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.lookup.RegistrarFactory;
import com.gigaspaces.internal.service.ServiceRegistrationException;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.start.NonActivatableServiceDescriptor;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.id.Uuid;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.Name;

public class ReplicationLookupRegistrationService
implements IReplicationLookupRegistrationService {
    private final Map<IReplicationLookupParameters, ReplicationProxyGigaSpacesService> _registrations = new HashMap<IReplicationLookupParameters, ReplicationProxyGigaSpacesService>();
    private static final Map<String, ReplicationLookupRegistrationService> _embeddedRegistrationServices = new HashMap<String, ReplicationLookupRegistrationService>();
    private int _referencesCount = 1;
    private final boolean _startEmbeddedJiniLus;
    private final Registrar _gigaRegistrar;
    private final IServiceExporter _serviceExporter = new LRMIServiceExporter();
    private final ScheduledExecutorService _executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new GSThreadFactory("ReplicationRegistrationService-Notifier", true));
    private final Map<IReplicationLookupParameters, IReplicationLookupRegistrationListener> _listeners = new HashMap<IReplicationLookupParameters, IReplicationLookupRegistrationListener>();
    private final String _embeddedJiniLusLookupGroup;

    public static ReplicationLookupRegistrationService getRegistrationService() {
        return new ReplicationLookupRegistrationService(false, null);
    }

    public static synchronized ReplicationLookupRegistrationService createAndGetRegistrationService(String lookupGroup) {
        if (_embeddedRegistrationServices.containsKey(lookupGroup)) {
            ReplicationLookupRegistrationService replicationLookupRegistrationService = _embeddedRegistrationServices.get(lookupGroup);
            replicationLookupRegistrationService.incrementReferencesCounter();
            return replicationLookupRegistrationService;
        }
        ReplicationLookupRegistrationService replicationLookupRegistrationService = new ReplicationLookupRegistrationService(true, lookupGroup);
        _embeddedRegistrationServices.put(lookupGroup, replicationLookupRegistrationService);
        return replicationLookupRegistrationService;
    }

    private ReplicationLookupRegistrationService(boolean startEmbeddedJiniLus, String embeddedJiniLusLookupGroup) {
        this._startEmbeddedJiniLus = startEmbeddedJiniLus;
        this._embeddedJiniLusLookupGroup = embeddedJiniLusLookupGroup;
        if (startEmbeddedJiniLus) {
            try {
                this._gigaRegistrar = RegistrarFactory.createRegistrar((String)embeddedJiniLusLookupGroup);
                new NonActivatableServiceDescriptor.Created((Object)this._gigaRegistrar, this._gigaRegistrar.getServiceProxy());
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not start embedded LUS: " + e.getMessage(), e);
            }
        } else {
            this._gigaRegistrar = null;
        }
        this._executorService.scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ReplicationLookupRegistrationService replicationLookupRegistrationService = ReplicationLookupRegistrationService.this;
                synchronized (replicationLookupRegistrationService) {
                    Iterator iterator = ReplicationLookupRegistrationService.this._listeners.entrySet().iterator();
                    while (iterator.hasNext()) {
                        ServiceRegistrar[] joinSet;
                        Map.Entry entry = iterator.next();
                        ReplicationProxyGigaSpacesService gigaSpacesService = (ReplicationProxyGigaSpacesService)((Object)ReplicationLookupRegistrationService.this._registrations.get(entry.getKey()));
                        if (gigaSpacesService == null) {
                            iterator.remove();
                            continue;
                        }
                        JoinManager joinManager = gigaSpacesService.getJoinManager();
                        if (joinManager == null || (joinSet = joinManager.getJoinSet()) == null || joinSet.length <= 0) continue;
                        iterator.remove();
                        try {
                            ((IReplicationLookupRegistrationListener)entry.getValue()).onRegistered();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }, 3L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public synchronized void registerConnectionProxy(IReplicationLookupParameters lookupParameters, IReplicationConnectionProxy connectionProxy, IReplicationLookupRegistrationListener registrationListener, Uuid serviceUuid) throws ServiceRegistrationException {
        ReplicationLookupParameters parameters = (ReplicationLookupParameters)lookupParameters;
        ReplicationProxyGigaSpacesService service = new ReplicationProxyGigaSpacesService(parameters.getLookupName(), serviceUuid, connectionProxy, this._serviceExporter);
        Name lookupName = new Name(parameters.getLookupName());
        this._registrations.put(parameters, service);
        service.addLookupAttributes(new Entry[]{lookupName});
        service.registerLookupService(parameters.getLookupGroups(), parameters.getLookupLocators(), null, true);
        if (registrationListener != null) {
            this._listeners.put(lookupParameters, registrationListener);
        }
    }

    @Override
    public synchronized void unregisterConnectionProxy(IReplicationLookupParameters registerationLookupParameters) throws RemoteException {
        if (this._registrations.containsKey(registerationLookupParameters)) {
            ReplicationProxyGigaSpacesService replicationProxyGigaSpacesService = this._registrations.remove(registerationLookupParameters);
            replicationProxyGigaSpacesService.unregisterFromLookupService();
            replicationProxyGigaSpacesService.close();
            this._listeners.remove(registerationLookupParameters);
        }
    }

    private synchronized void incrementReferencesCounter() {
        ++this._referencesCount;
    }

    @Override
    public synchronized void close() {
        this._executorService.shutdownNow();
        for (ReplicationProxyGigaSpacesService proxyService : this._registrations.values()) {
            proxyService.unregisterFromLookupService();
            proxyService.close();
        }
        this._registrations.clear();
        this._listeners.clear();
        if (this._startEmbeddedJiniLus) {
            --this._referencesCount;
            if (this._referencesCount == 0) {
                try {
                    _embeddedRegistrationServices.remove(this._embeddedJiniLusLookupGroup);
                    this._gigaRegistrar.destroy();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }
}

