/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.router;

import com.gigaspaces.internal.cluster.node.impl.IServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewaysPolicy;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationLookupFinderService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.LusReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.LusScheduledPoolConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.RoutingUrlConverter;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.UnifiedReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.IAsyncContextProvider;
import com.gigaspaces.internal.cluster.node.impl.router.LRMIAsyncContextProvider;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilderFactory;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IConnectionMonitor;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.replication.SpaceServiceExporter;
import com.j_spaces.core.cluster.ClusterPolicy;
import java.util.concurrent.TimeUnit;

public class GatewayReplicationRouterBuilderFactory
extends ReplicationRouterBuilderFactory {
    public ReplicationRouterBuilder create(SpaceImpl spaceImpl) {
        boolean isReplicated;
        ReplicationRouterBuilder replicationRouterBuilder = super.create(spaceImpl);
        ClusterPolicy clusterPolicy = spaceImpl.getClusterPolicy();
        boolean bl = isReplicated = clusterPolicy != null && clusterPolicy.m_Replicated;
        if (isReplicated && GatewayConfig.hasGatewayConfig(spaceImpl.getClusterInfo())) {
            replicationRouterBuilder = this.createGatewayReplicationRouterBuilder(spaceImpl, replicationRouterBuilder);
        }
        return replicationRouterBuilder;
    }

    private ReplicationRouterBuilder createGatewayReplicationRouterBuilder(SpaceImpl spaceImpl, ReplicationRouterBuilder spaceProxyReplicationRouterBuilder) {
        ClusterPolicy clusterPolicy = spaceImpl.getClusterPolicy();
        boolean isReplicated = clusterPolicy != null && clusterPolicy.m_Replicated;
        String ownMemberName = spaceImpl.getConfigReader().getFullSpaceName();
        int CORE_POOL_SIZE = isReplicated ? clusterPolicy.getReplicationPolicy().getConnectionMonitorThreadPoolSize() : 4;
        long MONITOR_DISCONNECTED_DELAY = 1L;
        long MONITOR_CONNECTED_DELAY = 3L;
        long FINDER_TIMEOUT = 5000L;
        ReplicationLookupFinderService lookupService = new ReplicationLookupFinderService(5000L);
        ReplicationLookupParameters defaultLookupParameters = ReplicationLookupParameters.getEnvironmentLookupParameters();
        LusScheduledPoolConnectionMonitor connectionMonitor = new LusScheduledPoolConnectionMonitor(ownMemberName, CORE_POOL_SIZE, 3L, 1L, TimeUnit.SECONDS, lookupService);
        LRMIAsyncContextProvider asyncContextProvider = new LRMIAsyncContextProvider();
        GatewayConfig gatewayConfig = GatewayConfig.fromClusterInfo(spaceImpl.getClusterInfo());
        GatewaysPolicy gatewaysPolicy = gatewayConfig.getGatewaysPolicy();
        LusReplicationRouter.Builder lusReplicationRouterBuilder = new LusReplicationRouter.Builder(ownMemberName, (IConnectionMonitor<Iterable<IReplicationLookupParameters>, String>)connectionMonitor, (IServiceExporter)new SpaceServiceExporter(spaceImpl), spaceImpl.getUuid(), (IAsyncContextProvider)asyncContextProvider, lookupService, defaultLookupParameters, new RoutingUrlConverter(gatewaysPolicy.getLocalSiteName()), true);
        return new UnifiedReplicationRouter.Builder(spaceProxyReplicationRouterBuilder, lusReplicationRouterBuilder);
    }
}

