/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.router;

import com.gigaspaces.internal.cluster.node.impl.IServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupFinderService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupResult;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.IRoutingUrlConverter;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractConnectionProxyBasedReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IAsyncContextProvider;
import com.gigaspaces.internal.cluster.node.impl.router.IIncomingReplicationHandler;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.MemberProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.DisconnectionProxy;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.utils.StringUtils;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.logging.Level;
import net.jini.id.Uuid;

public class LusReplicationRouter
extends AbstractConnectionProxyBasedReplicationRouter<Iterable<IReplicationLookupParameters>, String>
implements IReplicationRouter {
    protected final IReplicationLookupFinderService _replicationLookupService;
    private final IReplicationLookupParameters _lookupParametersTemplate;
    private final IRoutingUrlConverter _routingNameConverter;

    public LusReplicationRouter(String myLookupName, Uuid uuid, IConnectionMonitor<Iterable<IReplicationLookupParameters>, String> connectionMonitor, IServiceExporter serviceExporter, IIncomingReplicationHandler incomingReplicationHandler, IAsyncContextProvider asyncContextProvider, IReplicationLookupFinderService replicationLookupService, IReplicationLookupParameters lookupParametersTemplate, IRoutingUrlConverter routingNameConverter, boolean setMyIdBeforeDispatch) {
        super(myLookupName, uuid, connectionMonitor, serviceExporter, incomingReplicationHandler, asyncContextProvider, setMyIdBeforeDispatch);
        if (routingNameConverter == null) {
            throw new IllegalArgumentException("routingNameConverter cannot be null");
        }
        if (replicationLookupService == null) {
            throw new IllegalArgumentException("replicationLookupService cannot be null");
        }
        if (lookupParametersTemplate == null) {
            throw new IllegalArgumentException("lookupParametersTemplate cannot be null");
        }
        this._replicationLookupService = replicationLookupService;
        this._lookupParametersTemplate = lookupParametersTemplate;
        this._routingNameConverter = routingNameConverter;
    }

    public IReplicationMonitoredConnection getUrlConnection(Object customUrl) {
        throw new UnsupportedOperationException();
    }

    protected AbstractProxyBasedReplicationMonitoredConnection<Iterable<IReplicationLookupParameters>, String> createNewMemberConnection(String lookupName, boolean connectSynchronously) {
        Iterable<String> routingUrl = this._routingNameConverter.convertToUrl(lookupName);
        LinkedList<IReplicationLookupParameters> lookupParametersList = new LinkedList<IReplicationLookupParameters>();
        for (String string : routingUrl) {
            IReplicationLookupParameters lookupParameters = this._lookupParametersTemplate.clone();
            lookupParameters.setLookupName(string);
            lookupParametersList.add(lookupParameters);
        }
        if (connectSynchronously) {
            return this.createConnectionAndConnect(lookupName, lookupParametersList);
        }
        return this.createConnection(lookupName, lookupParametersList);
    }

    protected MemberProxyBasedReplicationMonitoredConnection<Iterable<IReplicationLookupParameters>, String> createConnection(String lookupName, Iterable<IReplicationLookupParameters> lookupParameters) {
        ConnectionState connectionState = ConnectionState.DISCONNECTED;
        Uuid proxyId = null;
        DisconnectionProxy connectionProxy = new DisconnectionProxy();
        String endpointLookupName = null;
        Exception lastDisconnectionReason = null;
        return new MemberProxyBasedReplicationMonitoredConnection((AbstractConnectionProxyBasedReplicationRouter)this, lookupName, (IReplicationConnectionProxy)connectionProxy, lookupParameters, endpointLookupName, this.getConnectionMonitor(), (Object)lookupName, connectionState, lastDisconnectionReason, proxyId, this.getAsyncContextProvider(), true);
    }

    protected MemberProxyBasedReplicationMonitoredConnection<Iterable<IReplicationLookupParameters>, String> createConnectionAndConnect(String lookupName, Iterable<IReplicationLookupParameters> lookupParametersList) {
        ConnectionState connectionState = ConnectionState.DISCONNECTED;
        Uuid proxyId = null;
        DisconnectionProxy connectionProxy = new DisconnectionProxy();
        String endpointLookupName = null;
        RemoteException lastDisconnectionReason = null;
        for (IReplicationLookupParameters lookupParameters : lookupParametersList) {
            try {
                IReplicationLookupResult lookupResult;
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("finding proxy to member using lookup parameters: " + StringUtils.NEW_LINE + lookupParameters);
                }
                if ((lookupResult = this._replicationLookupService.findConnectionProxy(lookupParameters)) == null) continue;
                connectionProxy = lookupResult.getServiceProxy();
                if (connectionProxy == null) {
                    throw new IllegalStateException("Got null connection proxy");
                }
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("found proxy to member " + lookupParameters.getLookupName() + ", pinging member and establishing connection");
                }
                this.pingStub((IReplicationConnectionProxy)connectionProxy);
                connectionState = ConnectionState.CONNECTED;
                proxyId = lookupResult.getServiceId();
                endpointLookupName = lookupParameters.getLookupName();
                break;
            }
            catch (RemoteException e) {
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("could not find proxy to member " + lookupParameters.getLookupName() + " [" + e.getMessage() + "]");
                }
                lastDisconnectionReason = e;
            }
        }
        MemberProxyBasedReplicationMonitoredConnection connection = new MemberProxyBasedReplicationMonitoredConnection((AbstractConnectionProxyBasedReplicationRouter)this, lookupName, (IReplicationConnectionProxy)connectionProxy, lookupParametersList, endpointLookupName, this.getConnectionMonitor(), (Object)lookupName, connectionState, (Exception)lastDisconnectionReason, proxyId, this.getAsyncContextProvider(), true);
        return connection;
    }

    public static class Builder
    extends ReplicationRouterBuilder<LusReplicationRouter> {
        private final String _myLookupName;
        private final IConnectionMonitor<Iterable<IReplicationLookupParameters>, String> _connectionMonitor;
        private final IServiceExporter _serviceExporter;
        private final Uuid _uuid;
        private final IAsyncContextProvider _asyncContextProvider;
        private final IReplicationLookupFinderService _LookupService;
        private final IReplicationLookupParameters _lookupParametersTemplate;
        private final IRoutingUrlConverter _routingUrlConverter;
        private final boolean _setMyIdBeforeDispatch;

        public Builder(String myLookupName, IConnectionMonitor<Iterable<IReplicationLookupParameters>, String> connectionMonitor, IServiceExporter serviceExporter, Uuid uuid, IAsyncContextProvider asyncContextProvider, IReplicationLookupFinderService lookupService, IReplicationLookupParameters lookupParametersTemplate, IRoutingUrlConverter routingUrlConverter, boolean setMyIdBeforeDispatch) {
            this._myLookupName = myLookupName;
            this._connectionMonitor = connectionMonitor;
            this._serviceExporter = serviceExporter;
            this._uuid = uuid;
            this._asyncContextProvider = asyncContextProvider;
            this._LookupService = lookupService;
            this._lookupParametersTemplate = lookupParametersTemplate;
            this._routingUrlConverter = routingUrlConverter;
            this._setMyIdBeforeDispatch = setMyIdBeforeDispatch;
        }

        public LusReplicationRouter create(IIncomingReplicationHandler handler) {
            return new LusReplicationRouter(this._myLookupName, this._uuid, this._connectionMonitor, this._serviceExporter, handler, this._asyncContextProvider, this._LookupService, this._lookupParametersTemplate, this._routingUrlConverter, this._setMyIdBeforeDispatch);
        }

        public String toString() {
            return "LusReplicationRouter.Builder [myLookupName=" + this._myLookupName + ", connectionMonitor=" + this._connectionMonitor + ", serviceExporter=" + this._serviceExporter + ", _uuid=" + this._uuid + ", asyncContextProvider=" + this._asyncContextProvider + ", LookupService=" + this._LookupService + ", defaultLookupParameters=" + this._lookupParametersTemplate + "]";
        }
    }
}

