/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.router;

import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupFinderService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupResult;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractScheduledPoolConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.utils.StringUtils;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.jini.id.Uuid;

public class LusScheduledPoolConnectionMonitor
extends AbstractScheduledPoolConnectionMonitor<Iterable<IReplicationLookupParameters>, String> {
    private final IReplicationLookupFinderService _replicationLookupService;

    public LusScheduledPoolConnectionMonitor(String myLookupName, int corePoolSize, long monitorConnectedDelay, long monitorDisconnectedDelay, TimeUnit timeUnit, IReplicationLookupFinderService replicationLookupService) {
        super(myLookupName, corePoolSize, monitorConnectedDelay, monitorDisconnectedDelay, timeUnit);
        this._replicationLookupService = replicationLookupService;
    }

    protected Runnable createMonitorDisconnectedTask(AbstractProxyBasedReplicationMonitoredConnection<Iterable<IReplicationLookupParameters>, String> connection) {
        return new MonitorDisconnectedConnectionTask(connection);
    }

    protected IReplicationLookupResult postConnectionEstablished(IReplicationLookupResult lookupResult, IReplicationLookupParameters lookupParameters, IReplicationRouter router) throws RemoteException {
        return lookupResult;
    }

    protected IReplicationLookupParameters prepareLookUpParameters(IReplicationLookupParameters lookupParameters) {
        return lookupParameters;
    }

    private class MonitorDisconnectedConnectionTask
    implements Runnable {
        private final AbstractProxyBasedReplicationMonitoredConnection<Iterable<IReplicationLookupParameters>, String> _connection;

        public MonitorDisconnectedConnectionTask(AbstractProxyBasedReplicationMonitoredConnection<Iterable<IReplicationLookupParameters>, String> connection) {
            this._connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LusScheduledPoolConnectionMonitor.this._specificLogger.isLoggable(Level.FINER)) {
                LusScheduledPoolConnectionMonitor.this._specificLogger.finer(LusScheduledPoolConnectionMonitor.this.getLogPrefix() + "trying to establish connection with " + this._connection.getTargetLookupName() + " [" + (String)this._connection.getFinderURL() + "]");
            }
            Iterable lookupParametersList = (Iterable)this._connection.getTag();
            for (IReplicationLookupParameters lookupParameters : lookupParametersList) {
                try {
                    if (LusScheduledPoolConnectionMonitor.this._specificLogger.isLoggable(Level.FINER)) {
                        LusScheduledPoolConnectionMonitor.this._specificLogger.finer("trying to establish a connection to member using lookup parameters: " + StringUtils.NEW_LINE + lookupParameters);
                    }
                    IReplicationLookupParameters templookupParameters = LusScheduledPoolConnectionMonitor.this.prepareLookUpParameters(lookupParameters);
                    IReplicationLookupResult lookupResult = LusScheduledPoolConnectionMonitor.this._replicationLookupService.findConnectionProxy(templookupParameters);
                    if (lookupResult != null) {
                        IReplicationConnectionProxy proxy = lookupResult.getServiceProxy();
                        this._connection.getRouter().pingStub(proxy);
                        lookupResult = LusScheduledPoolConnectionMonitor.this.postConnectionEstablished(lookupResult, lookupParameters, (IReplicationRouter)this._connection.getRouter());
                        proxy = lookupResult.getServiceProxy();
                        Uuid proxyId = lookupResult.getServiceId();
                        String endpointLookupName = this._connection.getTargetLookupName();
                        Object object = this._connection.getStateLock();
                        synchronized (object) {
                            if (LusScheduledPoolConnectionMonitor.this._specificLogger.isLoggable(Level.FINE)) {
                                LusScheduledPoolConnectionMonitor.this._specificLogger.fine(LusScheduledPoolConnectionMonitor.this.getLogPrefix() + "established connection with " + this._connection.getTargetLookupName() + " [" + (String)this._connection.getFinderURL() + "]");
                            }
                            this._connection.setConnected(proxy, (Object)lookupParametersList, endpointLookupName, proxyId);
                            LusScheduledPoolConnectionMonitor.this.stopMonitoring(this._connection);
                            LusScheduledPoolConnectionMonitor.this.monitor(this._connection);
                            break;
                        }
                    }
                    if (!LusScheduledPoolConnectionMonitor.this._specificLogger.isLoggable(Level.WARNING)) continue;
                    LusScheduledPoolConnectionMonitor.this._specificLogger.warning(LusScheduledPoolConnectionMonitor.this.getLogPrefix() + "failed to establish connection with " + this._connection.getTargetLookupName() + " [" + (String)this._connection.getFinderURL() + "]" + StringUtils.NEW_LINE + "no connection proxy available");
                }
                catch (Exception e) {
                    if (LusScheduledPoolConnectionMonitor.this._specificLogger.isLoggable(Level.FINEST)) {
                        LusScheduledPoolConnectionMonitor.this._specificLogger.log(Level.FINEST, LusScheduledPoolConnectionMonitor.this.getLogPrefix() + "failed to establish connection with " + this._connection.getTargetLookupName() + " [" + (String)this._connection.getFinderURL() + "]" + StringUtils.NEW_LINE, e);
                    }
                    this._connection.setLastDisconnectionReason(e);
                }
            }
        }
    }
}

