/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.router;

import com.gigaspaces.internal.cluster.node.impl.router.IIncomingReplicationHandler;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouterAdmin;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.utils.StringUtils;

public class UnifiedReplicationRouter
implements IReplicationRouter {
    private final IReplicationRouter _spaceProxyReplicationRouter;
    private final IReplicationRouter _lusReplicationRouter;

    public UnifiedReplicationRouter(IReplicationRouter spaceProxyReplicationRouter, IReplicationRouter lusReplicationRouter) {
        this._spaceProxyReplicationRouter = spaceProxyReplicationRouter;
        this._lusReplicationRouter = lusReplicationRouter;
    }

    public IReplicationMonitoredConnection getMemberConnectionAsync(String memberLookupName) {
        if (this.isLusReplicationComponentLookupName(memberLookupName)) {
            return this._lusReplicationRouter.getMemberConnectionAsync(memberLookupName);
        }
        return this._spaceProxyReplicationRouter.getMemberConnectionAsync(memberLookupName);
    }

    public IReplicationMonitoredConnection getMemberConnection(String memberLookupName) {
        if (this.isLusReplicationComponentLookupName(memberLookupName)) {
            return this._lusReplicationRouter.getMemberConnection(memberLookupName);
        }
        return this._spaceProxyReplicationRouter.getMemberConnection(memberLookupName);
    }

    private boolean isLusReplicationComponentLookupName(String memberLookupName) {
        return !memberLookupName.contains("_container") && !memberLookupName.startsWith("replication:NotifyDur:");
    }

    public IReplicationMonitoredConnection getUrlConnection(Object customUrl) {
        return this._spaceProxyReplicationRouter.getUrlConnection(customUrl);
    }

    public IReplicationMonitoredConnection getDirectConnection(RouterStubHolder remoteStubHolder) {
        return this._spaceProxyReplicationRouter.getDirectConnection(remoteStubHolder);
    }

    public void close() {
        this._spaceProxyReplicationRouter.close();
        this._lusReplicationRouter.close();
    }

    public String getMyLookupName() {
        return this._spaceProxyReplicationRouter.getMyLookupName();
    }

    public Object getMyUniqueId() {
        return this._spaceProxyReplicationRouter.getMyUniqueId();
    }

    public RouterStubHolder getMyStubHolder() {
        return this._spaceProxyReplicationRouter.getMyStubHolder();
    }

    public ReplicationEndpointDetails getMyEndpointDetails() {
        return this._spaceProxyReplicationRouter.getMyEndpointDetails();
    }

    public IReplicationRouterAdmin getAdmin() {
        return this._spaceProxyReplicationRouter.getAdmin();
    }

    public String dumpState() {
        StringBuilder dump = new StringBuilder("SpaceProxyRouter:");
        dump.append(StringUtils.NEW_LINE);
        dump.append(this._spaceProxyReplicationRouter.dumpState());
        dump.append(StringUtils.NEW_LINE);
        dump.append("LusRouter:");
        dump.append(StringUtils.NEW_LINE);
        dump.append(this._lusReplicationRouter.dumpState());
        return dump.toString();
    }

    public static class Builder
    extends ReplicationRouterBuilder<UnifiedReplicationRouter> {
        private final ReplicationRouterBuilder _spaceProxyRouterBuilder;
        private final ReplicationRouterBuilder _lusRouterBuilder;

        public Builder(ReplicationRouterBuilder spaceProxyRouterBuilder, ReplicationRouterBuilder lusRouterBuilder) {
            this._spaceProxyRouterBuilder = spaceProxyRouterBuilder;
            this._lusRouterBuilder = lusRouterBuilder;
        }

        public UnifiedReplicationRouter create(IIncomingReplicationHandler handler) {
            IReplicationRouter spaceProxyReplicationRouter = this._spaceProxyRouterBuilder.create(handler);
            IReplicationRouter lusReplicationRouter = this._lusRouterBuilder.create(handler);
            return new UnifiedReplicationRouter(spaceProxyReplicationRouter, lusReplicationRouter);
        }

        public String toString() {
            return "UnifiedReplicationRouter.Builder [spaceProxyRouterBuilder=" + this._spaceProxyRouterBuilder + ", lusRouterBuilder=" + this._lusRouterBuilder + "]";
        }
    }
}

