/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.cluster.replication.gateway.conflict.ConflictCause;
import com.gigaspaces.cluster.replication.gateway.conflict.DataConflictOperation;
import com.gigaspaces.cluster.replication.gateway.conflict.EntryAlreadyInSpaceConflict;
import com.gigaspaces.cluster.replication.gateway.conflict.EntryLockedUnderTransactionConflict;
import com.gigaspaces.cluster.replication.gateway.conflict.EntryNotInSpaceConflict;
import com.gigaspaces.cluster.replication.gateway.conflict.EntryVersionConflict;
import com.gigaspaces.cluster.replication.gateway.conflict.GeneralConflictCause;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.EntryVersionConflictException;
import com.j_spaces.core.client.OperationTimeoutException;
import java.util.LinkedList;
import java.util.List;
import net.jini.core.transaction.Transaction;

public abstract class AbstractLocalClusterOperationData
implements DataConflictOperation {
    protected List<AbstractLocalClusterOperationData> _pendingOperations;
    protected ConflictCause _conflictCause;
    protected boolean _aborted;
    protected final ISpaceProxy _spaceProxy;
    private final ITypeDesc _typeDescriptor;
    protected int _retriesCount;
    private int _resolveAttempt;
    protected ConflictCause _previousConflictCause;

    public AbstractLocalClusterOperationData(ISpaceProxy spaceProxy, ITypeDesc typeDescriptor) {
        this._spaceProxy = spaceProxy;
        this._typeDescriptor = typeDescriptor;
        this._retriesCount = 0;
        this._resolveAttempt = 0;
    }

    public boolean isSameOperationType(AbstractLocalClusterOperationData operationData) {
        return operationData != null ? this.getClass().equals(operationData.getClass()) : false;
    }

    public void addPendingOperation(AbstractLocalClusterOperationData operationData) {
        if (this._pendingOperations == null) {
            this._pendingOperations = new LinkedList<AbstractLocalClusterOperationData>();
        }
        this._pendingOperations.add(operationData);
    }

    public abstract boolean execute(Transaction var1) throws Exception;

    public abstract boolean supportsBatching();

    public void reset() {
        this._pendingOperations = null;
        this._previousConflictCause = this._conflictCause;
    }

    protected void overrideImpl() {
    }

    public void override() {
        if (!this.supportsOverride()) {
            throw new UnsupportedOperationException(this.toString() + " is not overridable");
        }
        this.overrideImpl();
    }

    public boolean hasConflict() {
        return this.getConflictCause() != null && this.getConflictCause() != this._previousConflictCause;
    }

    public void abort() {
        this._aborted = true;
    }

    public boolean isAborted() {
        return this._aborted;
    }

    protected boolean isOverriden() {
        return false;
    }

    public String toString() {
        String text = this.getOperationType() + " (uid=" + this.getUid() + ", entry=" + this.getOperationEntry() + ")";
        if (this.hasConflict()) {
            return text + " - " + this.getConflictCause().toString();
        }
        return text + " - no conflict";
    }

    protected boolean isRetryable(int maximumRetries) {
        return this.getConflictCause() instanceof EntryLockedUnderTransactionConflict && this._retriesCount < maximumRetries;
    }

    protected void incrementRetriesCounter() {
        ++this._retriesCount;
    }

    protected int getRetriesCount() {
        return this._retriesCount;
    }

    public int getResolveAttempt() {
        return this._resolveAttempt;
    }

    protected void incrementResolveAttempt() {
        ++this._resolveAttempt;
    }

    public ConflictCause getConflictCause() {
        return this._conflictCause;
    }

    public void setConflictCause(ConflictCause conflictCause) {
        this._conflictCause = conflictCause;
    }

    protected ConflictCause convertExceptionToConflict(Throwable error) {
        if (error instanceof EntryAlreadyInSpaceException) {
            return new EntryAlreadyInSpaceConflict();
        }
        if (error instanceof EntryNotInSpaceException) {
            return new EntryNotInSpaceConflict();
        }
        if (error instanceof EntryVersionConflictException) {
            EntryVersionConflictException e = (EntryVersionConflictException)error;
            return new EntryVersionConflict(e.getClientVersionID(), e.getSpaceVersionID());
        }
        if (error instanceof OperationTimeoutException) {
            return new EntryLockedUnderTransactionConflict();
        }
        return new GeneralConflictCause(error);
    }

    public boolean supportsAbort() {
        return true;
    }

    public String getResolutionDescription() {
        if (this._conflictCause == null && !this._aborted) {
            return this.toString();
        }
        return this.toString() + " [resolution=" + (this.isOverriden() ? "OVERRIDE" : "ABORT") + "]";
    }

    public SpaceTypeDescriptor getTypeDescriptor() {
        if (!this.supportsGetTypeDescriptor()) {
            throw new UnsupportedOperationException();
        }
        return this._typeDescriptor;
    }

    public boolean supportsGetTypeDescriptor() {
        return this._typeDescriptor != null;
    }
}

