/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.cluster.replication.gateway.conflict.DataConflict;
import com.gigaspaces.cluster.replication.gateway.conflict.DataConflictOperation;
import com.gigaspaces.cluster.replication.gateway.sync.OperationsBatchDataImpl;
import com.gigaspaces.cluster.replication.gateway.sync.TransactionDataImpl;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.handlers.ITransactionInContext;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.AbstractLocalClusterOperationData;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterChangeOperationData;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterPartialUpdateOperationData;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterRemoveByUIDOperationData;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterRemoveOperationData;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationDataConflict;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationSinkConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterUpdateOperationData;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterWriteOperationData;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITransportPacket;
import com.gigaspaces.internal.utils.BloomFilter;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.sync.OperationsBatchData;
import com.gigaspaces.sync.SynchronizationEndpointInterceptor;
import com.gigaspaces.sync.TransactionData;
import com.j_spaces.core.UnknownTypeException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.server.TransactionManager;

public abstract class AbstractLocalClusterReplicationInHandler {
    protected final ISpaceProxy _spaceProxy;
    protected final LocalClusterReplicationSinkConfig _config;
    private final ITransactionManagerProvider _transactionManagerProvider;

    public AbstractLocalClusterReplicationInHandler(ISpaceProxy spaceProxy, ITransactionManagerProvider transactionManagerProvider, LocalClusterReplicationSinkConfig config) {
        this._spaceProxy = spaceProxy;
        this._transactionManagerProvider = transactionManagerProvider;
        this._config = config;
    }

    protected void execute(IReplicationInBatchContext batchContext) throws Exception {
        this.execute(batchContext, null);
    }

    private void invokeAfterSynchronizingOperationsBatch(IReplicationInBatchContext batchContext) {
        block3: {
            SynchronizationEndpointInterceptor consolidationInterceptor = this._config.getSyncEndpointInterceptor();
            if (consolidationInterceptor == null) {
                return;
            }
            try {
                consolidationInterceptor.afterOperationsBatchSynchronization((OperationsBatchData)new OperationsBatchDataImpl(batchContext));
            }
            catch (Throwable t) {
                if (!batchContext.getContextLogger().isLoggable(Level.WARNING)) break block3;
                batchContext.getContextLogger().log(Level.WARNING, "Synchronization endpoint interceptor afterSynchronizingOperationsBatch caused an exception", t);
            }
        }
    }

    protected void executeTransactional(IReplicationInBatchContext batchContext, ITransactionInContext transactionContext) throws Exception {
        this.execute(batchContext, transactionContext);
    }

    private void invokeAfterSynchronizingTransaction(IReplicationInBatchContext batchContext, ITransactionInContext transactionContext) {
        block3: {
            SynchronizationEndpointInterceptor consolidationInterceptor = this._config.getSyncEndpointInterceptor();
            if (consolidationInterceptor == null) {
                return;
            }
            try {
                consolidationInterceptor.afterTransactionSynchronization((TransactionData)new TransactionDataImpl(batchContext, transactionContext));
            }
            catch (Throwable t) {
                if (!batchContext.getContextLogger().isLoggable(Level.WARNING)) break block3;
                batchContext.getContextLogger().log(Level.WARNING, "Synchronization endpoint interceptor afterSynchronizingTransaction caused an exception", t);
            }
        }
    }

    private void execute(IReplicationInBatchContext batchContext, ITransactionInContext transactionContext) throws Exception {
        List pendingContext = batchContext.getPendingContext();
        if (pendingContext.isEmpty()) {
            batchContext.currentConsumed();
            return;
        }
        Transaction transaction = null;
        try {
            boolean hadConflicts;
            do {
                boolean fromTransaction;
                transaction = TransactionFactory.create((TransactionManager)this._transactionManagerProvider.getTransactionManager(), (long)this._config.getTransactionTimeout()).transaction;
                AbstractLocalClusterOperationData firstPendingOperationData = null;
                hadConflicts = false;
                for (AbstractLocalClusterOperationData operationData : pendingContext) {
                    if (operationData.isAborted()) continue;
                    operationData.reset();
                    if (!operationData.supportsBatching()) {
                        if (firstPendingOperationData != null) {
                            hadConflicts |= !firstPendingOperationData.execute(transaction);
                            firstPendingOperationData = null;
                        }
                        hadConflicts |= !operationData.execute(transaction);
                        continue;
                    }
                    if (firstPendingOperationData == null) {
                        firstPendingOperationData = operationData;
                        firstPendingOperationData.addPendingOperation(firstPendingOperationData);
                        continue;
                    }
                    if (firstPendingOperationData.isSameOperationType(operationData)) {
                        firstPendingOperationData.addPendingOperation(operationData);
                        continue;
                    }
                    hadConflicts |= !firstPendingOperationData.execute(transaction);
                    firstPendingOperationData = operationData;
                    firstPendingOperationData.addPendingOperation(firstPendingOperationData);
                }
                if (firstPendingOperationData != null) {
                    hadConflicts |= !firstPendingOperationData.execute(transaction);
                }
                boolean bl = fromTransaction = transactionContext != null;
                if (!hadConflicts) {
                    transaction.commit(this._config.getTransactionTimeout());
                    if (fromTransaction) {
                        this.invokeAfterSynchronizingTransaction(batchContext, transactionContext);
                    } else {
                        this.invokeAfterSynchronizingOperationsBatch(batchContext);
                    }
                    batchContext.pendingConsumed();
                    batchContext.setTagObject(null);
                    continue;
                }
                try {
                    if (batchContext.getContextLogger().isLoggable(Level.FINER)) {
                        batchContext.getContextLogger().log(Level.FINER, "Conflict occurred - aborting current transaction.");
                    }
                    transaction.abort(this._config.getTransactionTimeout());
                }
                catch (Exception operationData) {
                    // empty catch block
                }
                transaction = null;
                boolean conflictResolutionInvoked = this.attemptToIvokeConflictResolver(batchContext, fromTransaction, pendingContext);
                if (conflictResolutionInvoked) continue;
                Thread.sleep(this._config.getTransactionLockRetryInterval());
            } while (hadConflicts);
        }
        catch (Exception e) {
            try {
                if (transaction != null) {
                    transaction.abort(this._config.getTransactionTimeout());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private boolean attemptToIvokeConflictResolver(IReplicationInBatchContext batchContext, boolean fromTransaction, List<AbstractLocalClusterOperationData> pendingContext) {
        if (fromTransaction) {
            return this.prepareAndInvokeTransactionConflictResolver(pendingContext, batchContext);
        }
        return this.prepareAndInvokeConflictResolver(pendingContext, batchContext);
    }

    private boolean prepareAndInvokeTransactionConflictResolver(List<AbstractLocalClusterOperationData> pendingContext, IReplicationInBatchContext batchContext) {
        boolean invokeConflictResolver = true;
        int retriesCount = 0;
        LinkedList<AbstractLocalClusterOperationData> conflictContextOperations = new LinkedList<AbstractLocalClusterOperationData>();
        for (AbstractLocalClusterOperationData operationData : pendingContext) {
            if (operationData.isAborted()) continue;
            if (operationData.hasConflict() && operationData.isRetryable(this._config.getMaximumRetriesOnTransactionLock())) {
                operationData.incrementRetriesCounter();
                retriesCount = operationData.getRetriesCount();
                invokeConflictResolver = false;
            }
            conflictContextOperations.add(operationData);
        }
        if (!invokeConflictResolver) {
            if (batchContext.getContextLogger().isLoggable(Level.WARNING)) {
                String sourceGatewayName = this.extractSourceGatewayName(batchContext);
                batchContext.getContextLogger().log(Level.WARNING, "Replication conflict encountered in transaction  [sourceGatewayName=" + (String)sourceGatewayName + "] " + conflictContextOperations + " retrying... [" + retriesCount + "/" + this._config.getMaximumRetriesOnTransactionLock() + "]");
            }
        } else {
            for (AbstractLocalClusterOperationData operationData : conflictContextOperations) {
                operationData.incrementResolveAttempt();
            }
            LocalClusterReplicationDataConflict conflictData = new LocalClusterReplicationDataConflict(conflictContextOperations.toArray(new AbstractLocalClusterOperationData[conflictContextOperations.size()]));
            this.invokeConflictResolver(batchContext, conflictData, true);
        }
        return invokeConflictResolver;
    }

    private boolean prepareAndInvokeConflictResolver(List<AbstractLocalClusterOperationData> pendingContext, IReplicationInBatchContext batchContext) {
        boolean invokeConflictResolver = true;
        for (AbstractLocalClusterOperationData operationData : pendingContext) {
            if (!operationData.hasConflict() || operationData.isAborted()) continue;
            if (operationData.isRetryable(this._config.getMaximumRetriesOnTransactionLock())) {
                operationData.incrementRetriesCounter();
                invokeConflictResolver = false;
                if (!batchContext.getContextLogger().isLoggable(Level.WARNING)) continue;
                String sourceGatewayName = this.extractSourceGatewayName(batchContext);
                batchContext.getContextLogger().log(Level.WARNING, "Replication conflict encountered  [sourceGatewayName=" + sourceGatewayName + "] " + operationData + " retrying... [" + operationData.getRetriesCount() + "/" + this._config.getMaximumRetriesOnTransactionLock() + "]");
                continue;
            }
            operationData.incrementResolveAttempt();
            LocalClusterReplicationDataConflict conflictData = new LocalClusterReplicationDataConflict(new AbstractLocalClusterOperationData[]{operationData});
            this.invokeConflictResolver(batchContext, conflictData, false);
        }
        return invokeConflictResolver;
    }

    public ISpaceProxy getSpaceProxy() {
        return this._spaceProxy;
    }

    protected void handleWriteEntry(IEntryPacket entryPacket, IReplicationInBatchContext batchContext) throws UnknownTypeException {
        this.loadTypeDescriptorToPacket(entryPacket);
        batchContext.addPendingContext((Object)new LocalClusterWriteOperationData(this._spaceProxy, entryPacket));
    }

    protected void handleUpdateEntry(IEntryPacket entryPacket, IEntryPacket oldEntryPacket, IReplicationInBatchContext batchContext, boolean partialUpdate) throws UnknownTypeException {
        this.loadTypeDescriptorToPacket(entryPacket);
        if (partialUpdate) {
            batchContext.addPendingContext((Object)new LocalClusterPartialUpdateOperationData(this._spaceProxy, entryPacket));
        } else {
            batchContext.addPendingContext((Object)new LocalClusterUpdateOperationData(this._spaceProxy, entryPacket));
        }
    }

    protected void handleRemoveEntry(IEntryPacket entryPacket, IReplicationInBatchContext batchContext) throws UnknownTypeException {
        this.loadTypeDescriptorToPacket(entryPacket);
        batchContext.addPendingContext((Object)new LocalClusterRemoveOperationData(this._spaceProxy, entryPacket));
    }

    protected void handleChangeEntry(String typeName, String uid, Object id, int version, int previousVersion, int routingHash, long timeToLive, Collection<SpaceEntryMutator> mutators, IReplicationInBatchContext batchContext) throws UnknownTypeException {
        ITypeDesc typeDescriptor = this.getTypeDescriptorForType(typeName);
        batchContext.addPendingContext((Object)new LocalClusterChangeOperationData(this._spaceProxy, typeDescriptor, uid, id, version, previousVersion, routingHash, timeToLive, mutators));
    }

    private void loadTypeDescriptorToPacket(IEntryPacket entryPacket) throws UnknownTypeException {
        try {
            this._spaceProxy.getDirectProxy().getTypeManager().loadTypeDescToPacket((ITransportPacket)entryPacket);
        }
        catch (SpaceMetadataException e) {
            if (e.getCause() instanceof UnknownTypeException) {
                throw (UnknownTypeException)e.getCause();
            }
            throw e;
        }
    }

    private ITypeDesc getTypeDescriptorForType(String typeName) throws UnknownTypeException {
        try {
            return this._spaceProxy.getDirectProxy().getTypeManager().getTypeDescByName(typeName);
        }
        catch (SpaceMetadataException e) {
            if (e.getCause() instanceof UnknownTypeException) {
                throw (UnknownTypeException)e.getCause();
            }
            throw e;
        }
    }

    protected void handleRemoveEntryByUid(String typeName, String uid, IReplicationInBatchContext batchContext) throws UnknownTypeException {
        ITypeDesc typeDescriptor = StringUtils.hasText((String)typeName) ? this.getTypeDescriptorForType(typeName) : null;
        batchContext.addPendingContext((Object)new LocalClusterRemoveByUIDOperationData(this._spaceProxy, uid, typeDescriptor));
    }

    protected void invokeConflictResolver(IReplicationInBatchContext batchContext, LocalClusterReplicationDataConflict conflictData, boolean fromTransaction) {
        AbstractLocalClusterOperationData operationData;
        String sourceGatewayName = this.extractSourceGatewayName(batchContext);
        if (batchContext.getContextLogger().isLoggable(Level.WARNING)) {
            batchContext.getContextLogger().log(Level.WARNING, "Replication conflict encountered " + (fromTransaction ? "in transaction " : "") + conflictData + " [sourceGatewayName=" + sourceGatewayName + "]");
        }
        this._config.getConflictResolver().onDataConflict(sourceGatewayName, (DataConflict)conflictData);
        boolean actionTakenByConflictResolver = false;
        for (DataConflictOperation operation : conflictData.getOperations()) {
            operationData = (AbstractLocalClusterOperationData)operation;
            if (!operationData.isOverriden() && !operationData.isAborted()) continue;
            actionTakenByConflictResolver = true;
            break;
        }
        if (actionTakenByConflictResolver) {
            for (DataConflictOperation operation : conflictData.getOperations()) {
                operationData = (AbstractLocalClusterOperationData)operation;
                if (!operationData.hasConflict() || operationData.isOverriden() || operationData.isAborted()) continue;
                operation.abort();
            }
        } else {
            conflictData.abortAll();
        }
        if (batchContext.getContextLogger().isLoggable(Level.WARNING)) {
            batchContext.getContextLogger().log(Level.WARNING, "Conflict resolution" + (fromTransaction ? " in transaction" : "") + " is: " + conflictData.getResolutionDescription() + " [sourceGatewayName=" + sourceGatewayName + "]");
        }
    }

    protected String extractSourceGatewayName(IReplicationInBatchContext batchContext) {
        String groupName = batchContext.getGroupName();
        String sourceGatewayName = groupName.substring(0, groupName.indexOf(58));
        return sourceGatewayName;
    }

    protected void executeIfUidPresent(IReplicationInBatchContext batchContext, String uid) throws Exception {
        BloomFilter bloomFilter = (BloomFilter)batchContext.getTagObject();
        if (bloomFilter != null && bloomFilter.isPresent(uid)) {
            this.execute(batchContext);
            bloomFilter = null;
        }
        if (bloomFilter == null) {
            bloomFilter = BloomFilter.getFilter((long)batchContext.getEntireBatchSize(), (double)0.05);
            batchContext.setTagObject((Object)bloomFilter);
        }
        bloomFilter.add(uid);
    }
}

