/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.client.WriteMultipleException;
import com.gigaspaces.cluster.replication.gateway.conflict.ConflictCause;
import com.gigaspaces.cluster.replication.gateway.conflict.EntryLockedUnderTransactionConflict;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.StorageTypeDeserialization;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.AbstractLocalClusterOperationData;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.IEntryPacket;
import net.jini.core.transaction.Transaction;

public abstract class AbstractLocalClusterWriteOperationData
extends AbstractLocalClusterOperationData {
    private IEntryPacket _entryPacket;
    private boolean _overriden;
    private Object _convertedObject;

    public AbstractLocalClusterWriteOperationData(ISpaceProxy spaceProxy, IEntryPacket entryPacket) {
        super(spaceProxy, entryPacket.getTypeDescriptor());
        this._entryPacket = entryPacket;
    }

    @Override
    public boolean execute(Transaction transaction) throws Exception {
        Object[] entries = new IEntryPacket[this._pendingOperations.size()];
        long[] leases = new long[entries.length];
        int entryIndex = 0;
        for (AbstractLocalClusterOperationData operationData : this._pendingOperations) {
            AbstractLocalClusterWriteOperationData writeOperationData = (AbstractLocalClusterWriteOperationData)operationData;
            if (writeOperationData._overriden && writeOperationData._convertedObject != null) {
                this.replaceOriginalEntryPacketWithChanges(writeOperationData);
            }
            entries[entryIndex] = writeOperationData._entryPacket;
            leases[entryIndex] = entries[entryIndex].getTTL();
            ++entryIndex;
        }
        try {
            this._spaceProxy.writeMultiple(entries, transaction, Long.MIN_VALUE, leases, 0L, this.getUpdateModifiers());
            return true;
        }
        catch (WriteMultipleException e) {
            for (int i = 0; i < e.getResults().length; ++i) {
                WriteMultipleException.IWriteResult result = e.getResults()[i];
                if (!result.isError()) continue;
                if (this.isConflictError(result.getError())) {
                    ((AbstractLocalClusterOperationData)this._pendingOperations.get(i)).setConflictCause(this.convertExceptionToConflict(result.getError()));
                    continue;
                }
                throw e;
            }
            return false;
        }
    }

    private void replaceOriginalEntryPacketWithChanges(AbstractLocalClusterWriteOperationData writeOperationData) {
        IEntryPacket entryPacket;
        writeOperationData._entryPacket = entryPacket = this.createEntryPacketFromConvertedObject(writeOperationData);
    }

    private IEntryPacket createEntryPacketFromConvertedObject(AbstractLocalClusterWriteOperationData writeOperationData) {
        IEntryPacket entryPacket = this._spaceProxy.getDirectProxy().getTypeManager().getEntryPacketFromObject(writeOperationData._convertedObject, ObjectType.fromObject((Object)this._convertedObject));
        if (entryPacket.getUID() == null) {
            entryPacket.setUID(writeOperationData._entryPacket.getUID());
        }
        entryPacket.setOperationID(writeOperationData._entryPacket.getOperationID());
        entryPacket.setVersion(writeOperationData._entryPacket.getVersion());
        entryPacket.setPreviousVersion(writeOperationData._entryPacket.getPreviousVersion());
        return entryPacket;
    }

    public boolean supportsOverride() {
        return true;
    }

    @Override
    protected void overrideImpl() {
        this._overriden = true;
    }

    @Override
    public boolean isSameOperationType(AbstractLocalClusterOperationData operationData) {
        return super.isSameOperationType(operationData) && this.getUpdateModifiers() == ((AbstractLocalClusterWriteOperationData)operationData).getUpdateModifiers();
    }

    protected abstract boolean isConflictError(Throwable var1);

    private int getUpdateModifiers() {
        boolean lockedUnderTransactionConflict;
        boolean bl = lockedUnderTransactionConflict = this._previousConflictCause != null && this._previousConflictCause instanceof EntryLockedUnderTransactionConflict;
        if (this._overriden && !lockedUnderTransactionConflict) {
            return this.getOverrideUpdateModifiers() | 0x80000;
        }
        return this.getUpdateModifiersImpl();
    }

    protected abstract int getOverrideUpdateModifiers();

    protected abstract int getUpdateModifiersImpl();

    public Object getOperationEntry() {
        if (this._convertedObject == null) {
            this._convertedObject = this._spaceProxy.getDirectProxy().getTypeManager().getObjectFromEntryPacket(this._entryPacket, QueryResultTypeInternal.NOT_SET, false);
        }
        return this._convertedObject;
    }

    public String getUid() {
        return this._entryPacket.getUID();
    }

    @Override
    protected boolean isOverriden() {
        return this._overriden;
    }

    @Override
    public void setConflictCause(ConflictCause conflictCause) {
        super.setConflictCause(conflictCause);
        this._convertedObject = null;
    }

    public boolean supportsDataAsDocument() {
        return true;
    }

    public SpaceDocument getDataAsDocument() {
        IEntryPacket entryPacket = this._entryPacket;
        if (this._convertedObject != null && !(this._convertedObject instanceof SpaceDocument)) {
            entryPacket = this.createEntryPacketFromConvertedObject(this);
            this._convertedObject = null;
        }
        if (this._convertedObject == null) {
            this._convertedObject = this._spaceProxy.getDirectProxy().getTypeManager().getObjectFromEntryPacket(entryPacket, QueryResultTypeInternal.DOCUMENT_ENTRY, false, StorageTypeDeserialization.LAZY, null);
        }
        return (SpaceDocument)this._convertedObject;
    }

    public boolean supportsDataAsObject() {
        ITypeDesc typeDesc = this._entryPacket.getTypeDescriptor();
        return typeDesc.isConcreteType() && typeDesc.isAllPropertiesObjectStorageType();
    }

    public Object getDataAsObject() {
        if (!this.supportsDataAsObject()) {
            throw new UnsupportedOperationException();
        }
        IEntryPacket entryPacket = this._entryPacket;
        if (this._convertedObject != null && this._convertedObject instanceof SpaceDocument) {
            entryPacket = this.createEntryPacketFromConvertedObject(this);
            this._convertedObject = null;
        }
        if (this._convertedObject == null) {
            this._convertedObject = this._spaceProxy.getDirectProxy().getTypeManager().getObjectFromEntryPacket(entryPacket, QueryResultTypeInternal.OBJECT_JAVA, false);
        }
        return this._convertedObject;
    }

    public boolean supportsGetSpaceId() {
        return true;
    }

    public Object getSpaceId() {
        return this._entryPacket.getID();
    }
}

