/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.client.ChangeException;
import com.gigaspaces.client.ChangeModifiers;
import com.gigaspaces.client.ChangeSet;
import com.gigaspaces.client.ChangeSetInternalUtils;
import com.gigaspaces.client.FailedChangedEntryDetails;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.cluster.replication.gateway.conflict.DataConflictOperation;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.AbstractLocalClusterOperationData;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.sync.DataSyncOperationType;
import com.gigaspaces.sync.change.DataSyncChangeSet;
import java.util.Collection;
import net.jini.core.transaction.Transaction;

public class LocalClusterChangeOperationData
extends AbstractLocalClusterOperationData
implements DataSyncChangeSet {
    private final String _uid;
    private final Object _id;
    private final int _version;
    private final int _previousVersion;
    private final int _routingHash;
    private final long _timeToLive;
    private final Collection<SpaceEntryMutator> _mutators;

    public LocalClusterChangeOperationData(ISpaceProxy spaceProxy, ITypeDesc typeDescriptor, String uid, Object id, int version, int previousVersion, int routingHash, long timeToLive, Collection<SpaceEntryMutator> mutators) {
        super(spaceProxy, typeDescriptor);
        this._uid = uid;
        this._id = id;
        this._version = version;
        this._previousVersion = previousVersion;
        this._routingHash = routingHash;
        this._timeToLive = timeToLive;
        this._mutators = mutators;
    }

    @Deprecated
    public DataConflictOperation.OperationType getOperationType() {
        return DataConflictOperation.OperationType.CHANGE;
    }

    @Deprecated
    public Object getOperationEntry() {
        return null;
    }

    public boolean supportsOverride() {
        return false;
    }

    public String getUid() {
        return this._uid;
    }

    public DataSyncOperationType getDataSyncOperationType() {
        return DataSyncOperationType.CHANGE;
    }

    public Object getDataAsObject() {
        throw new UnsupportedOperationException();
    }

    public SpaceDocument getDataAsDocument() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsDataAsObject() {
        return false;
    }

    public boolean supportsDataAsDocument() {
        return false;
    }

    @Override
    public boolean execute(Transaction transaction) throws Exception {
        ITemplatePacket template = TemplatePacketFactory.createUidPacket((String)this._uid, (Object)this._routingHash, (int)this._version, (QueryResultTypeInternal)QueryResultTypeInternal.NOT_SET);
        template.setPreviousVersion(this._previousVersion);
        ChangeSet changeSet = ChangeSetInternalUtils.fromParameters(this._mutators, (long)this._timeToLive);
        try {
            this._spaceProxy.change((Object)template, changeSet, transaction, 0L, ChangeModifiers.NONE);
            return true;
        }
        catch (ChangeException e) {
            Collection failedChanges = e.getFailedChanges();
            Collection errors = e.getErrors();
            if (!failedChanges.isEmpty()) {
                this.setConflictCause(this.convertExceptionToConflict(((FailedChangedEntryDetails)failedChanges.iterator().next()).getCause()));
            } else if (!errors.isEmpty()) {
                this.setConflictCause(this.convertExceptionToConflict(((Throwable)errors.iterator().next()).getCause()));
            } else {
                this.setConflictCause(this.convertExceptionToConflict(e));
            }
            return false;
        }
    }

    @Override
    public boolean supportsBatching() {
        return false;
    }

    public Collection getOperations() {
        return this._mutators;
    }

    public Object getId() {
        return this._id;
    }

    public int getVersion() {
        return this._version;
    }

    public long getTimeToLive() {
        return this._timeToLive;
    }

    public boolean supportsGetSpaceId() {
        return true;
    }

    public Object getSpaceId() {
        return this.getId();
    }
}

