/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.cluster.replication.gateway.conflict.DataConflictOperation;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.AbstractLocalClusterOperationData;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.sync.DataSyncOperationType;
import net.jini.core.transaction.Transaction;

public class LocalClusterRemoveByUIDOperationData
extends AbstractLocalClusterOperationData {
    private final String _uid;

    public LocalClusterRemoveByUIDOperationData(ISpaceProxy spaceProxy, String uid, ITypeDesc typeDescriptor) {
        super(spaceProxy, typeDescriptor);
        this._uid = uid;
    }

    @Override
    public boolean execute(Transaction transaction) throws Exception {
        String[] uids = new String[this._pendingOperations.size()];
        int uidIndex = 0;
        for (AbstractLocalClusterOperationData operationData : this._pendingOperations) {
            uids[uidIndex++] = ((LocalClusterRemoveByUIDOperationData)operationData)._uid;
        }
        ITemplatePacket templatePacket = TemplatePacketFactory.createUidsPacket((String[])uids, (QueryResultTypeInternal)QueryResultTypeInternal.NOT_SET, (boolean)false);
        this._spaceProxy.clear((Object)templatePacket, transaction, 0);
        return true;
    }

    @Override
    public boolean isSameOperationType(AbstractLocalClusterOperationData operationData) {
        return operationData instanceof LocalClusterRemoveByUIDOperationData;
    }

    @Override
    public boolean supportsBatching() {
        return true;
    }

    public DataConflictOperation.OperationType getOperationType() {
        return DataConflictOperation.OperationType.REMOVE_BY_UID;
    }

    public DataSyncOperationType getDataSyncOperationType() {
        return DataSyncOperationType.REMOVE_BY_UID;
    }

    public Object getOperationEntry() {
        return null;
    }

    public String getUid() {
        return this._uid;
    }

    public boolean supportsOverride() {
        return false;
    }

    public boolean supportsDataAsDocument() {
        return false;
    }

    public SpaceDocument getDataAsDocument() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsDataAsObject() {
        return false;
    }

    public Object getDataAsObject() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsGetSpaceId() {
        return false;
    }

    public Object getSpaceId() {
        throw new UnsupportedOperationException();
    }
}

