/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.cluster.replication.gateway.conflict.DataConflict;
import com.gigaspaces.cluster.replication.gateway.conflict.DataConflictOperation;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.AbstractLocalClusterOperationData;
import java.util.Arrays;

public class LocalClusterReplicationDataConflict
implements DataConflict {
    private final AbstractLocalClusterOperationData[] _operationData;

    protected LocalClusterReplicationDataConflict(AbstractLocalClusterOperationData[] operationData) {
        this._operationData = operationData;
    }

    public DataConflictOperation[] getOperations() {
        return this._operationData;
    }

    public void abortAll() {
        for (AbstractLocalClusterOperationData operationData : this._operationData) {
            operationData.abort();
        }
    }

    public void overrideAll() {
        for (AbstractLocalClusterOperationData operationData : this._operationData) {
            if (!operationData.hasConflict() || !operationData.supportsOverride()) continue;
            operationData.override();
        }
    }

    public String toString() {
        return Arrays.toString(this._operationData);
    }

    public String getResolutionDescription() {
        StringBuilder resolution = new StringBuilder("[");
        if (this._operationData.length > 0) {
            resolution.append(this._operationData[0].getResolutionDescription());
        }
        for (int i = 1; i < this._operationData.length; ++i) {
            resolution.append(", ");
            resolution.append(this._operationData[i].getResolutionDescription());
        }
        resolution.append("]");
        return resolution.toString();
    }
}

