/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.UpdateLeaseSpaceOperationRequest;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseCancelledHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseExtendedHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.AbstractLocalClusterReplicationInHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationSinkConfig;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.transport.IEntryPacket;
import java.util.logging.Level;

public class LocalClusterReplicationEntryLeaseEventHandler
extends AbstractLocalClusterReplicationInHandler
implements IReplicationInEntryLeaseCancelledHandler,
IReplicationInEntryLeaseExtendedHandler {
    LocalClusterReplicationEntryLeaseEventHandler(ISpaceProxy spaceProxy, ITransactionManagerProvider transactionManagerProvider, LocalClusterReplicationSinkConfig config) {
        super(spaceProxy, transactionManagerProvider, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inExtendEntryLeasePeriod(IReplicationInContext context, String typeName, String uid, boolean isTransient, long lease, int routingValue) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.execute(batchContext);
        try {
            UpdateLeaseSpaceOperationRequest request = new UpdateLeaseSpaceOperationRequest(uid, typeName, 1, lease, (Object)(routingValue == -1 ? null : Integer.valueOf(routingValue)));
            this.executeRequest((SpaceOperationRequest)request);
        }
        catch (Exception ex) {
            if (context.getContextLogger().isLoggable(Level.WARNING)) {
                context.getContextLogger().log(Level.WARNING, "Failed to extend Entry lease: " + typeName + " UID: " + uid + " ObjectType: " + 1 + " in target [" + this._config.getMySiteName() + "] gateway.\nThis entry might be already canceled.", ex);
            }
        }
        finally {
            batchContext.currentConsumed();
        }
    }

    private void executeRequest(SpaceOperationRequest request) throws InterruptedException {
        this._spaceProxy.getDirectProxy().getProxyRouter().execute((RemoteOperationRequest)request);
    }

    public void inCancelEntryLease(IReplicationInContext context, IEntryPacket entryPacket) throws Exception {
        this.inCancelEntryLeaseByUID(context, entryPacket.getTypeName(), entryPacket.getUID(), entryPacket.isTransient(), entryPacket.getRoutingFieldValue() == null ? -1 : entryPacket.getRoutingFieldValue().hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inCancelEntryLeaseByUID(IReplicationInContext context, String typeName, String uid, boolean isTransient, int routingValue) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.execute(batchContext);
        try {
            UpdateLeaseSpaceOperationRequest request = new UpdateLeaseSpaceOperationRequest(uid, typeName, 1, -1L, (Object)(routingValue == -1 ? null : Integer.valueOf(routingValue)));
            this.executeRequest((SpaceOperationRequest)request);
            request.getFinalResult().processExecutionException();
        }
        catch (Exception ex) {
            if (context.getContextLogger().isLoggable(Level.WARNING)) {
                context.getContextLogger().log(Level.WARNING, "Failed to cancel Entry lease: " + typeName + " UID: " + uid + " ObjectType: " + 1 + " in target [" + this._config.getMySiteName() + "] gateway.\nThis entry might be already expired or canceled.", ex);
            }
        }
        finally {
            batchContext.currentConsumed();
        }
    }
}

