/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.AbstractLocalClusterReplicationInHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationSinkConfig;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.OperationID;
import java.util.Collection;

public class LocalClusterReplicationInEntryHandler
extends AbstractLocalClusterReplicationInHandler
implements IReplicationInEntryHandler {
    public LocalClusterReplicationInEntryHandler(ISpaceProxy spaceProxy, ITransactionManagerProvider transactionManagerProvider, LocalClusterReplicationSinkConfig config) {
        super(spaceProxy, transactionManagerProvider, config);
    }

    public void inWriteEntry(IReplicationInContext context, IEntryPacket entryPacket) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.executeIfUidPresent(batchContext, entryPacket.getUID());
        this.handleWriteEntry(entryPacket, batchContext);
    }

    public void inUpdateEntry(IReplicationInContext context, IEntryPacket entryPacket, IEntryPacket oldEntryPacket, boolean partialUpdate, boolean overrideVersion, short flags) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.executeIfUidPresent(batchContext, entryPacket.getUID());
        this.handleUpdateEntry(entryPacket, oldEntryPacket, batchContext, partialUpdate);
    }

    public void inChangeEntry(IReplicationInContext context, String typeName, String uid, Object id, int version, int previousVersion, int routingHash, long timeToLive, Collection<SpaceEntryMutator> mutators, boolean isTransient, OperationID operationID) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.executeIfUidPresent(batchContext, uid);
        this.handleChangeEntry(typeName, uid, id, version, previousVersion, routingHash, timeToLive, mutators, batchContext);
    }

    public void inRemoveEntry(IReplicationInContext context, IEntryPacket entryPacket) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.executeIfUidPresent(batchContext, entryPacket.getUID());
        this.handleRemoveEntry(entryPacket, batchContext);
    }

    public void inRemoveEntryByUID(IReplicationInContext context, String typeName, String uid, boolean isTransient, OperationID operationID) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.executeIfUidPresent(batchContext, uid);
        this.handleRemoveEntryByUid(typeName, uid, (IReplicationInBatchContext)context);
    }

    public void afterConsumption(IReplicationInContext context, boolean successful, long lastProcessedKey) {
    }

    public void beforeConsume(IReplicationInContext context) {
    }
}

