/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInTransactionHandler;
import com.gigaspaces.internal.cluster.node.handlers.ITransactionInContext;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.AbstractLocalClusterReplicationInHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationSinkConfig;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalBatchExecutionCallback;
import com.gigaspaces.internal.sync.ConsolidationParticipantDataImpl;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.sync.ConsolidationParticipantData;
import com.gigaspaces.sync.SynchronizationEndpointInterceptor;
import com.gigaspaces.transaction.TransactionParticipantMetaData;
import com.j_spaces.core.OperationID;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

public class LocalClusterReplicationInTransactionHandler
extends AbstractLocalClusterReplicationInHandler
implements IReplicationInTransactionHandler,
ITransactionalBatchExecutionCallback {
    public LocalClusterReplicationInTransactionHandler(ISpaceProxy spaceProxy, ITransactionManagerProvider transactionManagerProvider, LocalClusterReplicationSinkConfig config) {
        super(spaceProxy, transactionManagerProvider, config);
    }

    public void inTransaction(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        SynchronizationEndpointInterceptor interceptor;
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.execute(batchContext);
        List packetsData = (List)transactionContext;
        for (IReplicationTransactionalPacketEntryData packetData : packetsData) {
            packetData.batchExecuteTransactional(batchContext, (ITransactionalBatchExecutionCallback)this);
        }
        if (context.supportsDistributedTransactionConsolidation() && transactionContext.getMetaData() != null && transactionContext.getMetaData().isUnconsoliated() && (interceptor = this._config.getSyncEndpointInterceptor()) != null) {
            ConsolidationParticipantDataImpl consolidationParticipantData;
            block7: {
                List dataItems = batchContext.getPendingContext();
                consolidationParticipantData = new ConsolidationParticipantDataImpl(dataItems, (TransactionParticipantMetaData)transactionContext.getMetaData(), context);
                try {
                    interceptor.onTransactionConsolidationFailure((ConsolidationParticipantData)consolidationParticipantData);
                }
                catch (Throwable t) {
                    if (!context.getContextLogger().isLoggable(Level.WARNING)) break block7;
                    context.getContextLogger().log(Level.WARNING, "exception caught when executing transaction consolidation interceptor on consolidation aborted [" + consolidationParticipantData + "] - ignoring exception", t);
                }
            }
            if (consolidationParticipantData.isAborted()) {
                if (context.getContextLogger().isLoggable(Level.WARNING)) {
                    context.getContextLogger().warning("aborting unconsolidated distributed transaction [" + consolidationParticipantData + "]");
                }
                batchContext.pendingConsumed();
                batchContext.setTagObject(null);
                return;
            }
            if (context.getContextLogger().isLoggable(Level.WARNING)) {
                context.getContextLogger().warning("executing unconsolidated distributed transaction [" + consolidationParticipantData + "]");
            }
        }
        this.executeTransactional(batchContext, transactionContext);
    }

    public void inTransactionPrepare(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void inTransactionCommit(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void inTransactionAbort(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void writeEntry(IReplicationInBatchContext context, IEntryPacket entryPacket) throws Exception {
        this.handleWriteEntry(entryPacket, context);
    }

    public void removeEntry(IReplicationInBatchContext context, IEntryPacket entryPacket) throws Exception {
        this.handleRemoveEntry(entryPacket, context);
    }

    public void removeEntryByUID(IReplicationInBatchContext context, String typeName, String uid, OperationID operationID) throws Exception {
        this.handleRemoveEntryByUid(typeName, uid, context);
    }

    public void updateEntry(IReplicationInBatchContext context, IEntryPacket entryPacket, IEntryPacket oldEntryPacket, boolean partialUpdate, short flags) throws Exception {
        this.handleUpdateEntry(entryPacket, oldEntryPacket, context, partialUpdate);
    }

    public void changeEntry(IReplicationInBatchContext context, String typeName, String uid, Object id, int version, int previousVersion, long timeToLive, int routingHash, Collection<SpaceEntryMutator> spaceEntryMutators, boolean isTransient, OperationID operationID) throws Exception {
        this.handleChangeEntry(typeName, uid, id, version, previousVersion, routingHash, timeToLive, spaceEntryMutators, context);
    }
}

