/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.cluster.replication.gateway.conflict.AddIndexConflict;
import com.gigaspaces.cluster.replication.gateway.conflict.AddIndexesConflict;
import com.gigaspaces.cluster.replication.gateway.conflict.ConflictCause;
import com.gigaspaces.cluster.replication.gateway.conflict.DataTypeIntroductionConflict;
import com.gigaspaces.cluster.replication.gateway.conflict.RegisterTypeDescriptorConflict;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeCreatedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeIndexAddedHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.AbstractLocalClusterReplicationInHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationSinkConfig;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.space.requests.AddTypeIndexesRequestInfo;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.index.SpaceIndex;
import java.util.concurrent.ExecutionException;

public class LocalClusterReplicationMetadataEventHandler
extends AbstractLocalClusterReplicationInHandler
implements IReplicationInDataTypeCreatedHandler,
IReplicationInDataTypeIndexAddedHandler {
    public LocalClusterReplicationMetadataEventHandler(ISpaceProxy spaceProxy, ITransactionManagerProvider txnManagerProvider, LocalClusterReplicationSinkConfig config) {
        super(spaceProxy, txnManagerProvider, config);
    }

    public void inDataTypeIntroduce(IReplicationInContext context, final ITypeDesc typeDesc) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.execute(batchContext);
        try {
            this.getSpaceProxy().registerTypeDescriptor(typeDesc);
        }
        catch (SpaceMetadataException e) {
            RegisterTypeDescriptorConflict conflict = new RegisterTypeDescriptorConflict(){
                private final ConflictCause _conflictCause;
                {
                    this._conflictCause = new DataTypeIntroductionConflict(e.getMessage());
                }

                public SpaceTypeDescriptor getTypeDescriptor() {
                    return typeDesc;
                }

                public ConflictCause getConflictCause() {
                    return this._conflictCause;
                }
            };
            this._config.getConflictResolver().onRegisterTypeDescriptorConflict(this.extractSourceGatewayName(batchContext), conflict);
        }
        batchContext.currentConsumed();
    }

    public void inDataTypeAddIndex(IReplicationInContext context, final AddTypeIndexesRequestInfo requestInfo) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.execute(batchContext);
        try {
            this.getSpaceProxy().asyncAddIndexes(requestInfo.getTypeName(), requestInfo.getIndexes(), null).get();
        }
        catch (ExecutionException e) {
            final Throwable cause = e.getCause();
            if (cause instanceof SpaceMetadataException) {
                AddIndexConflict conflict = new AddIndexConflict(){
                    private final ConflictCause _conflictCause;
                    {
                        this._conflictCause = new AddIndexesConflict(cause.getMessage());
                    }

                    public String getTypeName() {
                        return requestInfo.getTypeName();
                    }

                    public SpaceIndex[] getIndexes() {
                        return requestInfo.getIndexes();
                    }

                    public ConflictCause getConflictCause() {
                        return this._conflictCause;
                    }
                };
                this._config.getConflictResolver().onAddIndexConflict(this.extractSourceGatewayName(batchContext), conflict);
            }
            throw e;
        }
        batchContext.currentConsumed();
    }
}

