/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupFinderService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupResult;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.LusScheduledPoolConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationSinkRouter;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;

public class LocalClusterReplicationScheduledPoolConnectionMonitor
extends LusScheduledPoolConnectionMonitor {
    public LocalClusterReplicationScheduledPoolConnectionMonitor(String myLookupName, int corePoolSize, long monitorConnectedDelay, long monitorDisconnectedDelay, TimeUnit timeUnit, IReplicationLookupFinderService replicationLookupService) {
        super(myLookupName, corePoolSize, monitorConnectedDelay, monitorDisconnectedDelay, timeUnit, replicationLookupService);
    }

    @Override
    protected IReplicationLookupParameters prepareLookUpParameters(IReplicationLookupParameters lookupParameters) {
        if (!LocalClusterReplicationSinkRouter.hasSinkRoutingDestination(lookupParameters.getLookupName())) {
            return super.prepareLookUpParameters(lookupParameters);
        }
        IReplicationLookupParameters result = lookupParameters.clone();
        result.setLookupName(LocalClusterReplicationSinkRouter.extractSinkDestinationUrl(lookupParameters.getLookupName()));
        return result;
    }

    @Override
    protected IReplicationLookupResult postConnectionEstablished(IReplicationLookupResult lookupResult, IReplicationLookupParameters lookupParameters, IReplicationRouter router) throws RemoteException {
        if (!LocalClusterReplicationSinkRouter.hasSinkRoutingDestination(lookupParameters.getLookupName())) {
            return super.postConnectionEstablished(lookupResult, lookupParameters, router);
        }
        LocalClusterReplicationSinkRouter sinkRouter = (LocalClusterReplicationSinkRouter)router;
        return sinkRouter.establishConnectionViaSink(lookupResult.getServiceProxy(), lookupParameters.getLookupName());
    }
}

