/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.client.transaction.TransactionManagerConfiguration;
import com.gigaspaces.client.transaction.TransactionManagerProviderFactory;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInBatchConsumptionHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeCreatedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeIndexAddedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseCancelledHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseExtendedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInTransactionHandler;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.IReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.IReplicationNodePluginFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfig;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeMode;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayReplicationUtils;
import com.gigaspaces.internal.cluster.node.impl.gateway.ReplicationNodeWithGatewayConfigBuilder;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.RoutingUrlConverter;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.BootstrapConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.IIncomingReplicationFacadeProvider;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalCLusterReplicationReplicaConsumeFacade;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationEntryLeaseEventHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationFixFacade;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationInBatchConsumptionHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationInEntryHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationInTransactionHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationMetadataEventHandler;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationScheduledPoolConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationSinkConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationSinkRouter;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.QueryRemoteClusterTopologyPacket;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.QueryRemoteClusterTopologyResult;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.ReplicationGatewayComponent;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.ReplicationSink;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.SinkEstablishConnectionPacket;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.SinkEstablishConnectionResult;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationDynamicTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncSingleOriginReplicationTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFixFacade;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataBatchConsumer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.ReliableAsyncAdaptiveProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.reliableasync.IReplicationReliableAsyncProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceCopyIntermediateResult;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaConsumeFacade;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceSynchronizeReplicaRequestContext;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaParameters;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyResult;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaRequestContext;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeResult;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.extension.XapExtensions;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.ScheduledThreadPoolAsyncHandlerProvider;
import com.gigaspaces.metrics.DummyMetricRegistrator;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.kernel.JSpaceUtilities;
import java.net.MalformedURLException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.TransactionException;
import net.jini.id.Uuid;

public class LocalClusterReplicationSink
extends ReplicationGatewayComponent
implements IReplicationNodePluginFacade,
IIncomingReplicationFacadeProvider {
    private final ReplicationSink _sink;
    private final LocalClusterReplicationSinkConfig _config;
    private final ExecutorService _executorService;
    private final Set<DelegatedConnection> _delegatedConnections = new HashSet<DelegatedConnection>();
    private final Logger _specificLogger;
    private volatile ISpaceProxy _localClusterProxy;
    private volatile ITransactionManagerProvider _transactionManagerProvider;
    private volatile ReplicationNode _replicationNode;
    private volatile ReplicationRouterBuilder _routerBuilder;
    private volatile boolean _closed;
    private boolean _enableIncomingReplication;
    private boolean _bootstrapping;

    public LocalClusterReplicationSink(LocalClusterReplicationSinkConfig config) {
        super(config);
        this._config = config;
        this._sink = new ReplicationSink(config.getMySiteName(), this._registrationService, this._lookupParametersTemplate, this._serviceExporter, this);
        this._specificLogger = Logger.getLogger("com.gigaspaces.replication.gateway.sink." + XapExtensions.getInstance().getReplicationUtils().toShortLookupName(this._sink.getMyLookupName()));
        this._executorService = Executors.newSingleThreadExecutor((ThreadFactory)new GSThreadFactory("LocalClusterFinder", true));
        String localClusterSpaceUrl = this._config.getLocalClusterSpaceUrl();
        try {
            SpaceURLParser.parseURL((String)localClusterSpaceUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Given space url is illegal", e);
        }
        this.findLocalCluster();
    }

    private void findLocalCluster() {
        this._executorService.execute(new Runnable(){

            @Override
            public void run() {
                Properties customProperties = new Properties();
                customProperties.put("gateway-proxy", "true");
                int iteration = 0;
                while (!LocalClusterReplicationSink.this._closed) {
                    try {
                        ISpaceProxy localClusterProxy = (ISpaceProxy)SpaceFinder.find((String)LocalClusterReplicationSink.this._config.getLocalClusterSpaceUrl(), (Properties)customProperties, null, (CredentialsProvider)LocalClusterReplicationSink.this._config.getCredentialsProvider());
                        LocalClusterReplicationSink.this._transactionManagerProvider = TransactionManagerProviderFactory.newInstance((IJSpace)LocalClusterReplicationSink.this._localClusterProxy, (TransactionManagerConfiguration)TransactionManagerConfiguration.newConfiguration((ITransactionManagerProvider.TransactionManagerType)ITransactionManagerProvider.TransactionManagerType.DISTRIBUTED));
                        localClusterProxy.setOptimisticLocking(true);
                        LocalClusterReplicationSink.this._localClusterProxy = localClusterProxy;
                        LocalClusterReplicationSink.this.onLocalClusterFound();
                        LocalClusterReplicationSink.this._config.clearCredentialsProvider();
                        break;
                    }
                    catch (FinderException e) {
                        if (iteration++ % 10 != 0 || !LocalClusterReplicationSink.this._specificLogger.isLoggable(Level.INFO)) continue;
                        LocalClusterReplicationSink.this._specificLogger.log(Level.INFO, "Could not find local cluster, retrying...", e);
                    }
                    catch (RemoteException e) {
                        if (!LocalClusterReplicationSink.this._specificLogger.isLoggable(Level.WARNING)) continue;
                        LocalClusterReplicationSink.this._specificLogger.log(Level.WARNING, "Error while creating transaction manager.", e);
                    }
                    catch (TransactionException e) {
                        if (!LocalClusterReplicationSink.this._specificLogger.isLoggable(Level.WARNING)) continue;
                        LocalClusterReplicationSink.this._specificLogger.log(Level.WARNING, "Error while creating transaction manager.", e);
                    }
                }
            }
        });
    }

    private void onLocalClusterFound() {
        this.createReplicationNode();
        if (this._config.isRequiresBootstrap()) {
            if (this._specificLogger.isLoggable(Level.INFO)) {
                this._specificLogger.info("local cluster found, waiting for bootstrap invocation");
            }
        } else {
            if (this._specificLogger.isLoggable(Level.INFO)) {
                this._specificLogger.info("local cluster found, initializing sink registration");
            }
            this.initSinkRegistration();
        }
    }

    @Override
    public IIncomingReplicationFacade getIncomingReplicationFacade() {
        return this._replicationNode;
    }

    private void createReplicationNode() {
        if (this._replicationNode != null) {
            throw new IllegalStateException("Cannot call createIncomingReplicationFacade twice");
        }
        SpaceTypeManager typeManager = new SpaceTypeManager(new SpaceConfigReader(this._sink.getMyLookupName()));
        LocalClusterReplicationFixFacade fixFacade = new LocalClusterReplicationFixFacade(this._localClusterProxy);
        ReplicationPacketDataConsumer dataConsumer = new ReplicationPacketDataConsumer(typeManager, (IDataConsumeFixFacade)fixFacade, null);
        ReliableAsyncAdaptiveProcessLogBuilder replicationProcessLogBuilder = new ReliableAsyncAdaptiveProcessLogBuilder((IReplicationPacketDataBatchConsumer)dataConsumer, this._config.getTransactionProcessingParameters());
        ReplicationNodeConfig replicationNodeConfig = this.createReplicationNodeConfig((IReplicationProcessLogBuilder)replicationProcessLogBuilder);
        this._routerBuilder = this.createRouterBuilder(this._sink.getMyUuid(), this._sink.getMyLookupName());
        ReplicationNodeBuilder nodeBuilder = new ReplicationNodeBuilder();
        nodeBuilder.setAsyncHandlerProvider((IAsyncHandlerProvider)new ScheduledThreadPoolAsyncHandlerProvider("ReplicationPool-" + GatewayReplicationUtils.toShortGatewayLookupName(this._sink.getMyLookupName()), 4));
        nodeBuilder.setReplicationProcessLogBuilder((IReplicationProcessLogBuilder)replicationProcessLogBuilder);
        nodeBuilder.setReplicationRouterBuilder(this._routerBuilder);
        LocalCLusterReplicationReplicaConsumeFacade consumeFacade = new LocalCLusterReplicationReplicaConsumeFacade(this._localClusterProxy);
        nodeBuilder.setReplicaDataConsumer((ISpaceReplicaDataConsumer)new SpaceReplicaDataConsumer(typeManager, (ISpaceReplicaConsumeFacade)consumeFacade));
        this._replicationNode = new ReplicationNode(replicationNodeConfig, (IReplicationNodeBuilder)nodeBuilder, this._sink.getMyLookupName(), DummyMetricRegistrator.get());
        this.registerIncomingReplicationHandlers(this._replicationNode);
        this._replicationNode.getAdmin().setActive();
        this._replicationNode.getAdmin().getRouterAdmin().enableIncomingCommunication();
    }

    private void registerIncomingReplicationHandlers(ReplicationNode replicationNode) {
        replicationNode.setInEntryHandler((IReplicationInEntryHandler)new LocalClusterReplicationInEntryHandler(this._localClusterProxy, this._transactionManagerProvider, this._config));
        replicationNode.setInTransactionHandler((IReplicationInTransactionHandler)new LocalClusterReplicationInTransactionHandler(this._localClusterProxy, this._transactionManagerProvider, this._config));
        LocalClusterReplicationEntryLeaseEventHandler entryLeaseHandler = new LocalClusterReplicationEntryLeaseEventHandler(this._localClusterProxy, this._transactionManagerProvider, this._config);
        replicationNode.setInEntryLeaseExtendedHandler((IReplicationInEntryLeaseExtendedHandler)entryLeaseHandler);
        replicationNode.setInEntryLeaseCancelledHandler((IReplicationInEntryLeaseCancelledHandler)entryLeaseHandler);
        LocalClusterReplicationMetadataEventHandler metadataHandler = new LocalClusterReplicationMetadataEventHandler(this._localClusterProxy, this._transactionManagerProvider, this._config);
        replicationNode.setInDataTypeCreatedHandler((IReplicationInDataTypeCreatedHandler)metadataHandler);
        replicationNode.setInDataTypeIndexAddedHandler((IReplicationInDataTypeIndexAddedHandler)metadataHandler);
        replicationNode.setInBatchConsumptionHandler((IReplicationInBatchConsumptionHandler)new LocalClusterReplicationInBatchConsumptionHandler(this._localClusterProxy, this._transactionManagerProvider, this._config));
    }

    private ReplicationNodeConfig createReplicationNodeConfig(IReplicationProcessLogBuilder replicationProcessLogBuilder) {
        String[] siteNames;
        ReplicationNodeConfig config = new ReplicationNodeConfig();
        for (String site : siteNames = this._config.getSiteNames()) {
            if (site.equals(this._config.getMySiteName())) continue;
            TargetGroupConfig groupConfig = new TargetGroupConfig("NOT SET", null, ReplicationStatistics.ReplicationMode.GATEWAY, new String[0]);
            groupConfig.setUnbounded(true);
            ReliableAsyncSingleOriginReplicationTargetGroupBuilder groupBuilder = new ReliableAsyncSingleOriginReplicationTargetGroupBuilder(groupConfig);
            groupBuilder.setProcessLogBuilder((IReplicationReliableAsyncProcessLogBuilder)replicationProcessLogBuilder);
            groupBuilder.setGroupNameTemplate(site + ":.*");
            config.addDynamicTargetGroupBuilder((IReplicationDynamicTargetGroupBuilder)groupBuilder, ReplicationNodeMode.ACTIVE);
        }
        config.setPluginFacade((IReplicationNodePluginFacade)this);
        return config;
    }

    private ReplicationRouterBuilder createRouterBuilder(Uuid uuid, String myLookupName) {
        int corePoolSize = 1;
        long monitorConnectedDelay = 3L;
        long monitorDisconnectedDelay = 1L;
        LocalClusterReplicationScheduledPoolConnectionMonitor connectionMonitor = new LocalClusterReplicationScheduledPoolConnectionMonitor(myLookupName, corePoolSize, monitorConnectedDelay, monitorDisconnectedDelay, TimeUnit.SECONDS, this._finderService);
        RoutingUrlConverter routingUrlConverter = new RoutingUrlConverter(this._config.getMySiteName());
        return new LocalClusterReplicationSinkRouter.Builder(myLookupName, (IConnectionMonitor<Iterable<IReplicationLookupParameters>, String>)connectionMonitor, uuid, this._finderService, this._lookupParametersTemplate, routingUrlConverter);
    }

    private void initSinkRegistration() {
        if (this._specificLogger.isLoggable(Level.FINE)) {
            this._specificLogger.fine("init registration of sink using look parameters [" + this._sink.getMyRegistrationParameters() + "]");
        }
        this._sink.initRegistration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableIncomingReplication() {
        if (!this._config.isRequiresBootstrap()) {
            throw new IllegalStateException("Cannot invoke enableIncomingReplication on a sink that does not requires bootstrap");
        }
        LocalClusterReplicationSink localClusterReplicationSink = this;
        synchronized (localClusterReplicationSink) {
            if (this._bootstrapping) {
                throw new IllegalStateException("Cannot invoke enableIncomingReplication - bootstrap is in process");
            }
            if (this._enableIncomingReplication) {
                throw new IllegalStateException("Cannot invoke enableIncomingReplication twice or after a bootstrap was executed");
            }
            if (this._localClusterProxy == null) {
                throw new IllegalStateException("Cannot invoke enableIncomingReplication before sink finishes initialization");
            }
            this._enableIncomingReplication = true;
        }
        if (this._specificLogger.isLoggable(Level.INFO)) {
            this._specificLogger.info("sink is open for incoming replication, initializing sink registration");
        }
        this.initSinkRegistration();
    }

    public synchronized void close() {
        if (this._specificLogger.isLoggable(Level.FINE)) {
            this._specificLogger.fine("closing local cluster replication gateway...");
        }
        this._closed = true;
        this._executorService.shutdownNow();
        this._sink.close();
        if (this._replicationNode != null) {
            this._replicationNode.close();
        }
        this._registrationService.close();
        this._finderService.close();
        for (DelegatedConnection connection : this._delegatedConnections) {
            try {
                connection.cleanUp();
            }
            catch (RemoteException remoteException) {}
        }
        try {
            this._transactionManagerProvider.destroy();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this._specificLogger.isLoggable(Level.INFO)) {
            this._specificLogger.fine("local cluster replication gateway closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapFromRemoteSink(BootstrapConfig bootstrapConfig) throws Exception {
        if (!this._config.isRequiresBootstrap()) {
            throw new IllegalStateException("Cannot invoke bootstrap on a sink that does not requires bootstrap");
        }
        if (this._localClusterProxy == null) {
            throw new IllegalStateException("Cannot initiate bootstrap process before the sink is fully initiated (no proxy to local cluster)");
        }
        if (this._replicationNode == null) {
            throw new IllegalStateException("Cannot initiate bootstrap process before the sink is fully initiated (replication node fully constructed)");
        }
        try {
            LocalClusterReplicationSink localClusterReplicationSink = this;
            synchronized (localClusterReplicationSink) {
                if (this._bootstrapping) {
                    throw new IllegalStateException("Cannot initiate bootstrap process - bootstrap already in process");
                }
                if (this._enableIncomingReplication) {
                    throw new IllegalStateException("Cannot invoke bootstrap twice or after enableIncomingReplication was executed");
                }
                this._bootstrapping = true;
            }
            String remoteGatewayName = bootstrapConfig.getRemoteGatewayName();
            String remoteSinkUrl = "gateway:" + remoteGatewayName;
            if (this._specificLogger.isLoggable(Level.INFO)) {
                this._specificLogger.info("bootstrapping from a remote gateway [" + remoteGatewayName + "]" + StringUtils.NEW_LINE + "\tremote sink url [" + remoteSinkUrl + "]");
            }
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("acquiring primary member names from remote sink [" + remoteSinkUrl + "]");
            }
            long bootstrapStartTime = SystemTime.timeMillis();
            QueryRemoteClusterTopologyResult queryPrimaryMembersResult = this.getClusterPrimariesLookupNamesFromRemoteSink(remoteSinkUrl);
            String[] primariesLookupNamesFromRemoteSink = queryPrimaryMembersResult.getPrimaryMemberNames();
            if (primariesLookupNamesFromRemoteSink == null || primariesLookupNamesFromRemoteSink.length == 0) {
                throw new IllegalStateException("No primary members found at remote sink local space [" + remoteSinkUrl + "]");
            }
            int concurrentConsumers = bootstrapConfig.getConsumersPerPartition();
            int fetchBatchSize = bootstrapConfig.getFetchBatchSize();
            boolean primaryBackupGroup = queryPrimaryMembersResult.hasBackups();
            boolean hasMirror = queryPrimaryMembersResult.hasMirror();
            int partition = 1;
            LinkedList<ISpaceSynchronizeReplicaState> replicaStates = new LinkedList<ISpaceSynchronizeReplicaState>();
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine("initiating synchronization with all primary members");
            }
            for (String primaryMember : primariesLookupNamesFromRemoteSink) {
                SpaceSynchronizeReplicaRequestContext context = this.createReplicaRequestContext(remoteGatewayName, remoteSinkUrl, concurrentConsumers, fetchBatchSize, primaryBackupGroup, hasMirror, partition, primaryMember);
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("starting synchronization with primary member [" + primaryMember + "] of partition [" + partition + "]" + StringUtils.NEW_LINE + "\tusing context [" + context + "]");
                }
                replicaStates.add(this._replicationNode.spaceSynchronizeReplicaRequest((ISpaceSynchronizeReplicaRequestContext)context));
                ++partition;
            }
            int completedPartitions = 0;
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("waiting for bootstrap copy completion from " + primariesLookupNamesFromRemoteSink.length + " partitions");
            }
            LinkedList<ISpaceCopyIntermediateResult> spaceCopyResults = new LinkedList<ISpaceCopyIntermediateResult>();
            Exception failureReason = null;
            long timeleft = bootstrapConfig.getTimeout();
            for (ISpaceSynchronizeReplicaState iSpaceSynchronizeReplicaState : replicaStates) {
                if (failureReason != null) {
                    iSpaceSynchronizeReplicaState.abort(3L, TimeUnit.SECONDS);
                    continue;
                }
                try {
                    if (timeleft <= 0L) {
                        throw new TimeoutException("Bootstrap process timeout [" + bootstrapConfig.getTimeout() + " milliseconds]");
                    }
                    long startTime = SystemTime.timeMillis();
                    ISpaceCopyResult copyResult = iSpaceSynchronizeReplicaState.waitForCopyResult(timeleft, TimeUnit.MILLISECONDS);
                    if (copyResult.isFailed()) {
                        if (this._specificLogger.isLoggable(Level.WARNING)) {
                            this._specificLogger.log(Level.WARNING, "bootstrap copy stage failed at partition " + (completedPartitions + 1), copyResult.getFailureReason());
                        }
                        failureReason = copyResult.getFailureReason();
                        continue;
                    }
                    long endTime = SystemTime.timeMillis();
                    timeleft -= endTime - startTime;
                    spaceCopyResults.add((ISpaceCopyIntermediateResult)copyResult);
                    ++completedPartitions;
                    if (!this._specificLogger.isLoggable(Level.FINER)) continue;
                    String remoteSpaceMember = primariesLookupNamesFromRemoteSink[completedPartitions - 1];
                    this._specificLogger.finer("completed bootstrap copy stage of " + completedPartitions + " partitions, recovered from current partition:" + StringUtils.NEW_LINE + copyResult.getStringDescription(remoteSpaceMember, this.createPrimaryMemberRoutingUrl(remoteSinkUrl, remoteSpaceMember), this._localClusterProxy.getName(), true, SystemTime.timeMillis() - bootstrapStartTime));
                }
                catch (InterruptedException e) {
                    LocalClusterReplicationSink localClusterReplicationSink3 = this;
                    synchronized (localClusterReplicationSink3) {
                        this._bootstrapping = false;
                    }
                    return;
                }
            }
            if (failureReason != null) {
                throw failureReason;
            }
            ISpaceCopyIntermediateResult mergedResult = null;
            for (ISpaceCopyIntermediateResult intermediateResult : spaceCopyResults) {
                if (mergedResult == null) {
                    mergedResult = intermediateResult;
                    continue;
                }
                mergedResult = mergedResult.merge(intermediateResult);
            }
            if (this._specificLogger.isLoggable(Level.INFO)) {
                this._specificLogger.info("completed bootstrap copy stage from " + completedPartitions + " partitions, recovered data: " + StringUtils.NEW_LINE + ((ISpaceCopyResult)mergedResult).getStringDescription(remoteGatewayName, remoteSinkUrl, this._localClusterProxy.getName(), true, SystemTime.timeMillis() - bootstrapStartTime));
            }
            long l = SystemTime.timeMillis();
            completedPartitions = 0;
            LocalClusterReplicationSink localClusterReplicationSink2 = this;
            synchronized (localClusterReplicationSink2) {
                this._enableIncomingReplication = true;
            }
            this.initSinkRegistration();
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("waiting for bootstrap synchronization completion from " + primariesLookupNamesFromRemoteSink.length + " partitions");
            }
            for (ISpaceSynchronizeReplicaState replicaState : replicaStates) {
                try {
                    if (timeleft <= 0L) {
                        throw new TimeoutException("Bootstrap process timeout [" + bootstrapConfig.getTimeout() + " milliseconds]");
                    }
                    long startTime = SystemTime.timeMillis();
                    ISpaceSynchronizeResult synchronizeResult = replicaState.waitForSynchronizeCompletion(timeleft, TimeUnit.MILLISECONDS);
                    if (synchronizeResult.isFailed()) {
                        if (this._specificLogger.isLoggable(Level.WARNING)) {
                            this._specificLogger.log(Level.WARNING, "bootstrap synchronization stage failed at partition " + (completedPartitions + 1), synchronizeResult.getFailureReason());
                        }
                        throw synchronizeResult.getFailureReason();
                    }
                    long endTime = SystemTime.timeMillis();
                    timeleft -= endTime - startTime;
                    if (!this._specificLogger.isLoggable(Level.FINER)) continue;
                    this._specificLogger.finer("completed bootstrap synchronization stage of " + ++completedPartitions + " partitions");
                }
                catch (InterruptedException e) {
                    LocalClusterReplicationSink localClusterReplicationSink3 = this;
                    synchronized (localClusterReplicationSink3) {
                        this._bootstrapping = false;
                    }
                    return;
                }
            }
            if (this._specificLogger.isLoggable(Level.INFO)) {
                this._specificLogger.info("bootstrap synchronization done, TOTAL time: " + JSpaceUtilities.formatMillis((long)(SystemTime.timeMillis() - l)));
            }
            if (this._specificLogger.isLoggable(Level.INFO)) {
                this._specificLogger.info("bootstrap completed successfully. TOTAL TIME: " + JSpaceUtilities.formatMillis((long)(SystemTime.timeMillis() - bootstrapStartTime)));
            }
        }
        finally {
            LocalClusterReplicationSink localClusterReplicationSink = this;
            synchronized (localClusterReplicationSink) {
                this._bootstrapping = false;
            }
        }
    }

    protected SpaceSynchronizeReplicaRequestContext createReplicaRequestContext(String remoteSinkGatewayName, String remoteSinkUrl, int concurrentConsumers, int fetchBatchSize, boolean primaryBackupGroup, boolean hasMirror, int partition, String primaryMember) {
        SpaceSynchronizeReplicaRequestContext context = new SpaceSynchronizeReplicaRequestContext();
        String primaryMemberRoutingUrl = this.createPrimaryMemberRoutingUrl(remoteSinkUrl, primaryMember);
        context.setOriginUrl((Object)primaryMemberRoutingUrl);
        context.setConcurrentConsumers(concurrentConsumers);
        context.setFetchBatchSize(fetchBatchSize);
        String synchronizeGroupName = ReplicationNodeWithGatewayConfigBuilder.createReplicationGroupNameWithLocalSite(partition, primaryMember, primaryBackupGroup, hasMirror, remoteSinkGatewayName);
        context.setSynchronizeGroupName(synchronizeGroupName);
        SpaceCopyReplicaParameters copyParameters = new SpaceCopyReplicaParameters();
        copyParameters.setCopyNotifyTemplates(false);
        copyParameters.setReplicaType(SpaceCopyReplicaParameters.ReplicaType.SYNCRONIZE);
        copyParameters.setTransient(false);
        copyParameters.addTemplatePacket(null);
        context.setParameters((ISpaceCopyReplicaParameters)copyParameters);
        return context;
    }

    protected String createPrimaryMemberRoutingUrl(String remoteSinkUrl, String primaryMember) {
        return remoteSinkUrl + "->" + primaryMember;
    }

    private QueryRemoteClusterTopologyResult getClusterPrimariesLookupNamesFromRemoteSink(String remoteSinkUrl) throws RemoteException {
        IReplicationMonitoredConnection sinkConnection = this._replicationNode.getReplicationRouter().getMemberConnection(remoteSinkUrl);
        QueryRemoteClusterTopologyResult queryResult = (QueryRemoteClusterTopologyResult)sinkConnection.dispatch((AbstractReplicationPacket)new QueryRemoteClusterTopologyPacket());
        if (queryResult.getRemoteException() != null) {
            throw queryResult.getRemoteException();
        }
        return queryResult;
    }

    private QueryRemoteClusterTopologyResult getClusterPrimariesLookupNamesFromMyCluster() throws RemoteException {
        if (this._specificLogger.isLoggable(Level.FINE)) {
            this._specificLogger.fine("received cluster topology query");
        }
        SpaceClusterInfo clusterInfo = this._localClusterProxy.getDirectProxy().getSpaceClusterInfo();
        LinkedList clusterMemberList = new LinkedList(clusterInfo.getMembersNames());
        String clusterName = this._localClusterProxy.getDirectProxy().getSpaceClusterInfo().getClusterName();
        if (this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer("local cluster [" + clusterName + "] consists of members " + clusterMemberList + ", acquiring primary members...");
        }
        int partitionIndex = 1;
        LinkedList<String> primaryMembers = new LinkedList<String>();
        while (true) {
            boolean lastMember;
            LinkedList<String> partitionMembers = new LinkedList<String>();
            int memberIndex = 0;
            do {
                String memberStr = memberIndex == 0 ? "" : "_" + memberIndex;
                String currentMemberName = JSpaceUtilities.createFullSpaceName((String)(clusterName + "_container" + partitionIndex + memberStr), (String)clusterName);
                boolean bl = lastMember = !clusterMemberList.remove(currentMemberName);
                if (!lastMember) {
                    partitionMembers.add(currentMemberName);
                }
                ++memberIndex;
            } while (!lastMember);
            if (partitionMembers.isEmpty()) break;
            String primaryMember = null;
            for (String partitionMember : partitionMembers) {
                boolean isPrimary = this.checkIfPrimaryOfPartition(partitionMember);
                if (!isPrimary) continue;
                primaryMember = partitionMember;
                break;
            }
            if (primaryMember == null) {
                throw new RemoteException("Could not locate primary member for partition " + partitionIndex);
            }
            primaryMembers.add(primaryMember);
            ++partitionIndex;
        }
        String[] primaries = primaryMembers.toArray(new String[primaryMembers.size()]);
        boolean hasMirrorService = clusterInfo.isMirrorServiceEnabled();
        boolean hasBackups = clusterInfo.isPrimaryElectionAvailable();
        QueryRemoteClusterTopologyResult queryRemoteClusterTopologyResult = new QueryRemoteClusterTopologyResult(primaries, hasBackups, hasMirrorService);
        if (this._specificLogger.isLoggable(Level.FINE)) {
            this._specificLogger.fine("cluster topology query response is [" + queryRemoteClusterTopologyResult + "]");
        }
        return queryRemoteClusterTopologyResult;
    }

    private boolean checkIfPrimaryOfPartition(String memberName) {
        String url = this.createSpaceUrlForMember(memberName);
        try {
            ISpaceProxy proxy;
            boolean isPrimary;
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("checking if member is primary [" + memberName + "]");
            }
            boolean bl = isPrimary = ((IInternalRemoteJSpaceAdmin)(proxy = (ISpaceProxy)SpaceFinder.find((String)url)).getAdmin()).getSpaceMode() == SpaceMode.PRIMARY;
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("member [" + memberName + "] is primary [" + isPrimary + "]");
            }
            return isPrimary;
        }
        catch (FinderException e) {
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    protected String createSpaceUrlForMember(String memberName) {
        String url = "jini://*/" + memberName.substring(0, memberName.indexOf(58)) + "/" + memberName.substring(memberName.indexOf(58) + 1);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T accept(AbstractReplicationPacket<T> packet) {
        if (packet instanceof SinkEstablishConnectionPacket) {
            SinkEstablishConnectionPacket typedPacket = (SinkEstablishConnectionPacket)packet;
            String targetSpaceMemberLookupName = typedPacket.getTargetSpaceMemberLookupName();
            String url = this.createSpaceUrlForMember(targetSpaceMemberLookupName);
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("establishing a delegated connection to space member [" + targetSpaceMemberLookupName + "] using url [" + url + "]");
            }
            try {
                IDirectSpaceProxy directProxy = (IDirectSpaceProxy)SpaceFinder.find((String)url);
                IRemoteSpace remoteJSpace = directProxy.getRemoteJSpace();
                Uuid spaceUuid = remoteJSpace.getSpaceUuid();
                IReplicationConnectionProxy connectionProxy = remoteJSpace.getReplicationRouterConnectionProxy();
                DelegatedConnection connectionWrapper = new DelegatedConnection(connectionProxy, targetSpaceMemberLookupName);
                IReplicationConnectionProxy stub = (IReplicationConnectionProxy)this._serviceExporter.export((Remote)((Object)connectionWrapper));
                LocalClusterReplicationSink localClusterReplicationSink = this;
                synchronized (localClusterReplicationSink) {
                    this.removeStaleConnection();
                    this._delegatedConnections.add(connectionWrapper);
                }
                return (T)new SinkEstablishConnectionResult(stub, spaceUuid);
            }
            catch (Exception e) {
                return (T)new SinkEstablishConnectionResult(e);
            }
        }
        if (packet instanceof QueryRemoteClusterTopologyPacket) {
            try {
                return (T)this.getClusterPrimariesLookupNamesFromMyCluster();
            }
            catch (RemoteException e) {
                return (T)new QueryRemoteClusterTopologyResult(e);
            }
        }
        throw new IllegalStateException("No plugin support for packet " + packet);
    }

    private void removeStaleConnection() {
        long current = SystemTime.timeMillis();
        long STALE_THRESHOLD = 300000L;
        Iterator<DelegatedConnection> iterator = this._delegatedConnections.iterator();
        while (iterator.hasNext()) {
            DelegatedConnection connection = iterator.next();
            if (connection.getLastTouched() < current - 300000L) {
                try {
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.finer("removing stale connection to " + connection.getTargetLookupName());
                    }
                    connection.cleanUp();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            iterator.remove();
        }
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder(this._config.dumpState());
        if (this._replicationNode != null) {
            sb.append(StringUtils.NEW_LINE);
            sb.append(this._replicationNode.dumpState());
        }
        return sb.toString();
    }

    public class DelegatedConnection
    implements IReplicationConnectionProxy {
        private final IReplicationConnectionProxy _connectionProxy;
        private final String _targetSpaceMemberLookupName;
        private volatile long _lastTouched;

        public DelegatedConnection(IReplicationConnectionProxy connectionProxy, String targetSpaceMemberLookupName) {
            this._connectionProxy = connectionProxy;
            this._targetSpaceMemberLookupName = targetSpaceMemberLookupName;
            this.touch();
        }

        public String getTargetLookupName() {
            return this._targetSpaceMemberLookupName;
        }

        private void touch() {
            this._lastTouched = SystemTime.timeMillis();
        }

        public <T> T dispatch(AbstractReplicationPacket<T> packet) throws RemoteException {
            this.touch();
            return (T)this._connectionProxy.dispatch(packet);
        }

        public <T> T dispatchAsync(AbstractReplicationPacket<T> packet) throws RemoteException {
            return this.dispatch(packet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws RemoteException {
            LocalClusterReplicationSink localClusterReplicationSink = LocalClusterReplicationSink.this;
            synchronized (localClusterReplicationSink) {
                LocalClusterReplicationSink.this._delegatedConnections.remove(this);
            }
            this.cleanUp();
        }

        protected void cleanUp() throws RemoteException {
            LocalClusterReplicationSink.this._serviceExporter.unexport((Remote)((Object)this));
            this._connectionProxy.close();
        }

        public long getLastTouched() {
            return this._lastTouched;
        }
    }
}

