/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.cluster.replication.gateway.conflict.ConflictResolver;
import com.gigaspaces.cluster.replication.gateway.conflict.DefaultConflictResolver;
import com.gigaspaces.cluster.replication.gateway.sync.CommitOnConsolidationFailureInterceptor;
import com.gigaspaces.internal.cluster.node.impl.gateway.delegator.ReplicationGatewayComponentConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.DistributedTransactionProcessingConfiguration;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.sync.SynchronizationEndpointInterceptor;
import java.util.Arrays;

public class LocalClusterReplicationSinkConfig
extends ReplicationGatewayComponentConfig {
    private static final long DIST_TX_WAIT_TIMEOUT = 60000L;
    private static final long DIST_TX_WAIT_FOR_OPERATIONS = -1L;
    private String _localClusterSpaceUrl;
    private String[] _siteNames;
    private boolean _requiresBootstrap;
    private ConflictResolver _conflictResolver = new DefaultConflictResolver();
    private int _maximumRetriesOnTransactionLock = 5;
    private int _transactionLockRetryInterval = 100;
    private long _transactionTimeout = 60000L;
    private CredentialsProvider _credentialsProvider;
    private SynchronizationEndpointInterceptor _syncEndPointInterceptor = CommitOnConsolidationFailureInterceptor.INSTANCE;
    private final DistributedTransactionProcessingConfiguration _transactionProcessingConfiguration = new DistributedTransactionProcessingConfiguration(60000L, -1L);

    public LocalClusterReplicationSinkConfig(String mySiteName) {
        super(mySiteName);
    }

    public void setLocalClusterSpaceUrl(String localClusterSpaceUrl) {
        this._localClusterSpaceUrl = localClusterSpaceUrl;
    }

    public String getLocalClusterSpaceUrl() {
        return this._localClusterSpaceUrl;
    }

    public void setSiteNames(String[] siteNames) {
        this._siteNames = siteNames;
    }

    public String[] getSiteNames() {
        return this._siteNames;
    }

    public ConflictResolver getConflictResolver() {
        return this._conflictResolver;
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        this._conflictResolver = conflictResolver;
    }

    public int getMaximumRetriesOnTransactionLock() {
        return this._maximumRetriesOnTransactionLock;
    }

    public void setMaximumRetriesOnTransactionLock(int maximumRetriesOnTransactionLock) {
        this._maximumRetriesOnTransactionLock = maximumRetriesOnTransactionLock;
    }

    public void setRequiresBootstrap(boolean requiresBootstrap) {
        this._requiresBootstrap = requiresBootstrap;
    }

    public boolean isRequiresBootstrap() {
        return this._requiresBootstrap;
    }

    public int getTransactionLockRetryInterval() {
        return this._transactionLockRetryInterval;
    }

    public void setTransactionLockRetryInterval(int transactionLockRetryInterval) {
        this._transactionLockRetryInterval = transactionLockRetryInterval;
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this._transactionTimeout = transactionTimeout;
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public DistributedTransactionProcessingConfiguration getTransactionProcessingParameters() {
        return this._transactionProcessingConfiguration;
    }

    public void setSyncEndpointInterceptor(SynchronizationEndpointInterceptor interceptor) {
        this._syncEndPointInterceptor = interceptor;
    }

    public SynchronizationEndpointInterceptor getSyncEndpointInterceptor() {
        return this._syncEndPointInterceptor;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this._credentialsProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this._credentialsProvider = credentialsProvider;
    }

    public void clearCredentialsProvider() {
        this._credentialsProvider = null;
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder();
        sb.append("--------------------" + StringUtils.NEW_LINE);
        sb.append(" Sink Configuration " + StringUtils.NEW_LINE);
        sb.append("--------------------" + StringUtils.NEW_LINE);
        sb.append("localSiteName                   = " + this._mySiteName + StringUtils.NEW_LINE);
        sb.append("localClusterSpaceUrl            = " + this._localClusterSpaceUrl + StringUtils.NEW_LINE);
        sb.append("findTimeout                     = " + this.getFindTimeout() + StringUtils.NEW_LINE);
        sb.append("startLookupService              = " + this.isStartLookupService() + StringUtils.NEW_LINE);
        sb.append("gatewaySourcesSitesNames        = " + (this._siteNames != null ? Arrays.toString(this._siteNames) : "null") + StringUtils.NEW_LINE);
        sb.append("requiresBootstrap               = " + this._requiresBootstrap + StringUtils.NEW_LINE);
        sb.append("maximumRetriesOnTransactionLock = " + this._maximumRetriesOnTransactionLock + StringUtils.NEW_LINE);
        sb.append("transactionLockRetryInterval    = " + this._transactionLockRetryInterval + StringUtils.NEW_LINE);
        sb.append("transactionTimeout              = " + this._transactionTimeout + StringUtils.NEW_LINE);
        sb.append("conflictResolverInstance        = " + (this._conflictResolver != null ? this._conflictResolver.getClass().getName() : "null") + StringUtils.NEW_LINE);
        sb.append("syncEndPointInterceptor         = " + (this._syncEndPointInterceptor != null ? this._syncEndPointInterceptor.getClass().getName() : "null") + StringUtils.NEW_LINE);
        sb.append(this._transactionProcessingConfiguration + StringUtils.NEW_LINE);
        sb.append(this.getGatewayLookupParameters() + StringUtils.NEW_LINE);
        return sb.toString();
    }
}

