/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.internal.cluster.node.impl.IServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.LRMIServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupFinderService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupResult;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.IRoutingUrlConverter;
import com.gigaspaces.internal.cluster.node.impl.gateway.router.LusReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.SinkEstablishConnectionPacket;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.SinkEstablishConnectionResult;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractConnectionProxyBasedReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IAsyncContextProvider;
import com.gigaspaces.internal.cluster.node.impl.router.IIncomingReplicationHandler;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.LRMIAsyncContextProvider;
import com.gigaspaces.internal.cluster.node.impl.router.MemberProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.DisconnectionProxy;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.utils.StringUtils;
import java.rmi.RemoteException;
import java.util.logging.Level;
import net.jini.id.Uuid;

public class LocalClusterReplicationSinkRouter
extends LusReplicationRouter {
    public LocalClusterReplicationSinkRouter(String myLookupName, Uuid uuid, IConnectionMonitor<Iterable<IReplicationLookupParameters>, String> connectionMonitor, IIncomingReplicationHandler incomingReplicationHandler, IReplicationLookupFinderService replicationLookupService, IReplicationLookupParameters lookupParametersTemplate, IRoutingUrlConverter routingNameConverter) {
        super(myLookupName, uuid, connectionMonitor, (IServiceExporter)new LRMIServiceExporter(), incomingReplicationHandler, (IAsyncContextProvider)new LRMIAsyncContextProvider(), replicationLookupService, lookupParametersTemplate, routingNameConverter, true);
    }

    @Override
    public IReplicationMonitoredConnection getUrlConnection(Object customUrl) {
        String url = (String)customUrl;
        return this.getMemberConnection(url);
    }

    @Override
    protected MemberProxyBasedReplicationMonitoredConnection<Iterable<IReplicationLookupParameters>, String> createConnectionAndConnect(String lookupName, Iterable<IReplicationLookupParameters> lookupParametersList) {
        ConnectionState connectionState = ConnectionState.DISCONNECTED;
        Uuid proxyId = null;
        DisconnectionProxy connectionProxy = new DisconnectionProxy();
        String endpointLookupName = null;
        RemoteException lastDisconnectionReason = null;
        for (IReplicationLookupParameters lookupParameters : lookupParametersList) {
            IReplicationLookupParameters tempLookupParameters = lookupParameters;
            boolean hasSinkRoutingDestination = LocalClusterReplicationSinkRouter.hasSinkRoutingDestination(tempLookupParameters.getLookupName());
            if (hasSinkRoutingDestination) {
                tempLookupParameters = tempLookupParameters.clone();
                tempLookupParameters.setLookupName(LocalClusterReplicationSinkRouter.extractSinkDestinationUrl(tempLookupParameters.getLookupName()));
            }
            try {
                IReplicationLookupResult lookupResult;
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("finding proxy to member using lookup parameters: " + StringUtils.NEW_LINE + tempLookupParameters);
                }
                if ((lookupResult = this._replicationLookupService.findConnectionProxy(tempLookupParameters)) == null) continue;
                connectionProxy = lookupResult.getServiceProxy();
                if (connectionProxy == null) {
                    throw new IllegalStateException("Got null connection proxy");
                }
                this.pingStub((IReplicationConnectionProxy)connectionProxy);
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("found proxy to member " + tempLookupParameters.getLookupName() + ", pinging member and establishing connection");
                }
                if (hasSinkRoutingDestination) {
                    lookupResult = this.establishConnectionViaSink((IReplicationConnectionProxy)connectionProxy, lookupName);
                    connectionProxy = lookupResult.getServiceProxy();
                    endpointLookupName = LocalClusterReplicationSinkRouter.extractSpaceMemberLookupName(lookupParameters.getLookupName());
                } else {
                    endpointLookupName = lookupParameters.getLookupName();
                }
                connectionState = ConnectionState.CONNECTED;
                proxyId = lookupResult.getServiceId();
                break;
            }
            catch (RemoteException e) {
                if (this._specificLogger.isLoggable(Level.FINER)) {
                    this._specificLogger.finer("could not find proxy to member " + tempLookupParameters.getLookupName() + " [" + e.getMessage() + "]");
                }
                lastDisconnectionReason = e;
            }
        }
        MemberProxyBasedReplicationMonitoredConnection connection = new MemberProxyBasedReplicationMonitoredConnection((AbstractConnectionProxyBasedReplicationRouter)this, lookupName, (IReplicationConnectionProxy)connectionProxy, lookupParametersList, endpointLookupName, this.getConnectionMonitor(), (Object)lookupName, connectionState, lastDisconnectionReason, proxyId, this.getAsyncContextProvider(), true);
        return connection;
    }

    protected IReplicationLookupResult establishConnectionViaSink(IReplicationConnectionProxy connectionProxy, String lookupName) throws RemoteException {
        SinkEstablishConnectionPacket sinkEstablishConnectionPacket = new SinkEstablishConnectionPacket(LocalClusterReplicationSinkRouter.extractSpaceMemberLookupName(lookupName));
        sinkEstablishConnectionPacket.setSourceEndpointDetails(this.getMyEndpointDetails());
        final SinkEstablishConnectionResult sinkEstablishConnectionResult = (SinkEstablishConnectionResult)connectionProxy.dispatch((AbstractReplicationPacket)sinkEstablishConnectionPacket);
        Exception exception = sinkEstablishConnectionResult.getException();
        if (exception != null) {
            throw new RemoteException(exception.getMessage(), exception);
        }
        final IReplicationConnectionProxy newConnectionProxy = sinkEstablishConnectionResult.getConnectionProxy();
        this.pingStub(newConnectionProxy);
        return new IReplicationLookupResult(){

            @Override
            public IReplicationConnectionProxy getServiceProxy() {
                return newConnectionProxy;
            }

            @Override
            public Uuid getServiceId() throws RemoteException {
                return sinkEstablishConnectionResult.getServiceId();
            }
        };
    }

    public static String extractSpaceMemberLookupName(String lookupName) {
        String[] split = lookupName.split("->");
        if (split.length != 2) {
            throw new IllegalArgumentException("Expected format 'sink url'->'space member lookup name'");
        }
        return split[1];
    }

    public static boolean hasSinkRoutingDestination(String lookupName) {
        return lookupName.contains("->");
    }

    public static String extractSinkDestinationUrl(String lookupName) {
        String[] split = lookupName.split("->");
        if (split.length != 2) {
            throw new IllegalArgumentException("Expected format 'sink url'->'space member lookup name'");
        }
        return split[0];
    }

    public static class Builder
    extends ReplicationRouterBuilder<LocalClusterReplicationSinkRouter> {
        private final String _myLookupName;
        private final IConnectionMonitor<Iterable<IReplicationLookupParameters>, String> _connectionMonitor;
        private final Uuid _uuid;
        private final IReplicationLookupFinderService _LookupService;
        private final IReplicationLookupParameters _lookupParametersTemplate;
        private final IRoutingUrlConverter _routingUrlConverter;

        public Builder(String myLookupName, IConnectionMonitor<Iterable<IReplicationLookupParameters>, String> connectionMonitor, Uuid uuid, IReplicationLookupFinderService lookupService, IReplicationLookupParameters lookupParametersTemplate, IRoutingUrlConverter routingUrlConverter) {
            this._myLookupName = myLookupName;
            this._connectionMonitor = connectionMonitor;
            this._uuid = uuid;
            this._LookupService = lookupService;
            this._lookupParametersTemplate = lookupParametersTemplate;
            this._routingUrlConverter = routingUrlConverter;
        }

        public LocalClusterReplicationSinkRouter create(IIncomingReplicationHandler handler) {
            return new LocalClusterReplicationSinkRouter(this._myLookupName, this._uuid, this._connectionMonitor, handler, this._LookupService, this._lookupParametersTemplate, this._routingUrlConverter);
        }

        public String toString() {
            return "LocalClusterReplicationSinkRouter [myLookupName=" + this._myLookupName + ", connectionMonitor=" + this._connectionMonitor + ", _uuid=" + this._uuid + ", LookupService=" + this._LookupService + ", defaultLookupParameters=" + this._lookupParametersTemplate + "]";
        }
    }
}

