/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.internal.cluster.node.impl.IServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.LRMIServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.gateway.delegator.ReplicationGatewayComponentConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupFinderService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupRegistrationService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationLookupFinderService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationLookupRegistrationService;

public class ReplicationGatewayComponent {
    protected final IReplicationLookupRegistrationService _registrationService;
    protected final IReplicationLookupFinderService _finderService;
    protected final IServiceExporter _serviceExporter;
    protected final ReplicationLookupParameters _lookupParametersTemplate;

    public ReplicationGatewayComponent(ReplicationGatewayComponentConfig config) {
        ReplicationLookupParameters gatewayLookupParameters = config.getGatewayLookupParameters();
        ReplicationLookupParameters environmentLookupParameters = ReplicationLookupParameters.getEnvironmentLookupParameters();
        this._lookupParametersTemplate = gatewayLookupParameters != null ? gatewayLookupParameters.merge(environmentLookupParameters) : environmentLookupParameters;
        long lookupTimeout = Long.getLong("com.gs.gateway.lookupTimeout", config.getFindTimeout());
        this._finderService = new ReplicationLookupFinderService(lookupTimeout);
        this._registrationService = this.createRegistrationService(config, gatewayLookupParameters, environmentLookupParameters);
        this._serviceExporter = new LRMIServiceExporter();
    }

    protected IReplicationLookupRegistrationService createRegistrationService(ReplicationGatewayComponentConfig config, ReplicationLookupParameters gatewayLookupParameters, ReplicationLookupParameters environmentLookupParameters) {
        if (config.isStartLookupService()) {
            String[] lookupGroups;
            String[] stringArray = lookupGroups = gatewayLookupParameters != null ? gatewayLookupParameters.getLookupGroups() : environmentLookupParameters.getLookupGroups();
            if (lookupGroups.length != 1) {
                throw new UnsupportedOperationException("Exactly one lookup group is supported");
            }
            return ReplicationLookupRegistrationService.createAndGetRegistrationService(lookupGroups[0]);
        }
        return ReplicationLookupRegistrationService.getRegistrationService();
    }
}

