/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.gateway.sink;

import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.IServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayReplicationUtils;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.IReplicationLookupRegistrationService;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.LusExportedReplicationComponent;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.IIncomingReplicationFacadeProvider;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicationSink
extends LusExportedReplicationComponent {
    public static final String LOOKUP_NAME_PREFIX = "replication:sink:";
    private final Logger _specificLogger;
    private final IIncomingReplicationFacadeProvider _incomingReplicationFacadeProvider;
    private IIncomingReplicationFacade _incomingReplicationFacade;

    public ReplicationSink(String myLookupName, IReplicationLookupRegistrationService lookupService, IReplicationLookupParameters registrationParameters, IServiceExporter serviceExporter, IIncomingReplicationFacadeProvider nodeProvider) {
        super(LOOKUP_NAME_PREFIX + myLookupName, myLookupName, serviceExporter, lookupService, registrationParameters);
        this._incomingReplicationFacadeProvider = nodeProvider;
        this._specificLogger = Logger.getLogger("com.gigaspaces.replication.gateway.sink." + GatewayReplicationUtils.toShortGatewayLookupName(this.getMyLookupName()));
    }

    @Override
    protected void afterRegistrationInitiated() {
        if (this._specificLogger.isLoggable(Level.INFO)) {
            this._specificLogger.info("replication sink initiated");
        }
        this._incomingReplicationFacade = this._incomingReplicationFacadeProvider.getIncomingReplicationFacade();
    }

    @Override
    public void onRegistered() {
        if (this._specificLogger.isLoggable(Level.INFO)) {
            this._specificLogger.info("registered at gateway lookup service");
        }
    }

    @Override
    protected <T> T onDispatch(AbstractReplicationPacket<T> packet) throws RemoteException {
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("received incoming packet [" + packet + "]");
        }
        return (T)packet.accept(this.getIncomingReplicationFacade());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIncomingReplicationFacade getIncomingReplicationFacade() {
        if (this._incomingReplicationFacade != null) {
            return this._incomingReplicationFacade;
        }
        ReplicationSink replicationSink = this;
        synchronized (replicationSink) {
            return this._incomingReplicationFacade;
        }
    }

    @Override
    protected void onClose() {
        if (this._specificLogger.isLoggable(Level.INFO)) {
            this._specificLogger.info("replication sink closed");
        }
    }
}

