/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.executors;

import com.gigaspaces.internal.cluster.node.IReplicationNodeAdmin;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogMemberLimitationConfig;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayPolicy;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewaysPolicy;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.AsyncChannelConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.GatewayChannelDataFilter;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.executors.SpaceActionExecutor;
import com.gigaspaces.internal.space.requests.AddReplicationGatewayTargetRequestInfo;
import com.gigaspaces.internal.space.requests.SpaceRequestInfo;
import com.gigaspaces.internal.space.responses.AddReplicationGatewayTargetResponseInfo;
import com.gigaspaces.internal.space.responses.SpaceResponseInfo;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpaceAddReplicationGatewayTargetExecutor
extends SpaceActionExecutor {
    public SpaceResponseInfo execute(SpaceImpl space, SpaceRequestInfo spaceRequestInfo) {
        GatewaysPolicy gatewaysPolicy;
        AddReplicationGatewayTargetRequestInfo requestInfo = (AddReplicationGatewayTargetRequestInfo)spaceRequestInfo;
        AddReplicationGatewayTargetResponseInfo responseInfo = new AddReplicationGatewayTargetResponseInfo();
        SpaceContext spaceContext = spaceRequestInfo.getSpaceContext();
        space.assertAuthorizedForPrivilege((Privilege)GridAuthority.GridPrivilege.MANAGE_PU, spaceContext);
        GatewayConfig gatewayConfig = GatewayConfig.fromClusterInfo(space.getClusterInfo());
        GatewaysPolicy gatewaysPolicy2 = gatewaysPolicy = gatewayConfig != null ? gatewayConfig.getGatewaysPolicy() : null;
        if (gatewaysPolicy == null) {
            responseInfo.exception = new UnsupportedOperationException("Cannot add gateway target to a space with no gateway");
            return responseInfo;
        }
        IReplicationNodeAdmin replicationNodeAdmin = space.getEngine().getReplicationNode().getAdmin();
        String groupName = space.getEngine().generateGroupName();
        DynamicSourceGroupConfigHolder groupConfig = replicationNodeAdmin.getSourceGroupConfigHolder(groupName);
        GatewayPolicy gatewayPolicy = requestInfo.gatewayPolicy;
        if (gatewayPolicy.getGatewayName().equals(gatewaysPolicy.getLocalSiteName())) {
            responseInfo.exception = new IllegalArgumentException("Cannot add gateway target to space using the local gateway name [" + gatewayPolicy.getGatewayName() + "]");
            return responseInfo;
        }
        BacklogMemberLimitationConfig memberBacklogLimitations = new BacklogMemberLimitationConfig();
        RedoLogCapacityExceededPolicy onRedoLogCapacityExceeded = gatewayPolicy.getOnRedoLogCapacityExceeded();
        if (gatewayPolicy.getMaxRedoLogCapacity() == -1L) {
            memberBacklogLimitations.setUnlimited();
        } else {
            memberBacklogLimitations.setLimit(gatewayPolicy.getMaxRedoLogCapacity(), onRedoLogCapacityExceeded == RedoLogCapacityExceededPolicy.BLOCK_OPERATIONS ? BacklogConfig.LimitReachedPolicy.DROP_OLDEST : BacklogConfig.LimitReachedPolicy.BLOCK_NEW);
        }
        AsyncChannelConfig config = new AsyncChannelConfig(gatewayPolicy.getBulkSize(), gatewayPolicy.getIdleTimeThreshold(), gatewayPolicy.getPendingOperationThreshold(), ReplicationStatistics.ReplicationMode.GATEWAY);
        Logger logger = Logger.getLogger("com.gigaspaces.replication.group." + groupName);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Adding new gateway target [" + gatewayPolicy.getGatewayName() + "]");
        }
        GatewayChannelDataFilter filter = new GatewayChannelDataFilter(gatewayPolicy.isReplicateChangeAsUpdate());
        groupConfig.addMember("gateway:" + gatewayPolicy.getGatewayName(), (IReplicationChannelDataFilter)filter, memberBacklogLimitations, (Object)config, null);
        return responseInfo;
    }
}

