/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.server.space.executors;

import com.gigaspaces.internal.cluster.node.IReplicationNodeAdmin;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayConfig;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.executors.SpaceActionExecutor;
import com.gigaspaces.internal.space.requests.RemoveReplicationGatewayTargetRequestInfo;
import com.gigaspaces.internal.space.requests.SpaceRequestInfo;
import com.gigaspaces.internal.space.responses.RemoveReplicationGatewayTargetResponseInfo;
import com.gigaspaces.internal.space.responses.SpaceResponseInfo;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.j_spaces.core.SpaceContext;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpaceRemoveReplicationGatewayTargetExecutor
extends SpaceActionExecutor {
    public SpaceResponseInfo execute(SpaceImpl space, SpaceRequestInfo spaceRequestInfo) {
        RemoveReplicationGatewayTargetRequestInfo requestInfo = (RemoveReplicationGatewayTargetRequestInfo)spaceRequestInfo;
        RemoveReplicationGatewayTargetResponseInfo responseInfo = new RemoveReplicationGatewayTargetResponseInfo();
        SpaceContext spaceContext = spaceRequestInfo.getSpaceContext();
        space.assertAuthorizedForPrivilege((Privilege)GridAuthority.GridPrivilege.MANAGE_PU, spaceContext);
        if (!GatewayConfig.hasGatewayConfig(space.getClusterInfo())) {
            responseInfo.exception = new UnsupportedOperationException("Cannot add gateway target to a space with no gateway");
            return responseInfo;
        }
        IReplicationNodeAdmin replicationNodeAdmin = space.getEngine().getReplicationNode().getAdmin();
        String groupName = space.getEngine().generateGroupName();
        DynamicSourceGroupConfigHolder groupConfig = replicationNodeAdmin.getSourceGroupConfigHolder(groupName);
        Logger logger = Logger.getLogger("com.gigaspaces.replication.group." + groupName);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Removing gateway target [" + requestInfo.gatewayTargetName + "]");
        }
        groupConfig.removeMember("gateway:" + requestInfo.gatewayTargetName);
        return responseInfo;
    }
}

