/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.openspaces.jpa.openjpa.Broker;

public class StateManager
extends StateManagerImpl {
    private static final long serialVersionUID = 1L;
    private StateManager _ownerStateManager;
    private FieldMetaData _ownerMetaData;
    private boolean _cleared = false;

    public StateManager(Object id, ClassMetaData meta, BrokerImpl broker) {
        super(id, meta, broker);
    }

    public void setOwnerInformation(StateManager ownerStateManager, FieldMetaData ownerMetaData) {
        this._ownerStateManager = ownerStateManager;
        this._ownerMetaData = ownerMetaData;
    }

    public StateManager getOwnerStateManager() {
        return this._ownerStateManager;
    }

    public FieldMetaData getOwnerMetaData() {
        return this._ownerMetaData;
    }

    void cascadePersist(OpCallbacks call) {
        FieldMetaData[] fmds = this.getMetaData().getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (!this.getLoaded().get(i) || fmds[i].getCascadePersist() != 1 && fmds[i].getKey().getCascadePersist() != 1 && fmds[i].getElement().getCascadePersist() != 1) continue;
            this.cascadePersist(i, call, this.fetchField(i, false));
        }
    }

    private void cascadePersist(int field, OpCallbacks call, Object value) {
        if (value == null) {
            return;
        }
        FieldMetaData fmd = this.getMetaData().getField(field);
        Broker broker = (Broker)this.getBroker();
        switch (fmd.getDeclaredTypeCode()) {
            case 15: 
            case 27: {
                if (!broker.isDetachedNew() && broker.isDetached(value)) {
                    return;
                }
                StateManager stateManager = (StateManager)broker.persist(value, null, true, call);
                if (fmd.getAssociationType() != 1) break;
                stateManager.setOwnerInformation(this, fmd);
                break;
            }
            case 11: {
                broker.persistCollection(Arrays.asList((Object[])value), true, call, this, fmd);
                break;
            }
            case 12: {
                broker.persistCollection((Collection)value, true, call, this, fmd);
                break;
            }
            case 13: {
                if (fmd.getKey().getCascadePersist() == 1) {
                    broker.persistCollection(((Map)value).keySet(), true, call, this, fmd);
                }
                if (fmd.getElement().getCascadePersist() != 1) break;
                broker.persistCollection(((Map)value).values(), true, call, this, fmd);
            }
        }
    }

    void clearFields() {
        super.clearFields();
        this._cleared = true;
    }

    public boolean isCleared() {
        return this._cleared;
    }

    public void resetClearedState() {
        this._cleared = false;
    }
}

