/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.j_spaces.core.IJSpace;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.openspaces.core.util.SpaceUtils;

public class OpenSpacesPersistenceProvider
implements PersistenceProvider {
    private final PersistenceProvider _persistenceProvider = new PersistenceProviderImpl();
    private IJSpace _space;

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, IJSpace space, Map properties) {
        this.setSpace(space);
        return this.createEntityManagerFactory(persistenceUnitName, properties);
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, IJSpace space) {
        return this.createEntityManagerFactory(persistenceUnitName, space, null);
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        OpenJPAEntityManagerFactorySPI factory = (OpenJPAEntityManagerFactorySPI)this._persistenceProvider.createEntityManagerFactory(persistenceUnitName, properties);
        factory.getConfiguration().setConnectionFactory((Object)this._space);
        return factory;
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo pui, Map properties) {
        OpenJPAEntityManagerFactorySPI factory = (OpenJPAEntityManagerFactorySPI)this._persistenceProvider.createContainerEntityManagerFactory(pui, properties);
        factory.getConfiguration().setConnectionFactory((Object)this._space);
        return factory;
    }

    public void setSpace(IJSpace space) {
        ISpaceProxy proxy = (ISpaceProxy)space;
        this._space = proxy.isClustered() && !SpaceUtils.isRemoteProtocol((IJSpace)space) ? SpaceUtils.getClusterMemberSpace((IJSpace)space) : space;
    }

    public ProviderUtil getProviderUtil() {
        return this._persistenceProvider.getProviderUtil();
    }
}

