/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa;

import com.gigaspaces.annotation.pojo.SpaceId;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.j_spaces.core.IJSpace;
import com.j_spaces.jdbc.driver.GConnection;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.server.TransactionManager;
import org.apache.openjpa.abstractstore.AbstractStoreManager;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.QueryLanguages;
import org.apache.openjpa.kernel.StateManager;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.openspaces.jpa.openjpa.SpaceConfiguration;
import org.openspaces.jpa.openjpa.StoreManagerQuery;
import org.openspaces.jpa.openjpa.StoreManagerSQLQuery;

public class StoreManager
extends AbstractStoreManager {
    private Transaction _transaction = null;
    private static final Map<Class<?>, Integer> _classesRelationStatus = new HashMap();
    private static final HashSet<Class<?>> _processedClasses = new HashSet();
    private GConnection _connection;
    private RelationsManager _relationsManager = new RelationsManager();

    protected void open() {
        this.getConfiguration().initialize();
    }

    protected Collection<String> getUnsupportedOptions() {
        Collection unsupportedOptions = super.getUnsupportedOptions();
        unsupportedOptions.remove("openjpa.option.DatastoreIdentity");
        unsupportedOptions.remove("openjpa.option.Optimistic");
        unsupportedOptions.remove("openjpa.option.IncrementalFlush");
        return unsupportedOptions;
    }

    public boolean syncVersion(OpenJPAStateManager sm, Object edata) {
        try {
            if (!this.getConfiguration().getOptimistic() || sm.getMetaData().getVersionField() == null) {
                return false;
            }
            IEntryPacket result = this.readObjectFromSpace(sm);
            if (result == null) {
                return false;
            }
            Integer spaceVersion = result.getVersion();
            if (spaceVersion == null) {
                throw new IllegalStateException("Entity of type: " + result.getTypeName() + " with Id: " + result.getID() + " expected to have a value in its version property.");
            }
            return sm.getVersion().equals(spaceVersion);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void begin() {
        try {
            if (this._transaction != null) {
                if (this.getConfiguration().getOptimistic()) {
                    return;
                }
                throw new TransactionException("Attempted to start a new transaction when there's already an active transaction.");
            }
            long timeout = this.getConfiguration().getLockTimeout() == 0 ? Long.MAX_VALUE : (long)this.getConfiguration().getLockTimeout();
            this._transaction = TransactionFactory.create((TransactionManager)this.getConfiguration().getTransactionManager(), (long)timeout).transaction;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void commit() {
        try {
            long timeout = this.getConfiguration().getLockTimeout() == 0 ? Long.MAX_VALUE : (long)this.getConfiguration().getLockTimeout();
            this._transaction.commit(timeout);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this._transaction = null;
        }
    }

    public void rollback() {
        try {
            this._transaction.abort(Long.MAX_VALUE);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this._transaction = null;
        }
    }

    public void beginOptimistic() {
    }

    public void rollbackOptimistic() {
        if (this._transaction != null) {
            this.rollback();
        }
    }

    public StoreQuery newQuery(String language) {
        ExpressionParser ep = QueryLanguages.parserForLanguage((String)language);
        if (ep != null) {
            return new StoreManagerQuery(ep, this);
        }
        if ("openjpa.SQL".equals(language)) {
            return new StoreManagerSQLQuery(this);
        }
        return null;
    }

    protected OpenJPAConfiguration newConfiguration() {
        return new SpaceConfiguration();
    }

    public SpaceConfiguration getConfiguration() {
        return (SpaceConfiguration)this.getContext().getConfiguration();
    }

    public boolean exists(OpenJPAStateManager sm, Object edata) {
        ClassMetaData cm = sm.getMetaData();
        Object[] ids = ApplicationIds.toPKValues((Object)sm.getObjectId(), (ClassMetaData)cm);
        ISpaceProxy proxy = (ISpaceProxy)this.getConfiguration().getSpace();
        try {
            Object result = proxy.readById(cm.getDescribedType().getName(), ids[0], null, this._transaction, 0L, 32, false, QueryResultTypeInternal.EXTERNAL_ENTRY, null);
            return result != null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean isCached(List<Object> oids, BitSet edata) {
        return false;
    }

    public Collection loadAll(Collection sms, PCState state, int load, FetchConfiguration fetch, Object edata) {
        ArrayList<Object> failedIds = new ArrayList<Object>();
        for (OpenJPAStateManager sm : sms) {
            LockManager lm;
            BitSet fields;
            if (this.load(sm, fields = new BitSet(sm.getMetaData().getFields().length), fetch, (lm = sm.getContext().getLockManager()).getLockLevel(sm), edata)) continue;
            failedIds.add(sm.getId());
        }
        return failedIds;
    }

    public boolean initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetchConfiguration, Object edata) {
        ClassMetaData cm = sm.getMetaData();
        try {
            IEntryPacket result;
            IEntryPacket iEntryPacket = result = edata == null ? this.readObjectFromSpace(sm) : (IEntryPacket)edata;
            if (result == null) {
                return false;
            }
            sm.initialize(cm.getDescribedType(), state);
            this.loadFields(sm, result, cm.getFields());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return true;
    }

    private void loadFields(OpenJPAStateManager sm, IEntryPacket entry, FieldMetaData[] fms) {
        int spacePropertyIndex = -1;
        for (int i = 0; i < fms.length; ++i) {
            if (fms[i].isVersion()) continue;
            ++spacePropertyIndex;
            if (fms[i].isPrimaryKey() || sm.getLoaded().get(fms[i].getIndex())) continue;
            Integer associationType = _classesRelationStatus.get(fms[i].getElement().getDeclaredType());
            if (associationType != null) {
                fms[i].setAssociationType(associationType.intValue());
            }
            if (fms[i].getAssociationType() == 1) {
                sm.store(i, entry.getFieldValue(spacePropertyIndex));
                sm.getLoaded().set(fms[i].getIndex(), false);
                continue;
            }
            if (fms[i].getAssociationType() == 2) {
                sm.store(i, entry.getFieldValue(spacePropertyIndex));
                sm.getLoaded().set(fms[i].getIndex(), false);
                continue;
            }
            if (fms[i].isEmbeddedPC()) {
                this.loadEmbeddedObject(fms[i], sm, entry.getFieldValue(spacePropertyIndex));
                continue;
            }
            sm.store(i, entry.getFieldValue(spacePropertyIndex));
        }
        sm.setVersion((Object)entry.getVersion());
        ((StateManager)sm).resetClearedState();
    }

    private void loadOneToOneObject(FieldMetaData fmd, OpenJPAStateManager sm, Object fieldValue) {
        if (fieldValue == null) {
            sm.storeObject(fmd.getIndex(), null);
        } else {
            ISpaceProxy proxy = (ISpaceProxy)this.getConfiguration().getSpace();
            IEntryPacket entry = proxy.getDirectProxy().getTypeManager().getEntryPacketFromObject(fieldValue, ObjectType.POJO);
            ClassMetaData cmd = fmd.getDeclaredTypeMetaData();
            Object oid = ApplicationIds.fromPKValues((Object[])new Object[]{entry.getID()}, (ClassMetaData)cmd);
            BitSet exclude = new BitSet(cmd.getFields().length);
            Object managedObject = this.getContext().find(oid, null, exclude, (Object)entry, 0);
            this._relationsManager.setOwnerStateManagerForPersistentInstance(managedObject, sm, fmd);
            sm.storeObject(fmd.getIndex(), managedObject);
        }
    }

    private void loadEmbeddedObject(FieldMetaData fmd, OpenJPAStateManager sm, Object fieldValue) {
        if (fieldValue == null) {
            sm.storeObject(fmd.getIndex(), null);
        } else if (fieldValue != null) {
            OpenJPAStateManager em = this.ctx.embed(null, null, sm, (ValueMetaData)fmd);
            ((StateManager)em).setOwnerInformation((StateManager)sm, fmd);
            sm.storeObject(fmd.getIndex(), em.getManagedInstance());
            ISpaceProxy proxy = (ISpaceProxy)this.getConfiguration().getSpace();
            IEntryPacket entry = proxy.getDirectProxy().getTypeManager().getEntryPacketFromObject(fieldValue, ObjectType.POJO);
            this.loadFields(em, entry, fmd.getDeclaredTypeMetaData().getFields());
        }
    }

    private void loadOneToManyObjects(FieldMetaData fmd, OpenJPAStateManager sm, Object fieldValue) {
        Object collection = sm.newProxy(fmd.getIndex());
        if (fieldValue != null) {
            ISpaceProxy proxy = (ISpaceProxy)this.getConfiguration().getSpace();
            ClassMetaData cmd = fmd.getElement().getDeclaredTypeMetaData();
            BitSet exclude = new BitSet(cmd.getFields().length);
            for (Object item : (Collection)fieldValue) {
                IEntryPacket entry = proxy.getDirectProxy().getTypeManager().getEntryPacketFromObject(item, ObjectType.POJO);
                Object oid = ApplicationIds.fromPKValues((Object[])new Object[]{entry.getID()}, (ClassMetaData)cmd);
                Object managedObject = this.getContext().find(oid, null, exclude, (Object)entry, 0);
                this._relationsManager.setOwnerStateManagerForPersistentInstance(managedObject, sm, fmd);
                ((Collection)collection).add(managedObject);
            }
        }
        sm.storeObject(fmd.getIndex(), collection);
    }

    private IEntryPacket readObjectFromSpace(OpenJPAStateManager sm) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        ISpaceProxy proxy = (ISpaceProxy)this.getConfiguration().getSpace();
        ITypeDesc typeDescriptor = proxy.getDirectProxy().getTypeManager().getTypeDescByName(sm.getMetaData().getDescribedType().getName());
        Object[] ids = ApplicationIds.toPKValues((Object)sm.getObjectId(), (ClassMetaData)sm.getMetaData());
        int readModifier = this._transaction != null ? this.getConfiguration().getReadModifier() : 0;
        ITemplatePacket template = typeDescriptor.isAutoGenerateId() ? TemplatePacketFactory.createUidPacket((String)((String)ids[0]), null, (int)0, (QueryResultTypeInternal)QueryResultTypeInternal.OBJECT_JAVA) : TemplatePacketFactory.createIdPacket((Object)ids[0], null, (int)0, (ITypeDesc)typeDescriptor, (QueryResultTypeInternal)QueryResultTypeInternal.OBJECT_JAVA, null);
        IEntryPacket result = (IEntryPacket)proxy.read((Object)template, this._transaction, 0L, readModifier);
        return result;
    }

    public boolean load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object context) {
        ClassMetaData cm = sm.getMetaData();
        StateManager stateManager = (StateManager)sm;
        SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo((Class)cm.getDescribedType());
        StateManager gsm = (StateManager)sm;
        try {
            if (!gsm.isCleared()) {
                this.loadSpecificFields(sm, fields, typeInfo);
                return true;
            }
            if (stateManager.getOwnerStateManager() == null) {
                IEntryPacket entry = this.readObjectFromSpace(sm);
                if (entry == null) {
                    return false;
                }
                this.loadFields(sm, entry, cm.getFields());
                this.loadSpecificFields(sm, fields, typeInfo);
                return true;
            }
            Stack<StateManager> sms = new Stack<StateManager>();
            StateManager stateManagerToRead = stateManager;
            while (stateManagerToRead.getOwnerStateManager() != null) {
                sms.push(stateManagerToRead);
                stateManagerToRead = stateManagerToRead.getOwnerStateManager();
            }
            IEntryPacket entry = this.readObjectFromSpace((OpenJPAStateManager)stateManagerToRead);
            if (entry == null) {
                return false;
            }
            IEntryPacket foundEntryPacket = this._relationsManager.findObjectInEntry(stateManagerToRead, entry, sms);
            if (foundEntryPacket == null) {
                return false;
            }
            this.loadFields(sm, foundEntryPacket, sm.getMetaData().getFields());
            this.loadSpecificFields(sm, fields, typeInfo);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void loadSpecificFields(OpenJPAStateManager sm, BitSet fields, SpaceTypeInfo typeInfo) {
        for (FieldMetaData fmd : sm.getMetaData().getFields()) {
            if (!fields.get(fmd.getIndex())) continue;
            Object instance = sm.getManagedInstance();
            ((PersistenceCapable)instance).pcReplaceStateManager(null);
            Object value = typeInfo.getProperty(fmd.getName()).getValue(sm.getManagedInstance());
            ((PersistenceCapable)instance).pcReplaceStateManager((org.apache.openjpa.enhance.StateManager)sm);
            if (fmd.getAssociationType() == 2) {
                this.loadOneToManyObjects(fmd, sm, value);
                continue;
            }
            if (fmd.getAssociationType() == 1) {
                this.loadOneToOneObject(fmd, sm, value);
                continue;
            }
            if (!fmd.isEmbeddedPC()) continue;
            this.loadEmbeddedObject(fmd, sm, value);
        }
    }

    public ResultObjectProvider executeExtent(ClassMetaData classmetadata, boolean flag, FetchConfiguration fetchconfiguration) {
        return null;
    }

    protected Collection flush(Collection pNew, Collection pNewUpdated, Collection pNewFlushedDeleted, Collection pDirty, Collection pDeleted) {
        if (this.getContext().getBroker().getOptimistic() && this._transaction == null) {
            this.begin();
        }
        IJSpace space = this.getConfiguration().getSpace();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (this._relationsManager.shouldInitializeClassesRelationStatus()) {
            this._relationsManager.initializeClassesRelationStatus();
        }
        if (pNew.size() > 0) {
            this.handleNewObjects(pNew, space);
        }
        if (pDirty.size() > 0) {
            this.handleUpdatedObjects(pDirty, exceptions, space);
        }
        if (pDeleted.size() > 0) {
            this.handleDeletedObjects(pDeleted, exceptions, space);
        }
        return exceptions;
    }

    private void handleDeletedObjects(Collection<OpenJPAStateManager> sms, ArrayList<Exception> exceptions, IJSpace space) {
        for (OpenJPAStateManager sm : sms) {
            ClassMetaData cm = sm.getMetaData();
            if (_classesRelationStatus.containsKey(cm.getDescribedType())) continue;
            try {
                Object[] ids = ApplicationIds.toPKValues((Object)sm.getObjectId(), (ClassMetaData)cm);
                ISpaceProxy proxy = (ISpaceProxy)space;
                ITypeDesc typeDescriptor = proxy.getDirectProxy().getTypeManager().getTypeDescByName(sm.getMetaData().getDescribedType().getName());
                Object routing = sm.fetch(typeDescriptor.getRoutingPropertyId());
                ITemplatePacket template = typeDescriptor.isAutoGenerateId() ? TemplatePacketFactory.createUidPacket((String)((String)ids[0]), (Object)routing, (int)0, (QueryResultTypeInternal)QueryResultTypeInternal.OBJECT_JAVA) : TemplatePacketFactory.createIdPacket((Object)ids[0], (Object)routing, (int)0, (ITypeDesc)typeDescriptor, (QueryResultTypeInternal)QueryResultTypeInternal.OBJECT_JAVA, null);
                int result = proxy.clear((Object)template, this._transaction, 0);
                if (result == 1) continue;
                throw new Exception("Unable to clear object from space.");
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdatedObjects(Collection<OpenJPAStateManager> sms, ArrayList<Exception> exceptions, IJSpace space) {
        HashSet<OpenJPAStateManager> stateManagersToRestore = new HashSet<OpenJPAStateManager>();
        for (OpenJPAStateManager sm : sms) {
            ClassMetaData cm = sm.getMetaData();
            try {
                if (_classesRelationStatus.containsKey(cm.getDescribedType())) {
                    FieldOwnerInformation ownerInformation = this._relationsManager.getStateManagerToUpdate((StateManager)sm);
                    IEntryPacket entry = this.getEntryPacketFromStateManager(space, (OpenJPAStateManager)ownerInformation.getStateManager());
                    for (FieldMetaData fmd : cm.getFields()) {
                        this._relationsManager.initializeOwnerReferencesForField((StateManager)sm, fmd);
                    }
                    this._relationsManager.removeOwnedEntitiesStateManagers(stateManagersToRestore, (OpenJPAStateManager)ownerInformation.getStateManager());
                    if (ownerInformation.getStateManager().getVersion() != null) {
                        entry.setVersion(((Integer)ownerInformation.getStateManager().getVersion()).intValue());
                    }
                    FieldMetaData[] fmds = ownerInformation.getStateManager().getMetaData().getFields();
                    int spacePropertyIndex = -1;
                    int routingPropertyIndex = entry.getTypeDescriptor().getRoutingPropertyId();
                    for (int i = 0; i < fmds.length; ++i) {
                        if (fmds[i].isVersion() || i == ownerInformation.getMetaData().getIndex() || fmds[i].isPrimaryKey() || ++spacePropertyIndex == routingPropertyIndex) continue;
                        entry.setFieldValue(spacePropertyIndex, null);
                    }
                    space.write((Object)entry, this._transaction, Long.MAX_VALUE, 0L, 16);
                    ownerInformation.getStateManager().setVersion(entry.getVersion());
                    continue;
                }
                IEntryPacket entry = this.getEntryPacketFromStateManager(space, sm);
                FieldMetaData[] fmds = cm.getFields();
                int spacePropertyIndex = -1;
                int routingPropertyIndex = entry.getTypeDescriptor().getRoutingPropertyId();
                for (int i = 0; i < fmds.length; ++i) {
                    if (fmds[i].isVersion()) continue;
                    if (!sm.getDirty().get(i) && !fmds[i].isPrimaryKey() && ++spacePropertyIndex != routingPropertyIndex) {
                        entry.setFieldValue(spacePropertyIndex, null);
                        continue;
                    }
                    this._relationsManager.initializeOwnerReferencesForField((StateManager)sm, fmds[i]);
                }
                if (sm.getVersion() != null) {
                    entry.setVersion(((Integer)sm.getVersion()).intValue());
                }
                space.write((Object)entry, this._transaction, Long.MAX_VALUE, 0L, 16);
                sm.setVersion((Object)entry.getVersion());
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            finally {
                this._relationsManager.restoreRemovedStateManagers(stateManagersToRestore);
            }
        }
    }

    private IEntryPacket getEntryPacketFromStateManager(IJSpace space, OpenJPAStateManager sm) {
        try {
            IEntryPacket entry;
            ISpaceProxy proxy = (ISpaceProxy)space;
            sm.getPersistenceCapable().pcReplaceStateManager(null);
            IEntryPacket iEntryPacket = entry = proxy.getDirectProxy().getTypeManager().getEntryPacketFromObject(sm.getManagedInstance(), ObjectType.POJO);
            return iEntryPacket;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            sm.getPersistenceCapable().pcReplaceStateManager((org.apache.openjpa.enhance.StateManager)sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEntryPacket getEntryPacketFromEntity(Object entity) {
        IEntryPacket entry;
        PersistenceCapable pc = (PersistenceCapable)entity;
        ISpaceProxy proxy = (ISpaceProxy)this.getConfiguration().getSpace();
        if (pc.pcGetStateManager() != null) {
            OpenJPAStateManager sm = (OpenJPAStateManager)pc.pcGetStateManager();
            try {
                pc.pcReplaceStateManager(null);
                entry = proxy.getDirectProxy().getTypeManager().getEntryPacketFromObject(entity, ObjectType.POJO);
            }
            finally {
                pc.pcReplaceStateManager((org.apache.openjpa.enhance.StateManager)sm);
            }
        } else {
            entry = proxy.getDirectProxy().getTypeManager().getEntryPacketFromObject(entity, ObjectType.POJO);
        }
        return entry;
    }

    private void handleNewObjects(Collection<OpenJPAStateManager> sms, IJSpace space) {
        HashMap<Class, ArrayList<Object>> objectsToWriteByType = new HashMap<Class, ArrayList<Object>>();
        ArrayList<OpenJPAStateManager> stateManagersToRestore = new ArrayList<OpenJPAStateManager>();
        Class previousType = null;
        ArrayList<Object> currentList = null;
        for (OpenJPAStateManager openJPAStateManager : sms) {
            if (_classesRelationStatus.containsKey(openJPAStateManager.getMetaData().getDescribedType())) continue;
            this._relationsManager.removeOwnedEntitiesStateManagers(stateManagersToRestore, openJPAStateManager);
            if (!openJPAStateManager.getMetaData().getDescribedType().equals(previousType)) {
                currentList = (ArrayList<Object>)objectsToWriteByType.get(openJPAStateManager.getMetaData().getDescribedType());
                if (currentList == null) {
                    currentList = new ArrayList<Object>();
                    objectsToWriteByType.put(openJPAStateManager.getMetaData().getDescribedType(), currentList);
                }
                previousType = openJPAStateManager.getMetaData().getDescribedType();
            }
            openJPAStateManager.getPersistenceCapable().pcReplaceStateManager(null);
            stateManagersToRestore.add(openJPAStateManager);
            currentList.add(openJPAStateManager.getManagedInstance());
        }
        try {
            for (Map.Entry entry : objectsToWriteByType.entrySet()) {
                space.writeMultiple(((ArrayList)entry.getValue()).toArray(), this._transaction, Long.MAX_VALUE, 4);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this._relationsManager.restoreRemovedStateManagers(stateManagersToRestore);
        }
        if (this.getConfiguration().getOptimistic()) {
            for (Map.Entry entry : objectsToWriteByType.entrySet()) {
                Object obj;
                PersistenceCapable pc;
                OpenJPAStateManager sm;
                Iterator iterator = ((ArrayList)entry.getValue()).iterator();
                while (iterator.hasNext() && (sm = (OpenJPAStateManager)(pc = (PersistenceCapable)(obj = iterator.next())).pcGetStateManager()).getMetaData().getVersionField() != null) {
                    Object version = sm.fetch(sm.getMetaData().getVersionField().getIndex());
                    sm.setVersion(version);
                }
            }
        }
    }

    private void validateClassAnnotations(Class<?> type) {
        if (type.getAnnotation(Entity.class) == null) {
            return;
        }
        for (Method getter : type.getMethods()) {
            GeneratedValue generatedValue;
            boolean hasJpaId;
            if (!getter.getName().startsWith("get")) continue;
            SpaceId spaceId = getter.getAnnotation(SpaceId.class);
            boolean bl = hasJpaId = getter.getAnnotation(Id.class) != null || getter.getAnnotation(EmbeddedId.class) != null;
            if (spaceId == null && !hasJpaId) continue;
            if (!hasJpaId || spaceId == null) {
                throw new IllegalArgumentException("SpaceId and Id annotations must both be declared on the same property in JPA entities in type: " + type.getName());
            }
            if (!spaceId.autoGenerate() || (generatedValue = getter.getAnnotation(GeneratedValue.class)) != null && generatedValue.strategy() == GenerationType.IDENTITY) break;
            throw new IllegalArgumentException("SpaceId with autoGenerate=true annotated property should also have a JPA GeneratedValue annotation with strategy = GenerationType.IDENTITY.");
        }
    }

    public Object loadObject(ClassMetaData classMetaData, IEntryPacket entry) {
        Object[] ids = new Object[]{entry.getID()};
        Object objectId = ApplicationIds.fromPKValues((Object[])ids, (ClassMetaData)classMetaData);
        return this.getContext().find(objectId, null, null, (Object)entry, 0);
    }

    public Transaction getCurrentTransaction() {
        return this._transaction;
    }

    public GConnection getJdbcConnection() throws SQLException {
        if (this._connection == null) {
            Properties connectionProperties = new Properties();
            connectionProperties.put("com.gigaspaces.embeddedQP.enabled", "true");
            this._connection = GConnection.getInstance((IJSpace)this.getConfiguration().getSpace(), (Properties)connectionProperties);
            if (this._connection.getAutoCommit()) {
                this._connection.setAutoCommit(false);
            }
        }
        return this._connection;
    }

    public synchronized int getClassRelationStatus(Class<?> type) {
        Integer relationStatus;
        if (this._relationsManager.shouldInitializeClassesRelationStatus()) {
            this._relationsManager.initializeClassesRelationStatus();
        }
        return (relationStatus = _classesRelationStatus.get(type)) == null ? 0 : relationStatus;
    }

    private class RelationsManager {
        public void removeOwnedEntitiesStateManagers(Collection<OpenJPAStateManager> stateManagersToRestore, OpenJPAStateManager sm) {
            for (FieldMetaData fmd : sm.getMetaData().getFields()) {
                OpenJPAStateManager stateManager;
                Object pc;
                Object value;
                if (!sm.getLoaded().get(fmd.getIndex())) continue;
                if (fmd.isEmbeddedPC()) {
                    value = sm.fetch(fmd.getDeclaredIndex());
                    if (value == null) continue;
                    pc = (PersistenceCapable)value;
                    stateManager = (OpenJPAStateManager)pc.pcGetStateManager();
                    this.removeOwnedEntitiesStateManagers(stateManagersToRestore, stateManager);
                    pc.pcReplaceStateManager(null);
                    stateManagersToRestore.add(stateManager);
                    continue;
                }
                if (fmd.getAssociationType() == 2 || this.isPersistentCollection(fmd)) {
                    Collection collection = (Collection)sm.fetch(fmd.getIndex());
                    if (collection == null) continue;
                    for (Object item : collection) {
                        PersistenceCapable pc2 = (PersistenceCapable)item;
                        OpenJPAStateManager stateManager2 = (OpenJPAStateManager)pc2.pcGetStateManager();
                        if (stateManager2 == null) continue;
                        this.setOwnerStateManagerForPersistentInstance(item, sm, fmd);
                        this.removeOwnedEntitiesStateManagers(stateManagersToRestore, stateManager2);
                        stateManagersToRestore.add(stateManager2);
                        pc2.pcReplaceStateManager(null);
                    }
                    continue;
                }
                if (fmd.getAssociationType() != 1 || (value = sm.fetch(fmd.getIndex())) == null) continue;
                this.setOwnerStateManagerForPersistentInstance(value, sm, fmd);
                pc = (PersistenceCapable)value;
                stateManager = (OpenJPAStateManager)pc.pcGetStateManager();
                this.removeOwnedEntitiesStateManagers(stateManagersToRestore, stateManager);
                stateManagersToRestore.add(stateManager);
                pc.pcReplaceStateManager(null);
            }
        }

        private boolean isPersistentCollection(FieldMetaData fmd) {
            return Collection.class.isAssignableFrom(fmd.getDeclaredType()) && fmd.getElement() != null && PersistenceCapable.class.isAssignableFrom(fmd.getElement().getDeclaredType());
        }

        public void setOwnerStateManagerForPersistentInstance(Object managedObject, OpenJPAStateManager sm, FieldMetaData fmd) {
            StateManager stateManager = (StateManager)((PersistenceCapable)managedObject).pcGetStateManager();
            if (stateManager == null) {
                throw new IllegalStateException("Attempted to set an Owner back-reference for an unmanaged instance: " + managedObject.toString() + " of type: " + managedObject.getClass().getName());
            }
            stateManager.setOwnerInformation((StateManager)sm, fmd);
        }

        public void initializeOwnerReferencesForField(StateManager sm, FieldMetaData fmd) {
            Object value;
            if (fmd.getAssociationType() == 2) {
                Collection collection = (Collection)sm.fetch(fmd.getIndex());
                if (collection != null) {
                    for (Object item : collection) {
                        if (item == null) continue;
                        StoreManager.this._relationsManager.setOwnerStateManagerForPersistentInstance(item, (OpenJPAStateManager)sm, fmd);
                    }
                }
            } else if ((fmd.getAssociationType() == 1 || fmd.isEmbeddedPC()) && (value = sm.fetch(fmd.getIndex())) != null) {
                StoreManager.this._relationsManager.setOwnerStateManagerForPersistentInstance(value, (OpenJPAStateManager)sm, fmd);
            }
        }

        public FieldOwnerInformation getStateManagerToUpdate(StateManager sm) {
            block7: {
                StateManager ownerStateManager;
                Integer associationType;
                block8: {
                    associationType = (Integer)_classesRelationStatus.get(sm.getMetaData().getDescribedType());
                    if (associationType == null) {
                        throw new IllegalStateException("Error updating: " + sm.getMetaData().getClass().getName() + " with id: " + sm.getId());
                    }
                    ownerStateManager = sm.getOwnerStateManager();
                    if (ownerStateManager == null) break block7;
                    if (associationType != 2) break block8;
                    for (FieldMetaData fmd : ownerStateManager.getMetaData().getFields()) {
                        if (!fmd.getElement().getDeclaredType().equals(sm.getMetaData().getDescribedType())) continue;
                        Collection collection = (Collection)ownerStateManager.fetch(fmd.getIndex());
                        if (collection != null && collection.contains(sm.getManagedInstance())) {
                            if (ownerStateManager.getOwnerStateManager() != null) {
                                return this.getStateManagerToUpdate(ownerStateManager);
                            }
                            return new FieldOwnerInformation(ownerStateManager, fmd);
                        }
                        break block7;
                    }
                    break block7;
                }
                if (associationType != 1) break block7;
                for (FieldMetaData fmd : ownerStateManager.getMetaData().getFields()) {
                    if (!fmd.getDeclaredType().equals(sm.getMetaData().getDescribedType())) continue;
                    Object value = ownerStateManager.fetch(fmd.getIndex());
                    if (value != null && value.equals(sm.getManagedInstance())) {
                        if (ownerStateManager.getOwnerStateManager() != null) {
                            return this.getStateManagerToUpdate(ownerStateManager);
                        }
                        return new FieldOwnerInformation(ownerStateManager, fmd);
                    }
                    break;
                }
            }
            throw new IllegalStateException("Attempted to update an owned entity: " + sm.getMetaData().getClass().getName() + " with Id: " + sm.getId() + " which has no owner.");
        }

        public void restoreRemovedStateManagers(Collection<OpenJPAStateManager> stateManagersToRestore) {
            for (OpenJPAStateManager sm : stateManagersToRestore) {
                sm.getPersistenceCapable().pcReplaceStateManager((org.apache.openjpa.enhance.StateManager)sm);
            }
        }

        public synchronized void initializeClassesRelationStatus() {
            ClassMetaData[] cms;
            if (!this.shouldInitializeClassesRelationStatus()) {
                return;
            }
            for (ClassMetaData cm : cms = StoreManager.this.getConfiguration().getMetaDataRepositoryInstance().getMetaDatas()) {
                if (_processedClasses.contains(cm.getDescribedType())) continue;
                for (FieldMetaData fmd : cm.getFields()) {
                    if (fmd.getAssociationType() == 1) {
                        if (_classesRelationStatus.containsKey(fmd.getDeclaredType())) continue;
                        _classesRelationStatus.put(fmd.getDeclaredType(), 1);
                        continue;
                    }
                    if (fmd.getAssociationType() == 2) {
                        if (_classesRelationStatus.containsKey(fmd.getDeclaredType())) continue;
                        _classesRelationStatus.put(fmd.getElement().getDeclaredType(), 2);
                        continue;
                    }
                    if (fmd.getAssociationType() != 4) continue;
                    throw new IllegalArgumentException("Many-to-many is not supported.");
                }
                StoreManager.this.validateClassAnnotations(cm.getDescribedType());
                _processedClasses.add(cm.getDescribedType());
            }
        }

        public boolean shouldInitializeClassesRelationStatus() {
            return StoreManager.this.getConfiguration().getMetaDataRepositoryInstance().getMetaDatas().length != _processedClasses.size();
        }

        public IEntryPacket findObjectInEntry(StateManager sm, IEntryPacket entry, Stack<StateManager> sms) {
            StateManager tempStateManager = sms.pop();
            SpaceTypeInfo ownedTypeInfo = SpaceTypeInfoRepository.getTypeInfo((Class)tempStateManager.getMetaData().getDescribedType());
            FieldMetaData[] fms = sm.getMetaData().getFields();
            FieldMetaData fmd = tempStateManager.getOwnerMetaData();
            if (fmd == null) {
                throw new IllegalStateException("Owner field meta data is not set for entity of type: " + tempStateManager.getMetaData().getDescribedType().getName() + " with Id: " + tempStateManager.getId());
            }
            int spacePropertyIndex = -1;
            for (int i = 0; i <= fmd.getIndex(); ++i) {
                if (fms[i].isVersion()) continue;
                ++spacePropertyIndex;
            }
            if (fmd.getAssociationType() == 2) {
                Object id = ApplicationIds.toPKValues((Object)tempStateManager.getId(), (ClassMetaData)tempStateManager.getMetaData())[0];
                Collection values = (Collection)entry.getFieldValue(spacePropertyIndex);
                if (values != null) {
                    for (Object item : values) {
                        Object itemId = ownedTypeInfo.getIdProperty().getValue(item);
                        if (!id.equals(itemId)) continue;
                        IEntryPacket entryPacket = StoreManager.this.getEntryPacketFromEntity(item);
                        return sms.isEmpty() ? entryPacket : this.findObjectInEntry(tempStateManager, entryPacket, sms);
                    }
                }
            } else if (fmd.getAssociationType() == 1) {
                Object objectId;
                Object id = ApplicationIds.toPKValues((Object)tempStateManager.getId(), (ClassMetaData)tempStateManager.getMetaData())[0];
                Object value = entry.getFieldValue(spacePropertyIndex);
                if (value != null && id.equals(objectId = ownedTypeInfo.getIdProperty().getValue(value))) {
                    IEntryPacket entryPacket = StoreManager.this.getEntryPacketFromEntity(value);
                    return sms.isEmpty() ? entryPacket : this.findObjectInEntry(tempStateManager, entryPacket, sms);
                }
            } else if (fmd.isEmbeddedPC()) {
                Object value = entry.getFieldValue(spacePropertyIndex);
                IEntryPacket entryPacket = StoreManager.this.getEntryPacketFromEntity(value);
                return sms.isEmpty() ? entryPacket : this.findObjectInEntry(tempStateManager, entryPacket, sms);
            }
            return null;
        }
    }

    private static class FieldOwnerInformation {
        private StateManager stateManager;
        private FieldMetaData metaData;

        public FieldOwnerInformation(StateManager stateManager, FieldMetaData metaData) {
            this.stateManager = stateManager;
            this.metaData = metaData;
        }

        public StateManager getStateManager() {
            return this.stateManager;
        }

        public FieldMetaData getMetaData() {
            return this.metaData;
        }
    }
}

