/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa.openjpa;

import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.client.transaction.TransactionManagerConfiguration;
import com.gigaspaces.client.transaction.TransactionManagerProviderFactory;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.j_spaces.core.IJSpace;
import net.jini.core.transaction.server.TransactionManager;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.lib.conf.Value;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.space.UrlSpaceConfigurer;
import org.openspaces.jpa.openjpa.Broker;
import org.openspaces.remoting.ExecutorRemotingProxyConfigurer;
import org.openspaces.remoting.scripting.ScriptingExecutor;

public class SpaceConfiguration
extends OpenJPAConfigurationImpl {
    private static final long serialVersionUID = -61291372655467023L;
    private IJSpace _space;
    private ITransactionManagerProvider _transactionManagerProvider;
    private int _readModifier;
    private ScriptingExecutor<?> _scriptingExecutor;

    public SpaceConfiguration() {
        this.supportedOptions().add("openjpa.option.Optimistic");
        this.supportedOptions().add("openjpa.option.IncrementalFlush");
        this.setLockTimeout(0);
        this.setLockManager("none");
        this.setDynamicEnhancementAgent(false);
        this._readModifier = 0;
    }

    public void initialize() {
        if (this._space == null) {
            Value configurationValue = this.getValue("ConnectionFactory");
            this._space = configurationValue != null && configurationValue.get() != null ? (IJSpace)configurationValue.get() : new UrlSpaceConfigurer(this.getConnectionURL()).space();
            if (this.getOptimistic()) {
                this._space.setOptimisticLocking(true);
            }
        }
        TransactionManagerConfiguration configuration = new TransactionManagerConfiguration(ITransactionManagerProvider.TransactionManagerType.DISTRIBUTED);
        try {
            this._transactionManagerProvider = TransactionManagerProviderFactory.newInstance((IJSpace)this._space, (TransactionManagerConfiguration)configuration);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this._readModifier = this.getReadLockLevel().equals("write") ? 512 : (this.getOptimistic() ? 8192 : 0);
    }

    public IJSpace getSpace() {
        return this._space;
    }

    public TransactionManager getTransactionManager() {
        return this._transactionManagerProvider.getTransactionManager();
    }

    public int getReadModifier() {
        return this._readModifier;
    }

    public void setConnectionFactory(Object space) {
        this._space = (IJSpace)space;
    }

    public BrokerImpl newBrokerInstance(String user, String pass) {
        return new Broker();
    }

    public ScriptingExecutor<?> getScriptingExecutorProxy() {
        if (this._scriptingExecutor == null) {
            this.initializeScriptingExecutorProxy();
        }
        return this._scriptingExecutor;
    }

    private synchronized void initializeScriptingExecutorProxy() {
        if (this._scriptingExecutor == null) {
            boolean clustered = ((ISpaceProxy)this.getSpace()).isClustered();
            GigaSpace gigaSpace = new GigaSpaceConfigurer(this.getSpace()).clustered(clustered).gigaSpace();
            this._scriptingExecutor = (ScriptingExecutor)new ExecutorRemotingProxyConfigurer(gigaSpace, ScriptingExecutor.class).proxy();
        }
    }
}

